/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.shaders.BlockAliases;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomBlockLayers {
    private static ahm[] renderLayers = null;
    public static boolean active = false;

    public static ahm getRenderLayer(ard blockState) {
        if (renderLayers == null) {
            return null;
        }
        if (blockState.p()) {
            return null;
        }
        if (!(blockState instanceof ara)) {
            return null;
        }
        ara bsb = (ara)blockState;
        int id = bsb.getBlockId();
        if (id <= 0 || id >= renderLayers.length) {
            return null;
        }
        return renderLayers[id];
    }

    public static void update() {
        PropertiesOrdered propsShaders;
        renderLayers = null;
        active = false;
        ArrayList<ahm> list = new ArrayList<ahm>();
        String pathProps = "optifine/block.properties";
        Properties props = ResUtils.readProperties(pathProps, "CustomBlockLayers");
        if (props != null) {
            CustomBlockLayers.readLayers(pathProps, props, list);
        }
        if (Config.isShaders() && (propsShaders = BlockAliases.getBlockLayerPropertes()) != null) {
            String pathPropsShaders = "shaders/block.properties";
            CustomBlockLayers.readLayers(pathPropsShaders, propsShaders, list);
        }
        if (list.isEmpty()) {
            return;
        }
        renderLayers = list.toArray(new ahm[list.size()]);
        active = true;
    }

    private static void readLayers(String pathProps, Properties props, List<ahm> list) {
        Config.dbg("CustomBlockLayers: " + pathProps);
        CustomBlockLayers.readLayer("solid", ahm.a, props, list);
        CustomBlockLayers.readLayer("cutout", ahm.c, props, list);
        CustomBlockLayers.readLayer("cutout_mipped", ahm.b, props, list);
        CustomBlockLayers.readLayer("translucent", ahm.d, props, list);
    }

    private static void readLayer(String name, ahm layer, Properties props, List<ahm> listLayers) {
        String key = "layer." + name;
        String val = props.getProperty(key);
        if (val == null) {
            return;
        }
        ConnectedParser cp = new ConnectedParser("CustomBlockLayers");
        MatchBlock[] mbs = cp.parseMatchBlocks(val);
        if (mbs == null) {
            return;
        }
        for (int i = 0; i < mbs.length; ++i) {
            MatchBlock mb = mbs[i];
            int blockId = mb.getBlockId();
            if (blockId <= 0) continue;
            while (listLayers.size() < blockId + 1) {
                listLayers.add(null);
            }
            if (listLayers.get(blockId) != null) {
                Config.warn("CustomBlockLayers: Block layer is already set, block: " + blockId + ", layer: " + name);
            }
            listLayers.set(blockId, layer);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

