/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.List;

public class RenderStateManager {
    private static boolean cacheEnabled;
    private static final eaf[] PENDING_CLEAR_STATES;

    public static void setupRenderStates(List<eaf> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.setupCached(renderStates);
            return;
        }
        renderStates.forEach(eaf::a);
    }

    public static void clearRenderStates(List<eaf> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.clearCached(renderStates);
            return;
        }
        renderStates.forEach(eaf::b);
    }

    private static void setupCached(List<eaf> renderStates) {
        for (int i = 0; i < renderStates.size(); ++i) {
            eaf state = renderStates.get(i);
            RenderStateManager.setupCached(state, i);
        }
    }

    private static void clearCached(List<eaf> renderStates) {
        for (int i = 0; i < renderStates.size(); ++i) {
            eaf state = renderStates.get(i);
            RenderStateManager.clearCached(state, i);
        }
    }

    private static void setupCached(eaf state, int index) {
        eaf pendingClearState = PENDING_CLEAR_STATES[index];
        if (pendingClearState != null) {
            if (state == pendingClearState) {
                RenderStateManager.PENDING_CLEAR_STATES[index] = null;
                return;
            }
            pendingClearState.b();
            RenderStateManager.PENDING_CLEAR_STATES[index] = null;
        }
        state.a();
    }

    private static void clearCached(eaf state, int index) {
        eaf pendingClearState = PENDING_CLEAR_STATES[index];
        if (pendingClearState != null) {
            pendingClearState.b();
        }
        RenderStateManager.PENDING_CLEAR_STATES[index] = state;
    }

    public static void enableCache() {
        if (cacheEnabled) {
            return;
        }
        cacheEnabled = true;
        Arrays.fill(PENDING_CLEAR_STATES, null);
    }

    public static void disableCache() {
        if (!cacheEnabled) {
            return;
        }
        cacheEnabled = false;
        for (int i = 0; i < PENDING_CLEAR_STATES.length; ++i) {
            eaf pendingClearState = PENDING_CLEAR_STATES[i];
            if (pendingClearState == null) continue;
            pendingClearState.b();
        }
        Arrays.fill(PENDING_CLEAR_STATES, null);
    }

    static {
        PENDING_CLEAR_STATES = new eaf[eag.getCountRenderStates()];
    }
}

