/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static elg makeModelCube(String spriteName, int tintIndex) {
        eju sprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static elg makeModelCube(eju sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        gc[] facings = gc.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            gc facing = facings[i];
            ArrayList<eas> quads = new ArrayList<eas>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        ebc itemOverrideList = ebc.a;
        elp bakedModel = new elp(generalQuads, faceQuads, true, true, true, sprite, ebe.a, itemOverrideList);
        return bakedModel;
    }

    public static elg joinModelsCube(elg modelBase, elg modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        gc[] facings = gc.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            gc facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.d();
        eju sprite = modelBase.e();
        ebe transforms = modelBase.f();
        ebc itemOverrideList = modelBase.g();
        elp bakedModel = new elp(generalQuads, faceQuads, ao, builtIn, true, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static eas makeBakedQuad(gc facing, eju sprite, int tintIndex) {
        g posFrom = new g(0.0f, 0.0f, 0.0f);
        g posTo = new g(16.0f, 16.0f, 16.0f);
        eaw uv2 = new eaw(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        eau face = new eau(facing, tintIndex, "#" + facing.a(), uv2);
        elh modelRotation = elh.a;
        eav partRotation = null;
        boolean shade = true;
        vk modelLoc = sprite.l();
        eaz faceBakery = new eaz();
        eas quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (eln)modelRotation, partRotation, shade, modelLoc);
        return quad;
    }

    public static elg makeModel(String modelName, String spriteOldName, String spriteNewName) {
        ejt textureMap = Config.getTextureMap();
        eju spriteOld = textureMap.getUploadedSprite(spriteOldName);
        eju spriteNew = textureMap.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static elg makeModel(String modelName, eju spriteOld, eju spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        ell modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        elm mrl = new elm(modelName, "");
        elg model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        elg modelNew = ModelUtils.duplicateModel(model);
        gc[] faces = gc.n;
        for (int i = 0; i < faces.length; ++i) {
            gc face = faces[i];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<eas> quads, eju spriteOld, eju spriteNew) {
        ArrayList<eas> quadsNew = new ArrayList<eas>();
        for (eas quad : quads) {
            if (quad.getSprite() == spriteOld) {
                quad = new BakedQuadRetextured(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(g pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x2) {
        if (x2 > -1.0E-6f && x2 < 1.0E-6f) {
            return 0.0f;
        }
        if (x2 > 0.999999f && x2 < 1.000001f) {
            return 1.0f;
        }
        return x2;
    }

    public static dcf getOffsetBoundingBox(dcf aabb, ced.b offsetType, fx pos) {
        int x2 = pos.u();
        int z = pos.w();
        long k = (long)(x2 * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == ced.b.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

