/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.Config;

public enum ModelVariableType {
    POS_X("tx"),
    POS_Y("ty"),
    POS_Z("tz"),
    ANGLE_X("rx"),
    ANGLE_Y("ry"),
    ANGLE_Z("rz"),
    SCALE_X("sx"),
    SCALE_Y("sy"),
    SCALE_Z("sz");

    private String name;
    public static ModelVariableType[] VALUES;

    private ModelVariableType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public float getFloat(dyg mr2) {
        switch (this) {
            case POS_X: {
                return mr2.a;
            }
            case POS_Y: {
                return mr2.b;
            }
            case POS_Z: {
                return mr2.c;
            }
            case ANGLE_X: {
                return mr2.d;
            }
            case ANGLE_Y: {
                return mr2.e;
            }
            case ANGLE_Z: {
                return mr2.f;
            }
            case SCALE_X: {
                return mr2.scaleX;
            }
            case SCALE_Y: {
                return mr2.scaleY;
            }
            case SCALE_Z: {
                return mr2.scaleZ;
            }
        }
        Config.warn("GetFloat not supported for: " + (Object)((Object)this));
        return 0.0f;
    }

    public void setFloat(dyg mr2, float val) {
        switch (this) {
            case POS_X: {
                mr2.a = val;
                return;
            }
            case POS_Y: {
                mr2.b = val;
                return;
            }
            case POS_Z: {
                mr2.c = val;
                return;
            }
            case ANGLE_X: {
                mr2.d = val;
                return;
            }
            case ANGLE_Y: {
                mr2.e = val;
                return;
            }
            case ANGLE_Z: {
                mr2.f = val;
                return;
            }
            case SCALE_X: {
                mr2.scaleX = val;
                return;
            }
            case SCALE_Y: {
                mr2.scaleY = val;
                return;
            }
            case SCALE_Z: {
                mr2.scaleZ = val;
                return;
            }
        }
        Config.warn("SetFloat not supported for: " + (Object)((Object)this));
    }

    public static ModelVariableType parse(String str) {
        for (int i = 0; i < VALUES.length; ++i) {
            ModelVariableType var = VALUES[i];
            if (!var.getName().equals(str)) continue;
            return var;
        }
        return null;
    }

    static {
        VALUES = ModelVariableType.values();
    }
}

