/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static elv spriteGrass = null;
    private static elv spriteGrassSide = null;
    private static elv spriteGrassPath = null;
    private static elv spriteGrassPathSide = null;
    private static elv spriteMycelium = null;
    private static elv spritePodzol = null;
    private static elv spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static enh modelCubeGrass = null;
    private static enh modelGrassPath = null;
    private static enh modelCubeGrassPath = null;
    private static enh modelCubeMycelium = null;
    private static enh modelCubePodzol = null;
    private static enh modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(elu textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            enh modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(elu textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new uh(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new uh(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new uh(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new uh(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new uh(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new uh(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new uh(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            uh locFile = new uh(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e2) {
            Config.warn("Error reading: " + name + ", " + e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    public static void refreshIcons(elu textureMap) {
        spriteGrass = BetterGrass.getSprite(textureMap, spriteGrass.l());
        spriteGrassSide = BetterGrass.getSprite(textureMap, spriteGrassSide.l());
        spriteGrassPath = BetterGrass.getSprite(textureMap, spriteGrassPath.l());
        spriteGrassPathSide = BetterGrass.getSprite(textureMap, spriteGrassPathSide.l());
        spriteMycelium = BetterGrass.getSprite(textureMap, spriteMycelium.l());
        spritePodzol = BetterGrass.getSprite(textureMap, spritePodzol.l());
        spriteSnow = BetterGrass.getSprite(textureMap, spriteSnow.l());
    }

    private static elv getSprite(elu textureMap, uh loc) {
        elv sprite = textureMap.a(loc);
        if (sprite == null || sprite instanceof elo) {
            Config.warn("Missing BetterGrass sprite: " + loc);
        }
        return sprite;
    }

    private static elv registerSprite(Properties props, String key, String textureDefault, elu textureMap) {
        uh locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new uh("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        uh locSprite = new uh(texture);
        elv sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(bpg blockAccess, cfj blockState, fu blockPos, fz facing, List quads) {
        if (facing == fz.b || facing == fz.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        bvr block = blockState.b();
        if (block instanceof bzl) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof byf) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bvs.l) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bvs.j) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bye) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(bpg blockAccess, cfj blockState, fu blockPos, fz facing, List quads) {
        boolean snowy;
        bvr blockUp = blockAccess.d_(blockPos.b()).b();
        boolean bl = snowy = blockUp == bvs.cE || blockUp == bvs.cC;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bvs.cC) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bvs.dT) {
                return modelCubeMycelium.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(bpg blockAccess, cfj blockState, fu blockPos, fz facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bvs.iE) {
                return modelGrassPath.a(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(bpg blockAccess, cfj blockState, fu blockPos, fz facing, List quads) {
        boolean snowy;
        bvr blockTop = BetterGrass.getBlockAt(blockPos, fz.b, blockAccess);
        boolean bl = snowy = blockTop == bvs.cE || blockTop == bvs.cC;
        if (Config.isBetterGrassFancy()) {
            fu posSide;
            cfj stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bvs.cC) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.d_(posSide = blockPos.c().a(facing))).b() == bvs.l) {
                return modelCubePodzol.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(bpg blockAccess, cfj blockState, fu blockPos, fz facing, List quads) {
        bvr blockTop = BetterGrass.getBlockAt(blockPos, fz.b, blockAccess);
        if (blockTop == bvs.iE && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bvs.iE) {
            return modelCubeGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(bpg blockAccess, cfj blockState, fu blockPos, fz facing, List quads) {
        boolean snowy;
        bvr blockUp = blockAccess.d_(blockPos.b()).b();
        boolean bl = snowy = blockUp == bvs.cE || blockUp == bvs.cC;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bvs.cC) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bvs.i) {
                return modelCubeGrass.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static bvr getBlockAt(fu blockPos, fz facing, bpg blockAccess) {
        fu pos = blockPos.a(facing);
        bvr block = blockAccess.d_(pos).b();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

