/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private aio entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<ew> setLitChunkPos = new HashSet<ew>();
    private ew.a blockPosMutable = new ew.a();

    public DynamicLight(aio entity) {
        this.entity = entity;
        this.offsetY = entity.bN();
    }

    public void update(dng renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.p - 0.5;
        double posY = this.entity.q - 0.5 + this.offsetY;
        double posZ = this.entity.r - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<ew> setNewPos = new HashSet<ew>();
        if (lightLevel > 0) {
            fb dirX = (zy.c((double)posX) & 0xF) >= 8 ? fb.f : fb.e;
            fb dirY = (zy.c((double)posY) & 0xF) >= 8 ? fb.b : fb.a;
            fb dirZ = (zy.c((double)posZ) & 0xF) >= 8 ? fb.d : fb.c;
            ew chunkPos = new ew(posX, posY, posZ);
            dpy chunk = renderGlobal.getRenderChunk(chunkPos);
            ew chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            dpy chunkX = renderGlobal.getRenderChunk(chunkPosX);
            ew chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            dpy chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            ew chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            dpy chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            ew chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            dpy chunkY = renderGlobal.getRenderChunk(chunkPosY);
            ew chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            dpy chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            ew chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            dpy chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            ew chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            dpy chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private ew getChunkPos(dpy renderChunk, ew pos, fb facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(dpy renderChunk, Set<ew> setPrevPos, Set<ew> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        dpw compiledChunk = renderChunk.h();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        ew pos = renderChunk.k().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(dng renderGlobal) {
        for (ew posOld : this.setLitChunkPos) {
            dpy chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public aio getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

