/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import optifine.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class OptiFineTransformer
implements ITransformer<ClassNode> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ZipFile ofZipFile;

    public OptiFineTransformer(ZipFile ofZipFile) {
        this.ofZipFile = ofZipFile;
    }

    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        LOGGER.info("Vote: " + context.getClassName());
        return TransformerVoteResult.YES;
    }

    public Set<ITransformer.Target> targets() {
        LOGGER.info("Targets");
        HashSet<ITransformer.Target> set = new HashSet<ITransformer.Target>();
        List<String> names = this.getSrgNames();
        for (String name : names) {
            LOGGER.info(name);
            ITransformer.Target itt = ITransformer.Target.targetClass((String)name);
            set.add(itt);
        }
        return set;
    }

    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        LOGGER.info("Transform: " + context.getClassName());
        ClassNode classNode = input;
        String className = context.getClassName();
        String classNameZip = className.replace('.', '/');
        byte[] bytes = this.getOptiFineResource("deobf/" + classNameZip + ".class");
        if (bytes != null) {
            LOGGER.info("Loading: " + className);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ClassNode cn = this.loadClass(in);
            if (cn != null) {
                LOGGER.info("Original: " + className);
                this.debugClass(classNode);
                LOGGER.info("Transformed: " + className);
                this.debugClass(cn);
                classNode = cn;
            }
        }
        return classNode;
    }

    private void debugClass(ClassNode classNode) {
        LOGGER.info(classNode.name + ", fields: " + classNode.fields.size() + ", methods: " + classNode.methods.size());
    }

    private ClassNode loadClass(InputStream in) {
        try {
            ClassReader cr = new ClassReader(in);
            ClassNode cn = new ClassNode(393216);
            cr.accept((ClassVisitor)cn, 0);
            return cn;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private List<String> getSrgNames() {
        try {
            LOGGER.info("getSrgNames");
            byte[] bytes = this.getOptiFineResourceZip("srglist.txt");
            if (bytes == null) {
                return new ArrayList<String>();
            }
            LOGGER.info("srglist: " + bytes);
            ArrayList<String> names = new ArrayList<String>();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            String[] lines = Utils.readLines(in, "ASCII");
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                line = line.replace('\\', '/');
                line = Utils.removeSuffix(line, ".class");
                LOGGER.info(line);
                names.add(line);
                ++i;
            }
            LOGGER.info("Names: " + names);
            return names;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public synchronized byte[] getOptiFineResource(String name) {
        byte[] bytes = this.getOptiFineResourceZip(name = Utils.removePrefix(name, "/"));
        if (bytes != null) {
            return bytes;
        }
        return null;
    }

    public synchronized byte[] getOptiFineResourceZip(String name) {
        byte[] bytes;
        block5: {
            if (this.ofZipFile == null) {
                return null;
            }
            ZipEntry ze2 = this.ofZipFile.getEntry(name = Utils.removePrefix(name, "/"));
            if (ze2 == null) {
                return null;
            }
            try {
                InputStream in = this.ofZipFile.getInputStream(ze2);
                bytes = Utils.readAll(in);
                in.close();
                if ((long)bytes.length == ze2.getSize()) break block5;
                LOGGER.info("Invalid size, name: " + name + ", zip: " + ze2.getSize() + ", stream: " + bytes.length);
                return null;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return null;
            }
        }
        return bytes;
    }
}

