/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.ArrayList;
import java.util.List;
import net.optifine.shaders.Program;
import net.optifine.shaders.ProgramStage;

public class Programs {
    private List<Program> programs = new ArrayList<Program>();
    private Program programNone = this.make("", ProgramStage.NONE, true);

    public Program make(String name, ProgramStage programStage, Program backupProgram) {
        int index = this.programs.size();
        Program prog = new Program(index, name, programStage, backupProgram);
        this.programs.add(prog);
        return prog;
    }

    private Program make(String name, ProgramStage programStage, boolean ownBackup) {
        int index = this.programs.size();
        Program prog = new Program(index, name, programStage, ownBackup);
        this.programs.add(prog);
        return prog;
    }

    public Program makeGbuffers(String name, Program backupProgram) {
        return this.make(name, ProgramStage.GBUFFERS, backupProgram);
    }

    public Program makeComposite(String name) {
        return this.make(name, ProgramStage.COMPOSITE, this.programNone);
    }

    public Program makeDeferred(String name) {
        return this.make(name, ProgramStage.DEFERRED, this.programNone);
    }

    public Program makeShadow(String name, Program backupProgram) {
        return this.make(name, ProgramStage.SHADOW, backupProgram);
    }

    public Program makeVirtual(String name) {
        return this.make(name, ProgramStage.NONE, true);
    }

    public Program[] makeComposites(String prefix, int count) {
        Program[] ps = new Program[count];
        for (int i = 0; i < count; ++i) {
            String name = i == 0 ? prefix : prefix + i;
            ps[i] = this.makeComposite(name);
        }
        return ps;
    }

    public Program[] makeDeferreds(String prefix, int count) {
        Program[] ps = new Program[count];
        for (int i = 0; i < count; ++i) {
            String name = i == 0 ? prefix : prefix + i;
            ps[i] = this.makeDeferred(name);
        }
        return ps;
    }

    public Program getProgramNone() {
        return this.programNone;
    }

    public int getCount() {
        return this.programs.size();
    }

    public Program getProgram(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.programs.size(); ++i) {
            Program p2 = this.programs.get(i);
            String progName = p2.getName();
            if (!progName.equals(name)) continue;
            return p2;
        }
        return null;
    }

    public String[] getProgramNames() {
        String[] names = new String[this.programs.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.programs.get(i).getName();
        }
        return names;
    }

    public Program[] getPrograms() {
        Program[] arr2 = this.programs.toArray(new Program[this.programs.size()]);
        return arr2;
    }

    public Program[] getPrograms(Program programFrom, Program programTo) {
        int iTo;
        int iFrom = programFrom.getIndex();
        if (iFrom > (iTo = programTo.getIndex())) {
            int i = iFrom;
            iFrom = iTo;
            iTo = i;
        }
        Program[] progs = new Program[iTo - iFrom + 1];
        for (int i = 0; i < progs.length; ++i) {
            progs[i] = this.programs.get(iFrom + i);
        }
        return progs;
    }

    public String toString() {
        return this.programs.toString();
    }
}

