/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");
    private static final Pattern PATTERN_NBT_TEXT = Pattern.compile(".*\"text\":\"([^\"]+)\".*");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(ib nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(ib nbt) {
        if (nbt == null) {
            return false;
        }
        ib tagBase = nbt;
        for (int i = 0; i < this.parents.length; ++i) {
            String tag = this.parents[i];
            if ((tagBase = NbtTagValue.getChildTag((is)tagBase, tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((is)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((is)tagBase, this.name)) == null) {
            return false;
        }
        return this.matchesBase((is)tagBase);
    }

    private boolean matchesAnyChild(is tagBase) {
        if (tagBase instanceof ib) {
            ib tagCompound = (ib)tagBase;
            Set nbtKeySet = tagCompound.c();
            for (String key : nbtKeySet) {
                is nbtBase = tagCompound.c(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof ii) {
            ii tagList = (ii)tagBase;
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                is nbtBase = tagList.k(i);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static is getChildTag(is tagBase, String tag) {
        if (tagBase instanceof ib) {
            ib tagCompound = (ib)tagBase;
            return tagCompound.c(tag);
        }
        if (tagBase instanceof ii) {
            ii tagList = (ii)tagBase;
            if (tag.equals("count")) {
                return new ih(tagList.size());
            }
            int index = Config.parseInt(tag, -1);
            if (index < 0) {
                return null;
            }
            return tagList.k(index);
        }
        return null;
    }

    public boolean matchesBase(is nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(is nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof ir) {
            Matcher matcher;
            ir nbtString = (ir)nbtBase;
            String text = nbtString.c_();
            if (text.startsWith("{") && (matcher = PATTERN_NBT_TEXT.matcher(text)).matches()) {
                return matcher.group(1);
            }
            return text;
        }
        if (nbtBase instanceof ih) {
            ih i = (ih)nbtBase;
            if (format == 1) {
                return PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(i.e()), 6, '0');
            }
            return Integer.toString(i.e());
        }
        if (nbtBase instanceof hz) {
            hz b2 = (hz)nbtBase;
            return Byte.toString(b2.g());
        }
        if (nbtBase instanceof iq) {
            iq s = (iq)nbtBase;
            return Short.toString(s.f());
        }
        if (nbtBase instanceof ik) {
            ik l2 = (ik)nbtBase;
            return Long.toString(l2.d());
        }
        if (nbtBase instanceof ie) {
            ie f = (ie)nbtBase;
            return Float.toString(f.i());
        }
        if (nbtBase instanceof ic) {
            ic d2 = (ic)nbtBase;
            return Double.toString(d2.h());
        }
        return nbtBase.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.parents.length; ++i) {
            String parent = this.parents[i];
            if (i > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

