/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityDataManager {
    private static final Logger field_190303_a = LogManager.getLogger();
    private static final Map<Class<? extends Entity>, Integer> field_187232_a = Maps.newHashMap();
    private final Entity field_187233_b;
    private final Map<Integer, DataEntry<?>> field_187234_c = Maps.newHashMap();
    private final ReadWriteLock field_187235_d = new ReentrantReadWriteLock();
    private boolean field_187236_e = true;
    private boolean field_187237_f;
    public Biome spawnBiome = Biomes.field_76772_c;
    public BlockPos spawnPosition = BlockPos.field_177992_a;

    public EntityDataManager(Entity entityIn) {
        this.field_187233_b = entityIn;
    }

    public static <T> DataParameter<T> func_187226_a(Class<? extends Entity> clazz, IDataSerializer<T> serializer) {
        int j;
        if (field_190303_a.isDebugEnabled()) {
            try {
                Class<?> oclass = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass.equals(clazz)) {
                    field_190303_a.debug("defineId called for: {} from {}", clazz, oclass, (Object)new RuntimeException());
                }
            }
            catch (ClassNotFoundException oclass) {
                // empty catch block
            }
        }
        if (field_187232_a.containsKey(clazz)) {
            j = (Integer)field_187232_a.get(clazz) + 1;
        } else {
            int i = 0;
            Class<? extends Entity> oclass1 = clazz;
            while (oclass1 != Entity.class) {
                if (!field_187232_a.containsKey(oclass1 = oclass1.getSuperclass())) continue;
                i = (Integer)field_187232_a.get(oclass1) + 1;
                break;
            }
            j = i;
        }
        if (j > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + j + "! (Max is " + 254 + ")");
        }
        field_187232_a.put(clazz, j);
        return serializer.func_187161_a(j);
    }

    public <T> void func_187214_a(DataParameter<T> key, T value) {
        int i = key.func_187155_a();
        if (i > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i + "! (Max is " + 254 + ")");
        }
        if (this.field_187234_c.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate id value for " + i + "!");
        }
        if (DataSerializers.func_187188_b((IDataSerializer)key.func_187156_b()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + key.func_187156_b() + " for " + i + "!");
        }
        this.func_187222_c(key, value);
    }

    private <T> void func_187222_c(DataParameter<T> key, T value) {
        DataEntry dataentry = new DataEntry(key, value);
        this.field_187235_d.writeLock().lock();
        this.field_187234_c.put(key.func_187155_a(), dataentry);
        this.field_187236_e = false;
        this.field_187235_d.writeLock().unlock();
    }

    private <T> DataEntry<T> func_187219_c(DataParameter<T> key) {
        DataEntry dataentry;
        this.field_187235_d.readLock().lock();
        try {
            dataentry = (DataEntry)this.field_187234_c.get(key.func_187155_a());
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting synched entity data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Synched entity data");
            crashreportcategory.func_71507_a("Data ID", key);
            throw new ReportedException(crashreport);
        }
        finally {
            this.field_187235_d.readLock().unlock();
        }
        return dataentry;
    }

    public <T> T func_187225_a(DataParameter<T> key) {
        return (T)this.func_187219_c(key).func_187206_b();
    }

    public <T> void func_187227_b(DataParameter<T> key, T value) {
        DataEntry dataentry = this.func_187219_c(key);
        if (ObjectUtils.notEqual(value, (Object)dataentry.func_187206_b())) {
            dataentry.func_187210_a(value);
            this.field_187233_b.func_184206_a(key);
            dataentry.func_187208_a(true);
            this.field_187237_f = true;
        }
    }

    public boolean func_187223_a() {
        return this.field_187237_f;
    }

    public static void func_187229_a(List<DataEntry<?>> entriesIn, PacketBuffer buf) throws IOException {
        if (entriesIn != null) {
            int j = entriesIn.size();
            for (int i = 0; i < j; ++i) {
                EntityDataManager.func_187220_a((PacketBuffer)buf, entriesIn.get(i));
            }
        }
        buf.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187221_b() {
        ArrayList list = null;
        if (this.field_187237_f) {
            this.field_187235_d.readLock().lock();
            for (DataEntry dataentry : this.field_187234_c.values()) {
                if (!dataentry.func_187209_c()) continue;
                dataentry.func_187208_a(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(dataentry.func_192735_d());
            }
            this.field_187235_d.readLock().unlock();
        }
        this.field_187237_f = false;
        return list;
    }

    public void func_187216_a(PacketBuffer buf) throws IOException {
        this.field_187235_d.readLock().lock();
        for (DataEntry dataentry : this.field_187234_c.values()) {
            EntityDataManager.func_187220_a((PacketBuffer)buf, (DataEntry)dataentry);
        }
        this.field_187235_d.readLock().unlock();
        buf.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187231_c() {
        ArrayList list = null;
        this.field_187235_d.readLock().lock();
        for (DataEntry dataentry : this.field_187234_c.values()) {
            if (list == null) {
                list = Lists.newArrayList();
            }
            list.add(dataentry.func_192735_d());
        }
        this.field_187235_d.readLock().unlock();
        return list;
    }

    private static <T> void func_187220_a(PacketBuffer buf, DataEntry<T> entry) throws IOException {
        DataParameter dataparameter = entry.func_187205_a();
        int i = DataSerializers.func_187188_b((IDataSerializer)dataparameter.func_187156_b());
        if (i < 0) {
            throw new EncoderException("Unknown serializer type " + dataparameter.func_187156_b());
        }
        buf.writeByte(dataparameter.func_187155_a());
        buf.func_150787_b(i);
        dataparameter.func_187156_b().func_187160_a(buf, entry.func_187206_b());
    }

    @Nullable
    public static List<DataEntry<?>> func_187215_b(PacketBuffer buf) throws IOException {
        short i;
        ArrayList list = null;
        while ((i = buf.readUnsignedByte()) != 255) {
            int j;
            IDataSerializer idataserializer;
            if (list == null) {
                list = Lists.newArrayList();
            }
            if ((idataserializer = DataSerializers.func_187190_a((int)(j = buf.func_150792_a()))) == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            list.add(EntityDataManager.func_198167_a((PacketBuffer)buf, (int)i, (IDataSerializer)idataserializer));
        }
        return list;
    }

    private static <T> DataEntry<T> func_198167_a(PacketBuffer p_198167_0_, int p_198167_1_, IDataSerializer<T> p_198167_2_) {
        return new DataEntry(p_198167_2_.func_187161_a(p_198167_1_), p_198167_2_.func_187159_a(p_198167_0_));
    }

    public void func_187218_a(List<DataEntry<?>> entriesIn) {
        this.field_187235_d.writeLock().lock();
        for (DataEntry<?> dataentry : entriesIn) {
            DataEntry dataentry1 = (DataEntry)this.field_187234_c.get(dataentry.func_187205_a().func_187155_a());
            if (dataentry1 == null) continue;
            this.func_187224_a(dataentry1, dataentry);
            this.field_187233_b.func_184206_a(dataentry.func_187205_a());
        }
        this.field_187235_d.writeLock().unlock();
        this.field_187237_f = true;
    }

    protected <T> void func_187224_a(DataEntry<T> target, DataEntry<?> source) {
        target.func_187210_a(source.func_187206_b());
    }

    public boolean func_187228_d() {
        return this.field_187236_e;
    }

    public void func_187230_e() {
        this.field_187237_f = false;
        this.field_187235_d.readLock().lock();
        for (DataEntry dataentry : this.field_187234_c.values()) {
            dataentry.func_187208_a(false);
        }
        this.field_187235_d.readLock().unlock();
    }
}

