/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.EntityTickableSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.particle.FireworkParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldInfo;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.DynamicLights;
import net.optifine.RandomEntities;
import net.optifine.override.PlayerControllerOF;
import net.optifine.reflect.Reflector;

public class ClientWorld
extends World {
    private final List<Entity> field_217428_a = Lists.newArrayList();
    private final Int2ObjectMap<Entity> field_217429_b = new Int2ObjectOpenHashMap();
    private final ClientPlayNetHandler field_73035_a;
    private final WorldRenderer field_217430_d;
    private final Minecraft field_73037_M = Minecraft.func_71410_x();
    private final List<AbstractClientPlayerEntity> field_217431_w = Lists.newArrayList();
    private int field_184158_M = this.field_73012_v.nextInt(12000);
    private Scoreboard field_200261_M = new Scoreboard();
    private final Map<String, MapData> field_217432_z = Maps.newHashMap();
    private boolean playerUpdate = false;

    public ClientWorld(ClientPlayNetHandler p_i24_1_, WorldSettings p_i24_2_, DimensionType p_i24_3_, int p_i24_4_, IProfiler p_i24_5_, WorldRenderer p_i24_6_) {
        super(new WorldInfo(p_i24_2_, "MpServer"), p_i24_3_, (p_217422_1_, p_217422_2_) -> new ClientChunkProvider((ClientWorld)p_217422_1_, p_i24_4_), p_i24_5_, true);
        this.field_73035_a = p_i24_1_;
        this.field_217430_d = p_i24_6_;
        this.func_175652_B(new BlockPos(8, 64, 8));
        this.func_72966_v();
        this.func_72947_a();
        Reflector.call(this, Reflector.ForgeWorld_initCapabilities, new Object[0]);
        Reflector.postForgeBusEvent(Reflector.WorldEvent_Load_Constructor, this);
        if (this.field_73037_M.field_71442_b != null && this.field_73037_M.field_71442_b.getClass() == PlayerController.class) {
            this.field_73037_M.field_71442_b = new PlayerControllerOF(this.field_73037_M, this.field_73035_a);
            CustomGuis.setPlayerControllerOF((PlayerControllerOF)this.field_73037_M.field_71442_b);
        }
    }

    public void func_72835_b(BooleanSupplier hasTimeLeft) {
        this.func_175723_af().func_212673_r();
        this.func_217389_a();
        this.func_217381_Z().func_76320_a("blocks");
        this.field_73020_y.func_217207_a(hasTimeLeft);
        this.func_217426_j();
        this.func_217381_Z().func_76319_b();
    }

    public Iterable<Entity> func_217416_b() {
        return Iterables.concat((Iterable)this.field_217429_b.values(), (Iterable)this.field_217428_a);
    }

    public void func_217419_d() {
        IProfiler iprofiler = this.func_217381_Z();
        iprofiler.func_76320_a("entities");
        iprofiler.func_76320_a("global");
        for (int i = 0; i < this.field_217428_a.size(); ++i) {
            Entity entity = (Entity)this.field_217428_a.get(i);
            this.func_217390_a(p_217415_0_ -> {
                ++p_217415_0_.field_70173_aa;
                p_217415_0_.func_70071_h_();
            }, entity);
            if (!entity.field_70128_L) continue;
            this.field_217428_a.remove(i--);
        }
        iprofiler.func_219895_b("regular");
        ObjectIterator objectiterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectiterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
            Entity entity1 = (Entity)entry.getValue();
            if (entity1.func_184218_aH()) continue;
            iprofiler.func_76320_a("tick");
            if (!entity1.field_70128_L) {
                this.func_217390_a(arg_0 -> this.func_217418_a(arg_0), entity1);
            }
            iprofiler.func_76319_b();
            iprofiler.func_76320_a("remove");
            if (entity1.field_70128_L) {
                objectiterator.remove();
                this.func_217414_d(entity1);
            }
            iprofiler.func_76319_b();
        }
        iprofiler.func_76319_b();
        this.func_217391_K();
        iprofiler.func_76319_b();
    }

    public void func_217418_a(Entity p_217418_1_) {
        if (p_217418_1_ instanceof PlayerEntity || this.func_72863_F().func_217204_a(p_217418_1_)) {
            p_217418_1_.field_70142_S = p_217418_1_.field_70165_t;
            p_217418_1_.field_70137_T = p_217418_1_.field_70163_u;
            p_217418_1_.field_70136_U = p_217418_1_.field_70161_v;
            p_217418_1_.field_70126_B = p_217418_1_.field_70177_z;
            p_217418_1_.field_70127_C = p_217418_1_.field_70125_A;
            if (p_217418_1_.field_70175_ag) {
                ++p_217418_1_.field_70173_aa;
                this.func_217381_Z().func_194340_a(() -> Registry.field_212629_r.func_177774_c((Object)p_217418_1_.func_200600_R()).toString());
                p_217418_1_.func_70071_h_();
                this.func_217381_Z().func_76319_b();
            }
            this.func_217423_b(p_217418_1_);
            if (p_217418_1_.field_70175_ag) {
                for (Entity entity : p_217418_1_.func_184188_bt()) {
                    this.func_217420_a(p_217418_1_, entity);
                }
            }
        }
    }

    public void func_217420_a(Entity p_217420_1_, Entity p_217420_2_) {
        if (!p_217420_2_.field_70128_L && p_217420_2_.func_184187_bx() == p_217420_1_) {
            if (p_217420_2_ instanceof PlayerEntity || this.func_72863_F().func_217204_a(p_217420_2_)) {
                p_217420_2_.field_70142_S = p_217420_2_.field_70165_t;
                p_217420_2_.field_70137_T = p_217420_2_.field_70163_u;
                p_217420_2_.field_70136_U = p_217420_2_.field_70161_v;
                p_217420_2_.field_70126_B = p_217420_2_.field_70177_z;
                p_217420_2_.field_70127_C = p_217420_2_.field_70125_A;
                if (p_217420_2_.field_70175_ag) {
                    ++p_217420_2_.field_70173_aa;
                    p_217420_2_.func_70098_U();
                }
                this.func_217423_b(p_217420_2_);
                if (p_217420_2_.field_70175_ag) {
                    for (Entity entity : p_217420_2_.func_184188_bt()) {
                        this.func_217420_a(p_217420_2_, entity);
                    }
                }
            }
        } else {
            p_217420_2_.func_184210_p();
        }
    }

    public void func_217423_b(Entity p_217423_1_) {
        this.func_217381_Z().func_76320_a("chunkCheck");
        int i = MathHelper.func_76128_c((double)(p_217423_1_.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(p_217423_1_.field_70163_u / 16.0));
        int k = MathHelper.func_76128_c((double)(p_217423_1_.field_70161_v / 16.0));
        if (!p_217423_1_.field_70175_ag || p_217423_1_.field_70176_ah != i || p_217423_1_.field_70162_ai != j || p_217423_1_.field_70164_aj != k) {
            if (p_217423_1_.field_70175_ag && this.func_217354_b(p_217423_1_.field_70176_ah, p_217423_1_.field_70164_aj)) {
                this.func_212866_a_(p_217423_1_.field_70176_ah, p_217423_1_.field_70164_aj).func_76608_a(p_217423_1_, p_217423_1_.field_70162_ai);
            }
            if (!p_217423_1_.func_184189_br() && !this.func_217354_b(i, k)) {
                p_217423_1_.field_70175_ag = false;
            } else {
                this.func_212866_a_(i, k).func_76612_a(p_217423_1_);
            }
        }
        this.func_217381_Z().func_76319_b();
    }

    public void func_217409_a(Chunk chunkIn) {
        this.field_147483_b.addAll(chunkIn.func_177434_r().values());
        this.field_73020_y.func_212863_j_().func_215571_a(chunkIn.func_76632_l(), false);
    }

    public boolean func_217354_b(int p_217354_1_, int p_217354_2_) {
        return true;
    }

    private void func_217426_j() {
        if (this.field_73037_M.field_71439_g != null) {
            if (this.field_184158_M > 0) {
                --this.field_184158_M;
            } else {
                BlockState blockstate;
                BlockPos blockpos = new BlockPos((Entity)this.field_73037_M.field_71439_g);
                BlockPos blockpos1 = blockpos.func_177982_a(4 * (this.field_73012_v.nextInt(3) - 1), 4 * (this.field_73012_v.nextInt(3) - 1), 4 * (this.field_73012_v.nextInt(3) - 1));
                double d0 = blockpos.func_177951_i((Vec3i)blockpos1);
                if (d0 >= 4.0 && d0 <= 256.0 && (blockstate = this.func_180495_p(blockpos1)).func_196958_f() && this.func_201669_a(blockpos1, 0) <= this.field_73012_v.nextInt(8) && this.func_175642_b(LightType.SKY, blockpos1) <= 0) {
                    this.func_184134_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, SoundEvents.field_187674_a, SoundCategory.AMBIENT, 0.7f, 0.8f + this.field_73012_v.nextFloat() * 0.2f, false);
                    this.field_184158_M = this.field_73012_v.nextInt(12000) + 6000;
                }
            }
        }
    }

    public int func_217425_f() {
        return this.field_217429_b.size();
    }

    public void func_217410_a(LightningBoltEntity p_217410_1_) {
        this.field_217428_a.add(p_217410_1_);
    }

    public void func_217408_a(int p_217408_1_, AbstractClientPlayerEntity p_217408_2_) {
        this.func_217424_b(p_217408_1_, (Entity)p_217408_2_);
        this.field_217431_w.add(p_217408_2_);
    }

    public void func_217411_a(int entityID, Entity entityToSpawn) {
        this.func_217424_b(entityID, entityToSpawn);
    }

    private void func_217424_b(int entityID, Entity entityToSpawn) {
        this.func_217413_d(entityID);
        this.field_217429_b.put(entityID, (Object)entityToSpawn);
        this.func_72863_F().func_212849_a_(MathHelper.func_76128_c((double)(entityToSpawn.field_70165_t / 16.0)), MathHelper.func_76128_c((double)(entityToSpawn.field_70161_v / 16.0)), ChunkStatus.field_222617_m, true).func_76612_a(entityToSpawn);
        this.onEntityAdded(entityToSpawn);
    }

    public void func_217413_d(int entityId) {
        Entity entity = (Entity)this.field_217429_b.remove(entityId);
        if (entity != null) {
            entity.func_70106_y();
            this.func_217414_d(entity);
        }
    }

    private void func_217414_d(Entity entityIn) {
        entityIn.func_213319_R();
        if (entityIn.field_70175_ag) {
            this.func_212866_a_(entityIn.field_70176_ah, entityIn.field_70164_aj).func_76622_b(entityIn);
        }
        this.field_217431_w.remove(entityIn);
        this.onEntityRemoved(entityIn);
    }

    public void func_217417_b(Chunk chunkIn) {
        for (Int2ObjectMap.Entry entry : this.field_217429_b.int2ObjectEntrySet()) {
            Entity entity = (Entity)entry.getValue();
            int i = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0));
            int j = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0));
            if (i != chunkIn.func_76632_l().field_77276_a || j != chunkIn.func_76632_l().field_77275_b) continue;
            chunkIn.func_76612_a(entity);
        }
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return (Entity)this.field_217429_b.get(id);
    }

    public void func_195597_b(BlockPos pos, BlockState state) {
        this.func_180501_a(pos, state, 19);
    }

    public void func_72882_A() {
        this.field_73035_a.func_147298_b().func_150718_a((ITextComponent)new TranslationTextComponent("multiplayer.status.quitting", new Object[0]));
    }

    public void func_73029_E(int posX, int posY, int posZ) {
        int i = 32;
        Random random = new Random();
        ItemStack itemstack = this.field_73037_M.field_71439_g.func_184614_ca();
        if (itemstack == null || Block.func_149634_a((Item)itemstack.func_77973_b()) != Blocks.field_180401_cv) {
            itemstack = this.field_73037_M.field_71439_g.func_184592_cb();
        }
        boolean flag = this.field_73037_M.field_71442_b.func_178889_l() == GameType.CREATIVE && !itemstack.func_190926_b() && itemstack.func_77973_b() == Blocks.field_180401_cv.func_199767_j();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = 0; j < 667; ++j) {
            this.func_184153_a(posX, posY, posZ, 16, random, flag, blockpos$mutableblockpos);
            this.func_184153_a(posX, posY, posZ, 32, random, flag, blockpos$mutableblockpos);
        }
    }

    public void func_184153_a(int x, int y, int z, int offset, Random random, boolean holdingBarrier, BlockPos.MutableBlockPos pos) {
        int i = x + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        int j = y + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        int k = z + this.field_73012_v.nextInt(offset) - this.field_73012_v.nextInt(offset);
        pos.func_181079_c(i, j, k);
        BlockState blockstate = this.func_180495_p((BlockPos)pos);
        blockstate.func_177230_c().func_180655_c(blockstate, (World)this, (BlockPos)pos, random);
        IFluidState ifluidstate = this.func_204610_c((BlockPos)pos);
        if (!ifluidstate.func_206888_e()) {
            ifluidstate.func_206881_a((World)this, (BlockPos)pos, random);
            IParticleData iparticledata = ifluidstate.func_204521_c();
            if (iparticledata != null && this.field_73012_v.nextInt(10) == 0) {
                boolean flag = Block.func_220056_d((BlockState)blockstate, (IBlockReader)this, (BlockPos)pos, (Direction)Direction.DOWN);
                BlockPos blockpos = pos.func_177977_b();
                this.func_211530_a(blockpos, this.func_180495_p(blockpos), iparticledata, flag);
            }
        }
        if (holdingBarrier && blockstate.func_177230_c() == Blocks.field_180401_cv) {
            this.func_195594_a((IParticleData)ParticleTypes.field_197610_c, (double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    private void func_211530_a(BlockPos blockPosIn, BlockState blockStateIn, IParticleData particleDataIn, boolean shapeDownSolid) {
        if (blockStateIn.func_204520_s().func_206888_e()) {
            VoxelShape voxelshape = blockStateIn.func_196952_d((IBlockReader)this, blockPosIn);
            double d0 = voxelshape.func_197758_c(Direction.Axis.Y);
            if (d0 < 1.0) {
                if (shapeDownSolid) {
                    this.func_211834_a((double)blockPosIn.func_177958_n(), (double)(blockPosIn.func_177958_n() + 1), (double)blockPosIn.func_177952_p(), (double)(blockPosIn.func_177952_p() + 1), (double)(blockPosIn.func_177956_o() + 1) - 0.05, particleDataIn);
                }
            } else if (!blockStateIn.func_203425_a(BlockTags.field_211923_H)) {
                double d1 = voxelshape.func_197762_b(Direction.Axis.Y);
                if (d1 > 0.0) {
                    this.func_211835_a(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.func_177956_o() + d1 - 0.05);
                } else {
                    BlockPos blockpos = blockPosIn.func_177977_b();
                    BlockState blockstate = this.func_180495_p(blockpos);
                    VoxelShape voxelshape1 = blockstate.func_196952_d((IBlockReader)this, blockpos);
                    double d2 = voxelshape1.func_197758_c(Direction.Axis.Y);
                    if (d2 < 1.0 && blockstate.func_204520_s().func_206888_e()) {
                        this.func_211835_a(blockPosIn, particleDataIn, voxelshape, (double)blockPosIn.func_177956_o() - 0.05);
                    }
                }
            }
        }
    }

    private void func_211835_a(BlockPos posIn, IParticleData particleDataIn, VoxelShape voxelShapeIn, double p_211835_4_) {
        this.func_211834_a((double)posIn.func_177958_n() + voxelShapeIn.func_197762_b(Direction.Axis.X), (double)posIn.func_177958_n() + voxelShapeIn.func_197758_c(Direction.Axis.X), (double)posIn.func_177952_p() + voxelShapeIn.func_197762_b(Direction.Axis.Z), (double)posIn.func_177952_p() + voxelShapeIn.func_197758_c(Direction.Axis.Z), p_211835_4_, particleDataIn);
    }

    private void func_211834_a(double p_211834_1_, double p_211834_3_, double p_211834_5_, double p_211834_7_, double p_211834_9_, IParticleData p_211834_11_) {
        this.func_195594_a(p_211834_11_, MathHelper.func_219803_d((double)this.field_73012_v.nextDouble(), (double)p_211834_1_, (double)p_211834_3_), p_211834_9_, MathHelper.func_219803_d((double)this.field_73012_v.nextDouble(), (double)p_211834_5_, (double)p_211834_7_), 0.0, 0.0, 0.0);
    }

    public void func_73022_a() {
        ObjectIterator objectiterator = this.field_217429_b.int2ObjectEntrySet().iterator();
        while (objectiterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectiterator.next();
            Entity entity = (Entity)entry.getValue();
            if (!entity.field_70128_L) continue;
            objectiterator.remove();
            this.func_217414_d(entity);
        }
    }

    public CrashReportCategory func_72914_a(CrashReport report) {
        CrashReportCategory crashreportcategory = super.func_72914_a(report);
        crashreportcategory.func_189529_a("Server brand", () -> this.field_73037_M.field_71439_g.func_142021_k());
        crashreportcategory.func_189529_a("Server type", () -> this.field_73037_M.func_71401_C() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server");
        return crashreportcategory;
    }

    public void func_184148_a(@Nullable PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        if (player == this.field_73037_M.field_71439_g) {
            this.func_184134_a(x, y, z, soundIn, category, volume, pitch, false);
        }
    }

    public void func_217384_a(@Nullable PlayerEntity p_217384_1_, Entity p_217384_2_, SoundEvent p_217384_3_, SoundCategory p_217384_4_, float p_217384_5_, float p_217384_6_) {
        if (p_217384_1_ == this.field_73037_M.field_71439_g) {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)new EntityTickableSound(p_217384_3_, p_217384_4_, p_217384_2_));
        }
    }

    public void func_184156_a(BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        this.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundIn, category, volume, pitch, distanceDelay);
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        double d0 = this.field_73037_M.field_71460_t.func_215316_n().func_216785_c().func_186679_c(x, y, z);
        SimpleSound simplesound = new SimpleSound(soundIn, category, volume, pitch, (float)x, (float)y, (float)z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            this.field_73037_M.func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            this.field_73037_M.func_147118_V().func_147682_a((ISound)simplesound);
        }
    }

    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable CompoundNBT compound) {
        this.field_73037_M.field_71452_i.func_78873_a((Particle)new FireworkParticle.Starter((World)this, x, y, z, motionX, motionY, motionZ, this.field_73037_M.field_71452_i, compound));
    }

    public void func_184135_a(IPacket<?> packetIn) {
        this.field_73035_a.func_147297_a(packetIn);
    }

    public RecipeManager func_199532_z() {
        return this.field_73035_a.func_199526_e();
    }

    public void func_96443_a(Scoreboard scoreboardIn) {
        this.field_200261_M = scoreboardIn;
    }

    public void func_72877_b(long time) {
        if (time < 0L) {
            time = -time;
            this.func_82736_K().func_82764_b("doDaylightCycle", "false", (MinecraftServer)null);
        } else {
            this.func_82736_K().func_82764_b("doDaylightCycle", "true", (MinecraftServer)null);
        }
        super.func_72877_b(time);
    }

    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public ClientChunkProvider func_72863_F() {
        return (ClientChunkProvider)super.func_72863_F();
    }

    public int func_217338_b(BlockPos pos, int lightValue) {
        int combinedLight = super.func_217338_b(pos, lightValue);
        if (Config.isDynamicLights()) {
            combinedLight = DynamicLights.getCombinedLight((BlockPos)pos, (int)combinedLight);
        }
        return combinedLight;
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        this.playerUpdate = this.isPlayerActing();
        boolean res = super.func_180501_a(pos, newState, flags);
        this.playerUpdate = false;
        return res;
    }

    private boolean isPlayerActing() {
        if (this.field_73037_M.field_71442_b instanceof PlayerControllerOF) {
            PlayerControllerOF pcof = (PlayerControllerOF)this.field_73037_M.field_71442_b;
            return pcof.isActing();
        }
        return false;
    }

    public boolean isPlayerUpdate() {
        return this.playerUpdate;
    }

    @Nullable
    public MapData func_217406_a(String p_217406_1_) {
        return (MapData)this.field_217432_z.get(p_217406_1_);
    }

    public void func_217399_a(MapData p_217399_1_) {
        this.field_217432_z.put(p_217399_1_.func_195925_e(), p_217399_1_);
    }

    public int func_217395_y() {
        return 0;
    }

    public Scoreboard func_96441_U() {
        return this.field_200261_M;
    }

    public NetworkTagManager func_205772_D() {
        return this.field_73035_a.func_199724_l();
    }

    public void func_184138_a(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        this.field_217430_d.func_184376_a((IBlockReader)this, pos, oldState, newState, flags);
    }

    public void func_217396_m(BlockPos p_217396_1_) {
        this.field_217430_d.func_147585_a(p_217396_1_.func_177958_n(), p_217396_1_.func_177956_o(), p_217396_1_.func_177952_p(), p_217396_1_.func_177958_n(), p_217396_1_.func_177956_o(), p_217396_1_.func_177952_p());
    }

    public void func_217427_b(int p_217427_1_, int p_217427_2_, int p_217427_3_) {
        this.field_217430_d.func_215321_a(p_217427_1_, p_217427_2_, p_217427_3_);
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        this.field_217430_d.func_180441_b(breakerId, pos, progress);
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        this.field_217430_d.func_180440_a(id, pos, data);
    }

    public void func_217378_a(@Nullable PlayerEntity p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
        try {
            this.field_217430_d.func_180439_a(p_217378_1_, p_217378_2_, p_217378_3_, p_217378_4_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Playing level event");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Level event being played");
            crashreportcategory.func_71507_a("Block coordinates", (Object)CrashReportCategory.func_180522_a((BlockPos)p_217378_3_));
            crashreportcategory.func_71507_a("Event source", (Object)p_217378_1_);
            crashreportcategory.func_71507_a("Event type", (Object)p_217378_2_);
            crashreportcategory.func_71507_a("Event data", (Object)p_217378_4_);
            throw new ReportedException(crashreport);
        }
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195461_a(particleData, particleData.func_197554_b().func_197575_f(), x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195590_a(IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195461_a(particleData, particleData.func_197554_b().func_197575_f() || forceAlwaysRender, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_195589_b(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.field_217430_d.func_195462_a(particleData, false, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_217404_b(IParticleData p_217404_1_, boolean p_217404_2_, double p_217404_3_, double p_217404_5_, double p_217404_7_, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        this.field_217430_d.func_195462_a(p_217404_1_, p_217404_1_.func_197554_b().func_197575_f() || p_217404_2_, true, p_217404_3_, p_217404_5_, p_217404_7_, p_217404_9_, p_217404_11_, p_217404_13_);
    }

    public List<AbstractClientPlayerEntity> func_217369_A() {
        return this.field_217431_w;
    }

    public void onEntityAdded(Entity entityIn) {
        RandomEntities.entityLoaded((Entity)entityIn, (World)this);
        if (Config.isDynamicLights()) {
            DynamicLights.entityAdded((Entity)entityIn, (WorldRenderer)Config.getRenderGlobal());
        }
    }

    public void onEntityRemoved(Entity entityIn) {
        RandomEntities.entityUnloaded((Entity)entityIn, (World)this);
        if (Config.isDynamicLights()) {
            DynamicLights.entityRemoved((Entity)entityIn, (WorldRenderer)Config.getRenderGlobal());
        }
    }
}

