/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.LayeredColorMaskTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PreloadedTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.EmissiveTextures;
import net.optifine.RandomEntities;
import net.optifine.shaders.ShadersTex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureManager
implements ITickable,
IFutureReloadListener {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, ITextureObject> field_110585_a = Maps.newHashMap();
    private final List<ITickable> field_110583_b = Lists.newArrayList();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;

    public TextureManager(IResourceManager resourceManager) {
        this.field_110582_d = resourceManager;
    }

    public void func_110577_a(ResourceLocation resource) {
        if (Config.isRandomEntities()) {
            resource = RandomEntities.getTextureLocation((ResourceLocation)resource);
        }
        if (Config.isCustomGuis()) {
            resource = CustomGuis.getTextureLocation((ResourceLocation)resource);
        }
        ITextureObject itextureobject = (ITextureObject)this.field_110585_a.get(resource);
        if (EmissiveTextures.isActive()) {
            itextureobject = EmissiveTextures.getEmissiveTexture((ITextureObject)itextureobject, (Map)this.field_110585_a);
        }
        if (itextureobject == null) {
            itextureobject = new SimpleTexture(resource);
            this.func_110579_a(resource, itextureobject);
        }
        if (Config.isShaders()) {
            ShadersTex.bindTexture((ITextureObject)itextureobject);
        } else {
            itextureobject.func_195412_h();
        }
    }

    public boolean func_110580_a(ResourceLocation textureLocation, ITickableTextureObject textureObj) {
        if (this.func_110579_a(textureLocation, (ITextureObject)textureObj)) {
            this.field_110583_b.add(textureObj);
            return true;
        }
        return false;
    }

    public boolean func_110579_a(ResourceLocation textureLocation, ITextureObject textureObj) {
        boolean flag = true;
        try {
            textureObj.func_195413_a(this.field_110582_d);
        }
        catch (IOException ioexception) {
            if (textureLocation != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)textureLocation, (Object)ioexception);
            }
            textureObj = MissingTextureSprite.func_195676_d();
            this.field_110585_a.put(textureLocation, textureObj);
            flag = false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Registering texture");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Resource location being registered");
            crashreportcategory.func_71507_a("Resource location", (Object)textureLocation);
            ITextureObject textureObjF = textureObj;
            crashreportcategory.func_189529_a("Texture object class", () -> textureObjF.getClass().getName());
            throw new ReportedException(crashreport);
        }
        this.field_110585_a.put(textureLocation, textureObj);
        return flag;
    }

    public ITextureObject func_110581_b(ResourceLocation textureLocation) {
        return (ITextureObject)this.field_110585_a.get(textureLocation);
    }

    public ResourceLocation func_110578_a(String name, DynamicTexture texture) {
        Integer integer = (Integer)this.field_110584_c.get(name);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_110584_c.put(name, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", name, integer));
        this.func_110579_a(resourcelocation, (ITextureObject)texture);
        return resourcelocation;
    }

    public CompletableFuture<Void> func_215268_a(ResourceLocation resourceLocationIn, Executor executorIn) {
        if (!this.field_110585_a.containsKey(resourceLocationIn)) {
            PreloadedTexture preloadedtexture = new PreloadedTexture(this.field_110582_d, resourceLocationIn, executorIn);
            this.field_110585_a.put(resourceLocationIn, preloadedtexture);
            return preloadedtexture.func_215248_a().thenRunAsync(() -> this.func_110579_a(resourceLocationIn, (ITextureObject)preloadedtexture), (Executor)Minecraft.func_71410_x());
        }
        return CompletableFuture.completedFuture(null);
    }

    public void func_110550_d() {
        for (ITickable itickable : this.field_110583_b) {
            itickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation textureLocation) {
        ITextureObject itextureobject = this.func_110581_b(textureLocation);
        if (itextureobject != null) {
            this.field_110585_a.remove(textureLocation);
            TextureUtil.releaseTextureId((int)itextureobject.func_110552_b());
        }
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stageIn, IResourceManager resourceManagerIn, IProfiler profilerPrepare, IProfiler profilerReload, Executor executorPrepare, Executor executorReload) {
        Config.dbg("*** Reloading textures ***");
        Config.log("Resource packs: " + Config.getResourcePackNames());
        Iterator it = this.field_110585_a.keySet().iterator();
        while (it.hasNext()) {
            ResourceLocation loc = (ResourceLocation)it.next();
            String path = loc.func_110623_a();
            if (!path.startsWith("optifine/") && !EmissiveTextures.isEmissive((ResourceLocation)loc)) continue;
            ITextureObject tex = (ITextureObject)this.field_110585_a.get(loc);
            if (tex instanceof Texture) {
                Texture at = (Texture)tex;
                at.func_147631_c();
            }
            it.remove();
        }
        EmissiveTextures.update();
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf(MainMenuScreen.func_213097_a((TextureManager)this, (Executor)executorPrepare), this.func_215268_a(Widget.WIDGETS_LOCATION, executorPrepare));
        stageIn.getClass();
        return ((CompletableFuture)completablefuture.thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stageIn).func_216872_a(arg_0))).thenAcceptAsync(p_215266_3_ -> {
            MissingTextureSprite.func_195676_d();
            Iterator iterator = this.field_110585_a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
                ITextureObject itextureobject = (ITextureObject)entry.getValue();
                if (itextureobject == MissingTextureSprite.func_195676_d() && !resourcelocation.equals((Object)MissingTextureSprite.func_195675_b())) {
                    iterator.remove();
                    continue;
                }
                itextureobject.func_215244_a(this, resourceManagerIn, resourcelocation, executorReload);
            }
        }, executorReload);
    }

    public void reloadBannerTextures() {
        for (Map.Entry entry : this.field_110585_a.entrySet()) {
            ResourceLocation loc = (ResourceLocation)entry.getKey();
            ITextureObject tex = (ITextureObject)entry.getValue();
            if (!(tex instanceof LayeredColorMaskTexture)) continue;
            this.func_110579_a(loc, tex);
        }
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.TEXTURES;
    }
}

