/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.client.extensions.IForgeTextureAtlasSprite;
import net.optifine.Config;
import net.optifine.Mipmaps;
import net.optifine.SmartAnimations;
import net.optifine.shaders.Shaders;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureAtlasSprite
implements IForgeTextureAtlasSprite {
    private final ResourceLocation field_110984_i;
    protected int field_130223_c;
    protected int field_130224_d;
    protected NativeImage[] field_195670_c;
    @Nullable
    protected int[] field_195671_d;
    @Nullable
    protected int[] field_195672_e;
    protected NativeImage[] field_176605_b;
    private AnimationMetadataSection field_110982_k;
    protected int field_110975_c;
    protected int field_110974_d;
    private float field_110979_l;
    private float field_110980_m;
    private float field_110977_n;
    private float field_110978_o;
    protected int field_110973_g;
    protected int field_110983_h;
    private static final int[] field_195673_r = new int[4];
    private static final float[] field_195674_s = (float[])Util.func_200696_a((Object)new float[256], p_203415_0_ -> {
        for (int i = 0; i < ((float[])p_203415_0_).length; ++i) {
            p_203415_0_[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    });
    private int indexInMap = -1;
    public float baseU;
    public float baseV;
    public int sheetWidth;
    public int sheetHeight;
    public int glSpriteTextureId = -1;
    public TextureAtlasSprite spriteSingle = null;
    public boolean isSpriteSingle = false;
    public static final String SUFFIX_SPRITE_SINGLE = ".sprite_single";
    public int mipmapLevels = 0;
    public TextureAtlasSprite spriteNormal = null;
    public TextureAtlasSprite spriteSpecular = null;
    public boolean isSpriteShaders = false;
    public boolean isDependencyParent = false;
    public TextureAtlasSprite spriteEmissive = null;
    public boolean isSpriteEmissive = false;
    private int animationIndex = -1;
    private boolean animationActive = false;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private AtlasTexture textureMap;
    private IResourceManager resourceManager;

    public TextureAtlasSprite(ResourceLocation locationIn, int widthIn, int heightIn) {
        this.field_110984_i = locationIn;
        this.field_130223_c = widthIn;
        this.field_130224_d = heightIn;
    }

    protected TextureAtlasSprite(ResourceLocation locationIn, PngSizeInfo sizeIn, @Nullable AnimationMetadataSection animationMetadataIn) {
        this.field_110984_i = locationIn;
        if (animationMetadataIn != null) {
            Pair pair = TextureAtlasSprite.func_217788_b((int)animationMetadataIn.func_110474_b(), (int)animationMetadataIn.func_110471_a(), (int)sizeIn.field_188533_a, (int)sizeIn.field_188534_b);
            this.field_130223_c = (Integer)pair.getFirst();
            this.field_130224_d = (Integer)pair.getSecond();
            if (!TextureAtlasSprite.func_217787_a((int)sizeIn.field_188533_a, (int)this.field_130223_c) || !TextureAtlasSprite.func_217787_a((int)sizeIn.field_188534_b, (int)this.field_130224_d)) {
                throw new IllegalArgumentException(String.format("Image size %s,%s is not multiply of frame size %s,%s", this.field_130223_c, this.field_130224_d, sizeIn.field_188533_a, sizeIn.field_188534_b));
            }
        } else {
            this.field_130223_c = sizeIn.field_188533_a;
            this.field_130224_d = sizeIn.field_188534_b;
        }
        this.field_110982_k = animationMetadataIn;
    }

    public void init(PngSizeInfo sizeInfoIn, @Nullable AnimationMetadataSection metadataIn) {
        if (metadataIn != null) {
            int i;
            this.field_130224_d = this.field_130223_c = (i = Math.min(sizeInfoIn.field_188533_a, sizeInfoIn.field_188534_b));
        } else {
            if (sizeInfoIn.field_188534_b != sizeInfoIn.field_188533_a) {
                throw new RuntimeException("broken aspect ratio and not an animation");
            }
            this.field_130223_c = sizeInfoIn.field_188533_a;
            this.field_130224_d = sizeInfoIn.field_188534_b;
        }
        this.field_110982_k = metadataIn;
        if (this.spriteSingle != null) {
            this.spriteSingle.init(sizeInfoIn, metadataIn);
        }
    }

    private static Pair<Integer, Integer> func_217788_b(int metaWidthIn, int metaHeightIn, int widthIn, int heightIn) {
        if (metaWidthIn != -1) {
            return metaHeightIn != -1 ? Pair.of((Object)metaWidthIn, (Object)metaHeightIn) : Pair.of((Object)metaWidthIn, (Object)heightIn);
        }
        if (metaHeightIn != -1) {
            return Pair.of((Object)widthIn, (Object)metaHeightIn);
        }
        int i = Math.min(widthIn, heightIn);
        return Pair.of((Object)i, (Object)i);
    }

    private static boolean func_217787_a(int xIn, int baseIn) {
        return xIn / baseIn * baseIn == xIn;
    }

    private void func_195666_b(int level) {
        NativeImage[] anativeimage = new NativeImage[level + 1];
        anativeimage[0] = this.field_195670_c[0];
        if (anativeimage[0].func_195702_a() < this.func_94211_a() || anativeimage[0].func_195714_b() < this.func_94216_b()) {
            throw new RuntimeException("Invalid image size: " + anativeimage[0] + ", sprite: " + this);
        }
        if (level > 0) {
            boolean flag = false;
            for (int k1 = 1; k1 <= level; ++k1) {
                if (this.field_195670_c.length > k1 && this.field_195670_c[k1] != null) {
                    anativeimage[k1] = this.field_195670_c[k1];
                    continue;
                }
                NativeImage nativeimage1 = anativeimage[k1 - 1];
                NativeImage nativeimage = new NativeImage(nativeimage1.func_195702_a() >> 1, nativeimage1.func_195714_b() >> 1, false);
                int k = nativeimage.func_195702_a();
                int l2 = nativeimage.func_195714_b();
                for (int i1 = 0; i1 < k; ++i1) {
                    for (int j1 = 0; j1 < l2; ++j1) {
                        nativeimage.func_195700_a(i1, j1, TextureAtlasSprite.func_195661_b((int)nativeimage1.func_195709_a(i1 * 2 + 0, j1 * 2 + 0), (int)nativeimage1.func_195709_a(i1 * 2 + 1, j1 * 2 + 0), (int)nativeimage1.func_195709_a(i1 * 2 + 0, j1 * 2 + 1), (int)nativeimage1.func_195709_a(i1 * 2 + 1, j1 * 2 + 1), (boolean)flag));
                    }
                }
                anativeimage[k1] = nativeimage;
            }
            for (int l1 = level + 1; l1 < this.field_195670_c.length; ++l1) {
                if (this.field_195670_c[l1] == null) continue;
                this.field_195670_c[l1].close();
            }
        }
        this.field_195670_c = anativeimage;
        if (this.spriteSingle != null) {
            this.spriteSingle.field_195670_c = this.field_195670_c;
        }
    }

    private static int func_195661_b(int col0, int col1, int col2, int col3, boolean transparent) {
        return Mipmaps.alphaBlend(col0, col1, col2, col3);
    }

    private static int func_195669_a(int col0, int col1, int col2, int col3, int bitOffset) {
        float f = TextureAtlasSprite.func_195660_c((int)(col0 >> bitOffset));
        float f1 = TextureAtlasSprite.func_195660_c((int)(col1 >> bitOffset));
        float f2 = TextureAtlasSprite.func_195660_c((int)(col2 >> bitOffset));
        float f3 = TextureAtlasSprite.func_195660_c((int)(col3 >> bitOffset));
        float f4 = (float)((double)((float)Math.pow((double)(f + f1 + f2 + f3) * 0.25, 0.45454545454545453)));
        return (int)((double)f4 * 255.0);
    }

    private static float func_195660_c(int colorIn) {
        return field_195674_s[colorIn & 0xFF];
    }

    private void func_195659_d(int index) {
        int i = 0;
        int j = 0;
        if (this.field_195671_d != null) {
            i = this.field_195671_d[index] * this.field_130223_c;
            j = this.field_195672_e[index] * this.field_130224_d;
        }
        this.func_195667_a(i, j, this.field_195670_c);
    }

    private void func_195667_a(int xOffsetIn, int yOffsetIn, NativeImage[] framesIn) {
        boolean blur = false;
        boolean clamp = this.isSpriteSingle;
        for (int i = 0; i < framesIn.length; ++i) {
            framesIn[i].func_195712_a(i, this.field_110975_c >> i, this.field_110974_d >> i, xOffsetIn >> i, yOffsetIn >> i, this.field_130223_c >> i, this.field_130224_d >> i, blur, clamp, this.field_195670_c.length > 1);
        }
        if (this.spriteSingle != null) {
            this.spriteSingle.func_195667_a(xOffsetIn, yOffsetIn, framesIn);
        }
    }

    public void func_217789_a(int inX, int inY, int originInX, int originInY) {
        this.field_110975_c = originInX;
        this.field_110974_d = originInY;
        this.field_110979_l = (float)originInX / (float)inX;
        this.field_110980_m = (float)(originInX + this.field_130223_c) / (float)inX;
        this.field_110977_n = (float)originInY / (float)inY;
        this.field_110978_o = (float)(originInY + this.field_130224_d) / (float)inY;
        this.baseU = Math.min(this.field_110979_l, this.field_110980_m);
        this.baseV = Math.min(this.field_110977_n, this.field_110978_o);
        if (this.spriteSingle != null) {
            this.spriteSingle.func_217789_a(this.field_130223_c, this.field_130224_d, 0, 0);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.copyFrom(this);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.copyFrom(this);
        }
    }

    public int func_94211_a() {
        return this.field_130223_c;
    }

    public int func_94216_b() {
        return this.field_130224_d;
    }

    public float func_94209_e() {
        return this.field_110979_l;
    }

    public float func_94212_f() {
        return this.field_110980_m;
    }

    public float func_94214_a(double u) {
        float f = this.field_110980_m - this.field_110979_l;
        return this.field_110979_l + f * (float)u / 16.0f;
    }

    public float func_188537_a(float u) {
        float f = this.field_110980_m - this.field_110979_l;
        return (u - this.field_110979_l) / f * 16.0f;
    }

    public float func_94206_g() {
        return this.field_110977_n;
    }

    public float func_94210_h() {
        return this.field_110978_o;
    }

    public float func_94207_b(double v) {
        float f = this.field_110978_o - this.field_110977_n;
        return this.field_110977_n + f * (float)v / 16.0f;
    }

    public float func_188536_b(float v) {
        float f = this.field_110978_o - this.field_110977_n;
        return (v - this.field_110977_n) / f * 16.0f;
    }

    public ResourceLocation func_195668_m() {
        return this.field_110984_i;
    }

    public void func_94219_l() {
        if (this.field_110982_k == null) {
            return;
        }
        this.animationActive = true;
        if (this.terrain) {
            this.animationActive = SmartAnimations.isActive() ? SmartAnimations.isSpriteRendered(this.animationIndex) : true;
        }
        ++this.field_110983_h;
        if (this.field_110983_h >= this.field_110982_k.func_110472_a(this.field_110973_g)) {
            int i = this.field_110982_k.func_110468_c(this.field_110973_g);
            int j = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c();
            this.field_110973_g = (this.field_110973_g + 1) % j;
            this.field_110983_h = 0;
            int k = this.field_110982_k.func_110468_c(this.field_110973_g);
            if (!this.animationActive) {
                return;
            }
            if (i != k && k >= 0 && k < this.func_110970_k()) {
                this.func_195659_d(k);
            }
        } else if (this.field_110982_k.func_177219_e()) {
            if (!this.animationActive) {
                return;
            }
            this.func_180599_n();
        }
    }

    private void func_180599_n() {
        int j;
        int k;
        double d0 = 1.0 - (double)this.field_110983_h / (double)this.field_110982_k.func_110472_a(this.field_110973_g);
        int i = this.field_110982_k.func_110468_c(this.field_110973_g);
        if (i != (k = this.field_110982_k.func_110468_c((this.field_110973_g + 1) % (j = this.field_110982_k.func_110473_c() == 0 ? this.func_110970_k() : this.field_110982_k.func_110473_c()))) && k >= 0 && k < this.func_110970_k()) {
            if (this.field_176605_b == null || this.field_176605_b.length != this.field_195670_c.length) {
                if (this.field_176605_b != null) {
                    for (NativeImage nativeimage : this.field_176605_b) {
                        if (nativeimage == null) continue;
                        nativeimage.close();
                    }
                }
                this.field_176605_b = new NativeImage[this.field_195670_c.length];
            }
            for (int j2 = 0; j2 < this.field_195670_c.length; ++j2) {
                int k2 = this.field_130223_c >> j2;
                int l2 = this.field_130224_d >> j2;
                if (this.field_176605_b[j2] == null) {
                    this.field_176605_b[j2] = new NativeImage(k2, l2, false);
                }
                for (int i3 = 0; i3 < l2; ++i3) {
                    for (int l3 = 0; l3 < k2; ++l3) {
                        int i1 = this.func_195665_a(i, j2, l3, i3);
                        int j1 = this.func_195665_a(k, j2, l3, i3);
                        int k1 = this.func_188535_a(d0, i1 >> 16 & 0xFF, j1 >> 16 & 0xFF);
                        int l1 = this.func_188535_a(d0, i1 >> 8 & 0xFF, j1 >> 8 & 0xFF);
                        int i2 = this.func_188535_a(d0, i1 & 0xFF, j1 & 0xFF);
                        this.field_176605_b[j2].func_195700_a(l3, i3, i1 & 0xFF000000 | k1 << 16 | l1 << 8 | i2);
                    }
                }
            }
            this.func_195667_a(0, 0, this.field_176605_b);
        }
    }

    private int func_188535_a(double factor, int to, int from) {
        return (int)(factor * (double)to + (1.0 - factor) * (double)from);
    }

    public int func_110970_k() {
        return this.field_195671_d == null ? 0 : this.field_195671_d.length;
    }

    public void func_195664_a(IResource resource, int count) throws IOException {
        NativeImage imageScaled;
        NativeImage nativeimage = NativeImage.func_195713_a((InputStream)resource.func_199027_b());
        if (this.field_130223_c != nativeimage.func_195702_a() && (imageScaled = TextureUtils.scaleImage((NativeImage)nativeimage, (int)this.field_130223_c)) != nativeimage) {
            nativeimage.close();
            nativeimage = imageScaled;
        }
        if (!this.isSpriteShaders && !this.field_110984_i.func_110623_a().endsWith("_leaves")) {
            this.fixTransparentColor(nativeimage);
        }
        this.field_195670_c = new NativeImage[count];
        this.field_195670_c[0] = nativeimage;
        int i = this.field_110982_k != null && this.field_110982_k.func_110474_b() != -1 ? nativeimage.func_195702_a() / this.field_110982_k.func_110474_b() : nativeimage.func_195702_a() / this.field_130223_c;
        int j = this.field_110982_k != null && this.field_110982_k.func_110471_a() != -1 ? nativeimage.func_195714_b() / this.field_110982_k.func_110471_a() : nativeimage.func_195714_b() / this.field_130224_d;
        if (this.field_110982_k != null && this.field_110982_k.func_110473_c() > 0) {
            int k1 = (Integer)this.field_110982_k.func_130073_e().stream().max(Integer::compareTo).get() + 1;
            this.field_195671_d = new int[k1];
            this.field_195672_e = new int[k1];
            Arrays.fill(this.field_195671_d, -1);
            Arrays.fill(this.field_195672_e, -1);
            Iterator iterator = this.field_110982_k.func_130073_e().iterator();
            while (iterator.hasNext()) {
                int k2;
                int i2 = (Integer)iterator.next();
                if (i2 >= i * j) {
                    throw new RuntimeException("invalid frameindex " + i2);
                }
                int j2 = i2 / i;
                this.field_195671_d[i2] = k2 = i2 % i;
                this.field_195672_e[i2] = j2;
            }
        } else {
            ArrayList list = Lists.newArrayList();
            int k = i * j;
            this.field_195671_d = new int[k];
            this.field_195672_e = new int[k];
            for (int l2 = 0; l2 < j; ++l2) {
                int i1 = 0;
                while (i1 < i) {
                    int j1 = l2 * i + i1;
                    this.field_195671_d[j1] = i1++;
                    this.field_195672_e[j1] = l2;
                    list.add(new AnimationFrame(j1, -1));
                }
            }
            int l1 = 1;
            boolean flag = false;
            if (this.field_110982_k != null) {
                l1 = this.field_110982_k.func_110469_d();
                flag = this.field_110982_k.func_177219_e();
            }
            this.field_110982_k = new AnimationMetadataSection((List)list, this.field_130223_c, this.field_130224_d, l1, flag);
        }
        if (this.isSpriteShaders) {
            return;
        }
        if (this.spriteNormal != null) {
            this.loadShadersSprite(this.spriteNormal, -8421377);
        }
        if (this.spriteSpecular != null) {
            this.loadShadersSprite(this.spriteSpecular, 0);
        }
        if (this.spriteSingle != null) {
            this.spriteSingle.field_195670_c = this.field_195670_c;
            this.spriteSingle.field_195671_d = this.field_195671_d;
            this.spriteSingle.field_195672_e = this.field_195672_e;
            this.spriteSingle.field_110982_k = this.field_110982_k;
        }
    }

    public void func_147963_d(int level) {
        try {
            this.func_195666_b(level);
            if (this.spriteNormal != null) {
                if (this.spriteNormal.field_195670_c == null) {
                    this.loadShadersSprite(this.spriteNormal, -8421377);
                }
                this.spriteNormal.func_147963_d(level);
            }
            if (this.spriteSpecular != null) {
                if (this.spriteSpecular.field_195670_c == null) {
                    this.loadShadersSprite(this.spriteSpecular, 0);
                }
                this.spriteSpecular.func_147963_d(level);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Generating mipmaps for frame");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Frame being iterated");
            crashreportcategory.func_189529_a("Frame sizes", () -> {
                StringBuilder stringbuilder = new StringBuilder();
                for (NativeImage nativeimage : this.field_195670_c) {
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(nativeimage == null ? "null" : nativeimage.func_195702_a() + "x" + nativeimage.func_195714_b());
                }
                return stringbuilder.toString();
            });
            throw new ReportedException(crashreport);
        }
    }

    public void func_130103_l() {
        if (this.field_195670_c != null) {
            for (NativeImage nativeimage : this.field_195670_c) {
                if (nativeimage == null) continue;
                nativeimage.close();
            }
        }
        this.field_195670_c = null;
        if (this.field_176605_b != null) {
            for (NativeImage nativeimage1 : this.field_176605_b) {
                if (nativeimage1 == null) continue;
                nativeimage1.close();
            }
        }
        this.field_176605_b = null;
        if (this.spriteSingle != null) {
            this.spriteSingle.field_195670_c = null;
            this.spriteSingle.field_176605_b = null;
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.func_130103_l();
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.func_130103_l();
        }
    }

    public boolean func_130098_m() {
        return this.field_110982_k != null && this.field_110982_k.func_110473_c() > 1;
    }

    public String toString() {
        int i = this.field_195671_d == null ? 0 : this.field_195671_d.length;
        return "TextureAtlasSprite{name='" + this.field_110984_i + '\'' + ", frameCount=" + i + ", x=" + this.field_110975_c + ", y=" + this.field_110974_d + ", height=" + this.field_130224_d + ", width=" + this.field_130223_c + ", u0=" + this.field_110979_l + ", u1=" + this.field_110980_m + ", v0=" + this.field_110977_n + ", v1=" + this.field_110978_o + '}';
    }

    private int func_195665_a(int frameIndex, int levelIn, int xIn, int yIn) {
        return this.field_195670_c[levelIn].func_195709_a(xIn + (this.field_195671_d[frameIndex] * this.field_130223_c >> levelIn), yIn + (this.field_195672_e[frameIndex] * this.field_130224_d >> levelIn));
    }

    public boolean func_195662_a(int frameIndex, int pixelX, int pixelY) {
        return (this.field_195670_c[0].func_195709_a(pixelX + this.field_195671_d[frameIndex] * this.field_130223_c, pixelY + this.field_195672_e[frameIndex] * this.field_130224_d) >> 24 & 0xFF) == 0;
    }

    public void func_195663_q() {
        this.func_195659_d(0);
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        return this.field_195670_c[frameIndex].func_195709_a(x + this.field_195671_d[frameIndex] * this.field_130223_c, y + this.field_195672_e[frameIndex] * this.field_130224_d);
    }

    public int getIndexInMap() {
        return this.indexInMap;
    }

    public void setIndexInMap(int indexInMap) {
        this.indexInMap = indexInMap;
    }

    public void updateIndexInMap(CounterInt counter) {
        if (this.indexInMap < 0) {
            this.indexInMap = counter.nextValue();
        }
    }

    public int getAnimationIndex() {
        return this.animationIndex;
    }

    public void setAnimationIndex(int animationIndex) {
        this.animationIndex = animationIndex;
        if (this.spriteSingle != null) {
            this.spriteSingle.setAnimationIndex(animationIndex);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setAnimationIndex(animationIndex);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setAnimationIndex(animationIndex);
        }
    }

    public boolean isAnimationActive() {
        return this.animationActive;
    }

    private void fixTransparentColor(NativeImage ni) {
        int[] data = new int[ni.func_195702_a() * ni.func_195714_b()];
        ni.getBufferRGBA().get(data);
        this.fixTransparentColor(data);
        ni.getBufferRGBA().put(data);
    }

    private void fixTransparentColor(int[] data) {
        if (data == null) {
            return;
        }
        long redSum = 0L;
        long greenSum = 0L;
        long blueSum = 0L;
        long count = 0L;
        for (int i = 0; i < data.length; ++i) {
            int col = data[i];
            int alpha = col >> 24 & 0xFF;
            if (alpha < 16) continue;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col & 0xFF;
            redSum += (long)red;
            greenSum += (long)green;
            blueSum += (long)blue;
            ++count;
        }
        if (count <= 0L) {
            return;
        }
        int redAvg = (int)(redSum / count);
        int greenAvg = (int)(greenSum / count);
        int blueAvg = (int)(blueSum / count);
        int colAvg = redAvg << 16 | greenAvg << 8 | blueAvg;
        for (int i = 0; i < data.length; ++i) {
            int col = data[i];
            int alpha = col >> 24 & 0xFF;
            if (alpha > 16) continue;
            data[i] = colAvg;
        }
    }

    public double getSpriteU16(float atlasU) {
        float dU = this.field_110980_m - this.field_110979_l;
        return (atlasU - this.field_110979_l) / dU * 16.0f;
    }

    public double getSpriteV16(float atlasV) {
        float dV = this.field_110978_o - this.field_110977_n;
        return (atlasV - this.field_110977_n) / dV * 16.0f;
    }

    public void bindSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            this.glSpriteTextureId = TextureUtil.generateTextureId();
            TextureUtil.prepareImage((int)this.glSpriteTextureId, (int)this.mipmapLevels, (int)this.field_130223_c, (int)this.field_130224_d);
            TextureUtils.applyAnisotropicLevel();
        }
        TextureUtils.bindTexture(this.glSpriteTextureId);
    }

    public void deleteSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            return;
        }
        TextureUtil.releaseTextureId((int)this.glSpriteTextureId);
        this.glSpriteTextureId = -1;
    }

    public float toSingleU(float u) {
        u -= this.baseU;
        float ku = (float)this.sheetWidth / (float)this.field_130223_c;
        return u *= ku;
    }

    public float toSingleV(float v) {
        v -= this.baseV;
        float kv = (float)this.sheetHeight / (float)this.field_130224_d;
        return v *= kv;
    }

    public NativeImage[] getMipmapImages() {
        return this.field_195670_c;
    }

    public AnimationMetadataSection getAnimationMetadata() {
        return this.field_110982_k;
    }

    public void setAnimationMetadata(AnimationMetadataSection animationMetadata) {
        this.field_110982_k = animationMetadata;
    }

    private TextureAtlasSprite loadShadersSprite(TextureAtlasSprite sprite, int colDef) {
        sprite.func_130103_l();
        try {
            ResourceLocation locImage = this.textureMap.func_195420_b(sprite.func_195668_m());
            if (this.resourceManager != null) {
                IResource res = this.resourceManager.func_199002_a(locImage);
                AnimationMetadataSection animationMetadata = (AnimationMetadataSection)res.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                sprite.setAnimationMetadata(animationMetadata);
                sprite.func_195664_a(res, this.mipmapLevels + 1);
                return sprite;
            }
        }
        catch (IOException locImage) {
            // empty catch block
        }
        NativeImage image = new NativeImage(sprite.func_94211_a(), sprite.func_94216_b(), false);
        int colAbgr = TextureUtils.toAbgr(colDef);
        image.func_195715_a(0, 0, sprite.func_94211_a(), sprite.func_94216_b(), colAbgr);
        sprite.setMipmapImages(new NativeImage[]{image});
        return sprite;
    }

    public void copyFrom(TextureAtlasSprite atlasSpriteIn) {
        this.field_110975_c = atlasSpriteIn.field_110975_c;
        this.field_110974_d = atlasSpriteIn.field_110974_d;
        this.field_130223_c = atlasSpriteIn.field_130223_c;
        this.field_130224_d = atlasSpriteIn.field_130224_d;
        this.field_110979_l = atlasSpriteIn.field_110979_l;
        this.field_110980_m = atlasSpriteIn.field_110980_m;
        this.field_110977_n = atlasSpriteIn.field_110977_n;
        this.field_110978_o = atlasSpriteIn.field_110978_o;
        if (!(atlasSpriteIn instanceof MissingTextureSprite)) {
            this.indexInMap = atlasSpriteIn.indexInMap;
        }
        this.baseU = atlasSpriteIn.baseU;
        this.baseV = atlasSpriteIn.baseV;
        this.sheetWidth = atlasSpriteIn.sheetWidth;
        this.sheetHeight = atlasSpriteIn.sheetHeight;
        this.glSpriteTextureId = atlasSpriteIn.glSpriteTextureId;
        this.mipmapLevels = atlasSpriteIn.mipmapLevels;
        this.terrain = atlasSpriteIn.terrain;
        this.multiTexture = atlasSpriteIn.multiTexture;
        this.shaders = atlasSpriteIn.shaders;
        if (this.spriteSingle != null) {
            this.spriteSingle.func_217789_a(this.field_130223_c, this.field_130224_d, 0, 0);
        }
        this.animationIndex = atlasSpriteIn.animationIndex;
    }

    public void setIconWidth(int newWidth) {
        this.field_130223_c = newWidth;
        if (this.spriteSingle != null) {
            this.spriteSingle.setIconWidth(this.field_130223_c);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setIconWidth(this.field_130223_c);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setIconWidth(this.field_130223_c);
        }
    }

    public void setIconHeight(int newHeight) {
        this.field_130224_d = newHeight;
        if (this.spriteSingle != null) {
            this.spriteSingle.setIconHeight(this.field_130224_d);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setIconHeight(this.field_130224_d);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setIconHeight(this.field_130224_d);
        }
    }

    public void setMipmapImages(NativeImage[] frames) {
        this.field_195670_c = frames;
    }

    public int getOriginX() {
        return this.field_110975_c;
    }

    public int getOriginY() {
        return this.field_110974_d;
    }

    public TextureAtlasSprite makeSpriteSingle() {
        ResourceLocation locSingle = new ResourceLocation(this.field_110984_i.func_110624_b(), this.field_110984_i.func_110623_a() + ".sprite_single");
        TextureAtlasSprite ss = new TextureAtlasSprite(locSingle, this.field_130223_c, this.field_130224_d);
        ss.field_110982_k = this.field_110982_k;
        ss.isSpriteSingle = true;
        ss.setTerrain(this.terrain);
        return ss;
    }

    public TextureAtlasSprite makeSpriteShaders(String suffix) {
        ResourceLocation loc = new ResourceLocation(this.field_110984_i.func_110624_b(), this.field_110984_i.func_110623_a() + suffix);
        TextureAtlasSprite ss = new TextureAtlasSprite(loc, this.field_130223_c, this.field_130224_d);
        ss.copyFrom(this);
        ss.isSpriteShaders = true;
        return ss;
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    private void setTerrain(boolean terrainIn) {
        this.terrain = terrainIn;
        this.multiTexture = false;
        this.shaders = false;
        if (this.spriteSingle != null) {
            this.spriteSingle.deleteSpriteTexture();
            this.spriteSingle = null;
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.func_130103_l();
            this.spriteNormal = null;
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.func_130103_l();
            this.spriteSpecular = null;
        }
        if (this.terrain) {
            this.multiTexture = Config.isMultiTexture();
            this.shaders = Config.isShaders();
            if (this.multiTexture && !this.isSpriteSingle) {
                this.spriteSingle = this.makeSpriteSingle();
            }
            if (this.shaders && !this.isSpriteSingle) {
                if (this.spriteNormal == null && Shaders.configNormalMap) {
                    this.spriteNormal = this.makeSpriteShaders("_n");
                }
                if (this.spriteSpecular == null && Shaders.configSpecularMap) {
                    this.spriteSpecular = this.makeSpriteShaders("_s");
                }
            }
        }
    }

    public void update(AtlasTexture textureMap, IResourceManager resourceManager) {
        this.textureMap = textureMap;
        this.resourceManager = resourceManager;
        this.updateIndexInMap(textureMap.getCounterIndexInMap());
        this.mipmapLevels = textureMap.getMipmapLevels();
        this.setTerrain(textureMap.isTerrain());
    }
}

