/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.optifine.BetterGrass;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.CustomItems;
import net.optifine.EmissiveTextures;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class AtlasTexture
extends Texture
implements ITickableTextureObject {
    private static final Logger field_147635_d = LogManager.getLogger();
    public static final ResourceLocation field_110575_b = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation field_215262_g = new ResourceLocation("textures/atlas/particles.png");
    public static final ResourceLocation field_215263_h = new ResourceLocation("textures/atlas/paintings.png");
    public static final ResourceLocation field_215264_i = new ResourceLocation("textures/atlas/mob_effects.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final String field_94254_c;
    private final int field_215265_o;
    private int field_147636_j;
    private MissingTextureSprite field_94249_f = MissingTextureSprite.func_217790_a();
    private Map<ResourceLocation, TextureAtlasSprite> mapRegisteredSprites = new LinkedHashMap();
    private Map<ResourceLocation, TextureAtlasSprite> mapMissingSprites = new LinkedHashMap();
    private TextureAtlasSprite[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private CounterInt counterIndexInMap = new CounterInt(0);
    public int atlasWidth = 0;
    public int atlasHeight = 0;
    private int countAnimationsActive;
    private int frameCountAnimations;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;

    public AtlasTexture(String p_i513_1_) {
        this.field_94254_c = p_i513_1_;
        this.field_215265_o = Minecraft.func_71369_N();
        this.terrain = this.field_94254_c.equals("textures");
        this.shaders = this.terrain && Config.isShaders();
        this.multiTexture = this.terrain && Config.isMultiTexture();
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        if (this.shaders) {
            ShadersTex.resManager = manager;
        }
    }

    public void func_215260_a(SheetData p_215260_1_) {
        this.field_195427_i.clear();
        this.field_195427_i.addAll(p_215260_1_.field_217805_a);
        field_147635_d.info("Created: {}x{} {}-atlas", (Object)p_215260_1_.field_217806_b, (Object)p_215260_1_.field_217807_c, (Object)this.field_94254_c);
        TextureUtil.prepareImage((int)this.func_110552_b(), (int)this.field_147636_j, (int)p_215260_1_.field_217806_b, (int)p_215260_1_.field_217807_c);
        if (this.shaders) {
            ShadersTex.allocateTextureMapNS((int)this.field_147636_j, (int)p_215260_1_.field_217806_b, (int)p_215260_1_.field_217807_c, (AtlasTexture)this);
        }
        this.func_195419_g();
        for (TextureAtlasSprite textureatlassprite : p_215260_1_.field_217808_d) {
            if (this.shaders) {
                ShadersTex.setIconName((ResourceLocation)ShadersTex.setSprite((TextureAtlasSprite)textureatlassprite).func_195668_m());
            }
            this.field_94252_e.put(textureatlassprite.func_195668_m(), textureatlassprite);
            try {
                textureatlassprite.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Texture being stitched together");
                crashreportcategory.func_71507_a("Atlas path", (Object)this.field_94254_c);
                crashreportcategory.func_71507_a("Sprite", (Object)textureatlassprite);
                throw new ReportedException(crashreport);
            }
            if (!textureatlassprite.func_130098_m()) continue;
            if (this.terrain) {
                textureatlassprite.setAnimationIndex(this.field_94258_i.size());
            }
            this.field_94258_i.add(textureatlassprite);
        }
        if (this.terrain) {
            Config.log("Animated sprites: " + this.field_94258_i.size());
            if (Config.isMultiTexture()) {
                int sheetWidth = p_215260_1_.field_217806_b;
                int sheetHeight = p_215260_1_.field_217807_c;
                List listSprites = p_215260_1_.field_217808_d;
                for (TextureAtlasSprite tas : listSprites) {
                    tas.sheetWidth = sheetWidth;
                    tas.sheetHeight = sheetHeight;
                    tas.mipmapLevels = this.field_147636_j;
                    TextureAtlasSprite ss = tas.spriteSingle;
                    if (ss == null) continue;
                    if (ss.func_94211_a() <= 0) {
                        ss.setIconWidth(tas.func_94211_a());
                        ss.setIconHeight(tas.func_94216_b());
                        ss.func_217789_a(tas.func_94211_a(), tas.func_94216_b(), 0, 0);
                        ss.func_130103_l();
                        NativeImage[] frameDatas = tas.getMipmapImages();
                        ss.setMipmapImages(frameDatas);
                        ss.setAnimationMetadata(tas.getAnimationMetadata());
                    }
                    ss.sheetWidth = sheetWidth;
                    ss.sheetHeight = sheetHeight;
                    ss.mipmapLevels = this.field_147636_j;
                    ss.setAnimationIndex(tas.getAnimationIndex());
                    tas.bindSpriteTexture();
                    boolean texBlur = false;
                    boolean texClamp = true;
                    try {
                        ss.func_195663_q();
                    }
                    catch (Exception e) {
                        Config.dbg("Error uploading sprite single: " + ss + ", parent: " + tas);
                        e.printStackTrace();
                    }
                }
                Config.getMinecraft().func_110434_K().func_110577_a(field_110575_b);
            }
            if (Config.isShaders()) {
                List listSprites = p_215260_1_.field_217808_d;
                if (Shaders.configNormalMap) {
                    GlStateManager.bindTexture((int)this.getMultiTexID().norm);
                    for (TextureAtlasSprite tas : listSprites) {
                        TextureAtlasSprite spriteNormal = tas.spriteNormal;
                        if (spriteNormal == null) continue;
                        spriteNormal.func_195663_q();
                    }
                }
                if (Shaders.configSpecularMap) {
                    GlStateManager.bindTexture((int)this.getMultiTexID().spec);
                    for (TextureAtlasSprite tas : listSprites) {
                        TextureAtlasSprite spriteSpecular = tas.spriteSpecular;
                        if (spriteSpecular == null) continue;
                        spriteSpecular.func_195663_q();
                    }
                }
                GlStateManager.bindTexture((int)this.getMultiTexID().base);
            }
            Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
            this.updateIconGrid(p_215260_1_.field_217806_b, p_215260_1_.field_217807_c);
        }
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            Config.dbg("Exporting texture map: " + this.field_94254_c);
            TextureUtils.saveGlTexture("debug/" + this.field_94254_c.replaceAll("/", "_"), this.func_110552_b(), this.field_147636_j, p_215260_1_.field_217806_b, p_215260_1_.field_217807_c);
        }
    }

    public SheetData func_215254_a(IResourceManager resourceManagerIn, Iterable<ResourceLocation> resourceLocationsIn, IProfiler profilerIn) {
        int minSpriteSize;
        this.terrain = this.field_94254_c.equals("textures");
        this.shaders = this.terrain && Config.isShaders();
        this.multiTexture = this.terrain && Config.isMultiTexture();
        this.mapRegisteredSprites.clear();
        this.mapMissingSprites.clear();
        this.field_94249_f = MissingTextureSprite.func_217790_a();
        if (this.terrain) {
            this.counterIndexInMap.reset();
            Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this);
        }
        HashSet set = Sets.newHashSet();
        profilerIn.func_76320_a("preparing");
        resourceLocationsIn.forEach(p_215253_1_ -> {
            if (p_215253_1_ == null) {
                throw new IllegalArgumentException("Location cannot be null!");
            }
            set.add(p_215253_1_);
        });
        if (this.terrain) {
            ShadersTex.resManager = resourceManagerIn;
            Config.dbg("Multitexture: " + Config.isMultiTexture());
            ConnectedTextures.updateIcons((AtlasTexture)this);
            CustomItems.updateIcons((AtlasTexture)this);
            BetterGrass.updateIcons((AtlasTexture)this);
            set.addAll(this.mapRegisteredSprites.keySet());
            Set locsEmissive = AtlasTexture.newHashSet((Set)set, this.mapRegisteredSprites.keySet());
            EmissiveTextures.updateIcons((AtlasTexture)this, (Set)locsEmissive);
            set.addAll(this.mapRegisteredSprites.keySet());
            if (this.field_147636_j >= 4) {
                this.field_147636_j = this.detectMaxMipmapLevel((Set)set, resourceManagerIn);
                Config.log("Mipmap levels: " + this.field_147636_j);
            }
        }
        int i = TextureUtils.getGLMaximumTextureSize();
        Stitcher stitcher = new Stitcher(i, i, this.field_147636_j);
        int j = Integer.MAX_VALUE;
        this.iconGridSize = minSpriteSize = this.getMinSpriteSize();
        if (this.terrain) {
            this.field_94249_f.setMinSize(minSpriteSize);
            this.field_94249_f.update(this, null);
        }
        int k = 1 << this.field_147636_j;
        profilerIn.func_219895_b("extracting_frames");
        for (TextureAtlasSprite textureatlassprite : this.func_215256_a(resourceManagerIn, (Set)set)) {
            if (this.terrain) {
                int ws = textureatlassprite.func_94211_a();
                int hs = textureatlassprite.func_94216_b();
                if (ws < 1 || hs < 1) {
                    Config.warn("Invalid sprite size: " + textureatlassprite);
                    continue;
                }
                if (ws < minSpriteSize || this.field_147636_j > 0) {
                    int ws2;
                    int n = ws2 = this.field_147636_j > 0 ? TextureUtils.scaleToGrid(ws, minSpriteSize) : TextureUtils.scaleToMin(ws, minSpriteSize);
                    if (ws2 != ws) {
                        if (!TextureUtils.isPowerOfTwo(ws)) {
                            Config.log("Scaled non power of 2: " + textureatlassprite.func_195668_m() + ", " + ws + " -> " + ws2);
                        } else {
                            Config.log("Scaled too small texture: " + textureatlassprite.func_195668_m() + ", " + ws + " -> " + ws2);
                        }
                        int hs2 = hs * ws2 / ws;
                        textureatlassprite.setIconWidth(ws2);
                        textureatlassprite.setIconHeight(hs2);
                    }
                }
            }
            j = Math.min(j, Math.min(textureatlassprite.func_94211_a(), textureatlassprite.func_94216_b()));
            int l2 = Math.min(Integer.lowestOneBit(textureatlassprite.func_94211_a()), Integer.lowestOneBit(textureatlassprite.func_94216_b()));
            if (l2 < k) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)textureatlassprite.func_195668_m(), (Object)textureatlassprite.func_94211_a(), (Object)textureatlassprite.func_94216_b(), (Object)MathHelper.func_151239_c((int)k), (Object)MathHelper.func_151239_c((int)l2));
                k = l2;
            }
            stitcher.func_110934_a(textureatlassprite);
        }
        int i1 = Math.min(j, k);
        int j1 = MathHelper.func_151239_c((int)i1);
        if (j1 < 0) {
            j1 = 0;
        }
        if (j1 < this.field_147636_j) {
            field_147635_d.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.field_94254_c, (Object)this.field_147636_j, (Object)j1, (Object)i1);
            this.field_147636_j = j1;
        }
        profilerIn.func_219895_b("mipmapping");
        this.field_94249_f.func_147963_d(this.field_147636_j);
        profilerIn.func_219895_b("register");
        stitcher.func_110934_a((TextureAtlasSprite)this.field_94249_f);
        profilerIn.func_219895_b("stitching");
        stitcher.func_94305_f();
        profilerIn.func_219895_b("loading");
        List list = this.func_215259_a(resourceManagerIn, stitcher);
        for (TextureAtlasSprite sprite : this.mapMissingSprites.values()) {
            sprite.copyFrom((TextureAtlasSprite)this.field_94249_f);
        }
        profilerIn.func_76319_b();
        return new SheetData((Set)set, stitcher.func_110935_a(), stitcher.func_110936_b(), list);
    }

    private Collection<TextureAtlasSprite> func_215256_a(IResourceManager p_215256_1_, Set<ResourceLocation> p_215256_2_) {
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>();
        ConcurrentLinkedQueue<TextureAtlasSprite> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite>();
        for (ResourceLocation resourcelocation : p_215256_2_) {
            if (this.field_94249_f.func_195668_m().equals((Object)resourcelocation)) continue;
            list.add(CompletableFuture.runAsync(() -> {
                TextureAtlasSprite textureatlassprite;
                ResourceLocation resourcelocation1 = this.func_195420_b(resourcelocation);
                try (IResource iresource = p_215256_1_.func_199002_a(resourcelocation1);){
                    PngSizeInfo pngsizeinfo = new PngSizeInfo(iresource.toString(), iresource.func_199027_b());
                    AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
                    textureatlassprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(resourcelocation);
                    if (textureatlassprite != null) {
                        textureatlassprite.init(pngsizeinfo, animationmetadatasection);
                    } else {
                        textureatlassprite = new TextureAtlasSprite(resourcelocation, pngsizeinfo, animationmetadatasection);
                        this.mapRegisteredSprites.put(resourcelocation, textureatlassprite);
                    }
                    textureatlassprite.update(this, p_215256_1_);
                }
                catch (RuntimeException runtimeexception) {
                    field_147635_d.error("Unable to parse metadata from {} : {}", (Object)resourcelocation1, (Object)runtimeexception);
                    Reflector.call(Reflector.ClientHooks_trackBrokenTexture, resourcelocation1, runtimeexception.getMessage());
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                catch (IOException ioexception) {
                    field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)resourcelocation1, (Object)ioexception);
                    Reflector.call(Reflector.ClientHooks_trackMissingTexture, resourcelocation1);
                    this.onSpriteMissing(resourcelocation);
                    return;
                }
                concurrentlinkedqueue.add(textureatlassprite);
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return concurrentlinkedqueue;
    }

    private List<TextureAtlasSprite> func_215259_a(IResourceManager resourceManagerIn, Stitcher stitcherIn) {
        ConcurrentLinkedQueue<TextureAtlasSprite> concurrentlinkedqueue = new ConcurrentLinkedQueue<TextureAtlasSprite>();
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>();
        for (TextureAtlasSprite textureatlassprite : stitcherIn.func_94309_g()) {
            if (textureatlassprite instanceof MissingTextureSprite) {
                concurrentlinkedqueue.add(textureatlassprite);
                continue;
            }
            list.add(CompletableFuture.runAsync(() -> {
                if (this.func_195422_a(resourceManagerIn, textureatlassprite)) {
                    concurrentlinkedqueue.add(textureatlassprite);
                }
            }, Util.func_215072_e()));
        }
        CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).join();
        return new ArrayList<TextureAtlasSprite>(concurrentlinkedqueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_195422_a(IResourceManager manager, TextureAtlasSprite sprite) {
        block9: {
            boolean flag;
            ResourceLocation resourcelocation = this.func_195420_b(sprite.func_195668_m());
            IResource iresource = null;
            try {
                iresource = manager.func_199002_a(resourcelocation);
                sprite.func_195664_a(iresource, this.field_147636_j + 1);
                break block9;
            }
            catch (RuntimeException runtimeexception) {
                field_147635_d.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
                flag = false;
            }
            catch (IOException ioexception) {
                boolean flag2;
                field_147635_d.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
                boolean bl = flag2 = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Closeable)iresource);
            }
            return flag;
        }
        try {
            sprite.func_147963_d(this.field_147636_j);
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Applying mipmap");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Sprite being mipmapped");
            crashreportcategory.func_189529_a("Sprite name", () -> sprite.func_195668_m().toString());
            crashreportcategory.func_189529_a("Sprite size", () -> sprite.func_94211_a() + " x " + sprite.func_94216_b());
            crashreportcategory.func_189529_a("Sprite frames", () -> sprite.func_110970_k() + " frames");
            crashreportcategory.func_71507_a("Mipmap levels", (Object)this.field_147636_j);
            throw new ReportedException(crashreport);
        }
    }

    public ResourceLocation func_195420_b(ResourceLocation location) {
        if (this.isAbsoluteLocation(location)) {
            return new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".png");
        }
        return new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, location.func_110623_a(), ".png"));
    }

    public TextureAtlasSprite func_110572_b(String iconName) {
        return this.func_195424_a(new ResourceLocation(iconName));
    }

    public void func_94248_c() {
        if (this.shaders) {
            ShadersTex.updatingTex = this.getMultiTexID();
        }
        boolean hasNormal = false;
        boolean hasSpecular = false;
        this.func_195412_h();
        int countActive = 0;
        for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
            if (this.terrain && !this.isTerrainAnimationActive(textureatlassprite)) continue;
            textureatlassprite.func_94219_l();
            if (!this.terrain) continue;
            if (textureatlassprite.isAnimationActive()) {
                ++countActive;
            }
            if (textureatlassprite.spriteNormal != null) {
                hasNormal = true;
            }
            if (textureatlassprite.spriteSpecular == null) continue;
            hasSpecular = true;
        }
        if (this.terrain) {
            int frameCount;
            if (Config.isMultiTexture()) {
                for (TextureAtlasSprite ts : this.field_94258_i) {
                    TextureAtlasSprite spriteSingle;
                    if (!this.isTerrainAnimationActive(ts) || (spriteSingle = ts.spriteSingle) == null) continue;
                    ts.bindSpriteTexture();
                    spriteSingle.func_94219_l();
                    if (!spriteSingle.isAnimationActive()) continue;
                    ++countActive;
                }
                GlStateManager.bindTexture((int)this.func_110552_b());
            }
            if (Config.isShaders()) {
                if (hasNormal) {
                    GlStateManager.bindTexture((int)this.getMultiTexID().norm);
                    for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
                        if (textureatlassprite.spriteNormal == null || !this.isTerrainAnimationActive(textureatlassprite)) continue;
                        textureatlassprite.spriteNormal.func_94219_l();
                        if (!textureatlassprite.spriteNormal.isAnimationActive()) continue;
                        ++countActive;
                    }
                }
                if (hasSpecular) {
                    GlStateManager.bindTexture((int)this.getMultiTexID().spec);
                    for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
                        if (textureatlassprite.spriteSpecular == null || !this.isTerrainAnimationActive(textureatlassprite)) continue;
                        textureatlassprite.spriteSpecular.func_94219_l();
                        if (!textureatlassprite.spriteSpecular.isAnimationActive()) continue;
                        ++countActive;
                    }
                }
                if (hasNormal || hasSpecular) {
                    GlStateManager.bindTexture((int)this.func_110552_b());
                }
            }
            if ((frameCount = Config.getMinecraft().field_71460_t.field_175084_ae) != this.frameCountAnimations) {
                this.countAnimationsActive = countActive;
                this.frameCountAnimations = frameCount;
            }
            if (SmartAnimations.isActive()) {
                SmartAnimations.resetSpritesRendered();
            }
            if (Config.isShaders()) {
                ShadersTex.updatingTex = null;
            }
        }
    }

    public void func_110550_d() {
        this.func_94248_c();
    }

    public void func_147633_a(int mipmapLevelsIn) {
        this.field_147636_j = mipmapLevelsIn;
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation location) {
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.field_94252_e.get(location);
        return textureatlassprite == null ? this.field_94249_f : textureatlassprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureatlassprite : this.field_94252_e.values()) {
            textureatlassprite.func_130103_l();
        }
        if (this.multiTexture) {
            for (TextureAtlasSprite ts : this.field_94252_e.values()) {
                ts.deleteSpriteTexture();
            }
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }

    public TextureAtlasSprite getTextureExtry(String name) {
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(name);
    }

    public boolean setTextureEntry(TextureAtlasSprite entry) {
        ResourceLocation name = entry.func_195668_m();
        if (!this.field_195427_i.contains(name)) {
            this.field_195427_i.add(name);
            this.mapRegisteredSprites.put(name, entry);
            entry.updateIndexInMap(this.counterIndexInMap);
            return true;
        }
        return false;
    }

    public String getBasePath() {
        return this.field_94254_c;
    }

    public int getMipmapLevels() {
        return this.field_147636_j;
    }

    private boolean isAbsoluteLocation(ResourceLocation loc) {
        String path = loc.func_110623_a();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("optifine/");
    }

    public TextureAtlasSprite getSpriteSafe(String name) {
        ResourceLocation loc = new ResourceLocation(name);
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(loc);
    }

    public TextureAtlasSprite getRegisteredSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)this.mapRegisteredSprites.get(loc.toString());
    }

    private boolean isTerrainAnimationActive(TextureAtlasSprite ts) {
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        return Config.isAnimatedTerrain();
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap.getValue();
    }

    private int detectMaxMipmapLevel(Set<ResourceLocation> setSpriteLocations, IResourceManager rm) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(setSpriteLocations, rm, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = MathHelper.func_151236_b((int)minSize)) > 16) {
            Config.log("Sprite size: " + minSize);
        }
        if ((minLevel = MathHelper.func_151239_c((int)minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Set<ResourceLocation> setSpriteLocations, IResourceManager rm, int percentScale) {
        int count;
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        for (ResourceLocation loc : setSpriteLocations) {
            ResourceLocation locComplete = this.func_195420_b(loc);
            try {
                Dimension dim;
                InputStream in;
                IResource res = rm.func_199002_a(locComplete);
                if (res == null || (in = res.func_199027_b()) == null || (dim = TextureUtils.getImageSize(in, "png")) == null) continue;
                int width = dim.width;
                int width2 = MathHelper.func_151236_b((int)width);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                count = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count + 1);
            }
            catch (Exception e) {}
        }
        int countSprites = 0;
        Set setSizes = mapSizeCounts.keySet();
        TreeSet setSizesSorted = new TreeSet(setSizes);
        Iterator it = setSizesSorted.iterator();
        while (it.hasNext()) {
            int size = (Integer)it.next();
            int count2 = (Integer)mapSizeCounts.get(size);
            countSprites += count2;
        }
        int minSize = 16;
        int countScale = 0;
        int countScaleMax = countSprites * percentScale / 100;
        Iterator it2 = setSizesSorted.iterator();
        while (it2.hasNext()) {
            int size = (Integer)it2.next();
            count = (Integer)mapSizeCounts.get(size);
            countScale += count;
            if (size > minSize) {
                minSize = size;
            }
            if (countScale <= countScaleMax) continue;
            return minSize;
        }
        return minSize;
    }

    private int getMinSpriteSize() {
        int minSize = 1 << this.field_147636_j;
        if (minSize < 8) {
            minSize = 8;
        }
        return minSize;
    }

    public boolean isTextureBound() {
        int texId;
        int boundTexId = GlStateManager.getBoundTexture();
        return boundTexId == (texId = this.func_110552_b());
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new TextureAtlasSprite[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (TextureAtlasSprite ts : this.field_94252_e.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.func_94209_e(), ts.func_94212_f()) + deltaU;
            double vMin = (double)Math.min(ts.func_94206_g(), ts.func_94210_h()) + deltaV;
            double uMax = (double)Math.max(ts.func_94209_e(), ts.func_94212_f()) - deltaU;
            double vMax = (double)Math.max(ts.func_94206_g(), ts.func_94210_h()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu = iuMin; iu <= iuMax; ++iu) {
                if (iu < 0 || iu >= this.iconGridCountX) {
                    Config.warn("Invalid grid U: " + iu + ", icon: " + ts.func_195668_m());
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn("Invalid grid V: " + iv + ", icon: " + ts.func_195668_m());
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public TextureAtlasSprite getIconByUV(double u, double v) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v / this.iconGridSizeV);
        int iu = (int)(u / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }

    public int getCountAnimations() {
        return this.field_94258_i.size();
    }

    public int getCountAnimationsActive() {
        return this.countAnimationsActive;
    }

    public TextureAtlasSprite registerSprite(ResourceLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(location);
        if (sprite != null) {
            return sprite;
        }
        this.field_195427_i.add(location);
        sprite = new TextureAtlasSprite(location, 0, 0);
        this.mapRegisteredSprites.put(location, sprite);
        sprite.updateIndexInMap(this.counterIndexInMap);
        return sprite;
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    public CounterInt getCounterIndexInMap() {
        return this.counterIndexInMap;
    }

    private void onSpriteMissing(ResourceLocation loc) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.mapRegisteredSprites.get(loc);
        if (sprite == null) {
            return;
        }
        this.mapMissingSprites.put(loc, sprite);
    }

    private static <T> Set<T> newHashSet(Set<T> set1, Set<T> set2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }
}

