/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.optifine.CustomItems;
import net.optifine.reflect.Reflector;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelBakery {
    public static final ResourceLocation field_207763_a = new ResourceLocation("block/fire_0");
    public static final ResourceLocation field_207764_b = new ResourceLocation("block/fire_1");
    public static final ResourceLocation field_207766_d = new ResourceLocation("block/lava_flow");
    public static final ResourceLocation field_207768_f = new ResourceLocation("block/water_flow");
    public static final ResourceLocation field_207769_g = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation field_207770_h = new ResourceLocation("block/destroy_stage_0");
    public static final ResourceLocation field_207771_i = new ResourceLocation("block/destroy_stage_1");
    public static final ResourceLocation field_207772_j = new ResourceLocation("block/destroy_stage_2");
    public static final ResourceLocation field_207773_k = new ResourceLocation("block/destroy_stage_3");
    public static final ResourceLocation field_207774_l = new ResourceLocation("block/destroy_stage_4");
    public static final ResourceLocation field_207775_m = new ResourceLocation("block/destroy_stage_5");
    public static final ResourceLocation field_207776_n = new ResourceLocation("block/destroy_stage_6");
    public static final ResourceLocation field_207777_o = new ResourceLocation("block/destroy_stage_7");
    public static final ResourceLocation field_207778_p = new ResourceLocation("block/destroy_stage_8");
    public static final ResourceLocation field_207779_q = new ResourceLocation("block/destroy_stage_9");
    private static final Set<ResourceLocation> field_177602_b = Sets.newHashSet((Object[])new ResourceLocation[]{field_207768_f, field_207766_d, field_207769_g, field_207763_a, field_207764_b, field_207770_h, field_207771_i, field_207772_j, field_207773_k, field_207774_l, field_207775_m, field_207776_n, field_207777_o, field_207778_p, field_207779_q, new ResourceLocation("item/empty_armor_slot_helmet"), new ResourceLocation("item/empty_armor_slot_chestplate"), new ResourceLocation("item/empty_armor_slot_leggings"), new ResourceLocation("item/empty_armor_slot_boots"), new ResourceLocation("item/empty_armor_slot_shield")});
    private static final Logger field_177603_c = LogManager.getLogger();
    public static final ModelResourceLocation field_177604_a = new ModelResourceLocation("builtin/missing", "missing");
    @VisibleForTesting
    public static final String field_188641_d = ("{    'textures': {       'particle': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "',       'missingno': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> field_177600_d = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)field_188641_d));
    private static final Splitter field_209611_w = Splitter.on((char)',');
    private static final Splitter field_209612_x = Splitter.on((char)'=').limit(2);
    public static final BlockModel field_177606_o = (BlockModel)Util.func_200696_a((Object)BlockModel.func_178294_a((String)"{}"), p_209273_0_ -> {
        p_209273_0_.field_178317_b = "generation marker";
    });
    public static final BlockModel field_177616_r = (BlockModel)Util.func_200696_a((Object)BlockModel.func_178294_a((String)"{}"), p_209274_0_ -> {
        p_209274_0_.field_178317_b = "block entity marker";
    });
    private static final StateContainer<Block, BlockState> field_209613_y = new StateContainer.Builder((Object)Blocks.field_150350_a).func_206894_a(new IProperty[]{BooleanProperty.func_177716_a((String)"map")}).func_206893_a(BlockState::new);
    private static final ItemModelGenerator field_217854_z = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateContainer<Block, BlockState>> field_209607_C = ImmutableMap.of((Object)new ResourceLocation("item_frame"), (Object)field_209613_y);
    private final IResourceManager field_177598_f;
    private final AtlasTexture field_177609_j;
    private final Set<ResourceLocation> field_217848_D = Sets.newHashSet();
    private final BlockModelDefinition.ContainerHolder field_209610_F = new BlockModelDefinition.ContainerHolder();
    private final Map<ResourceLocation, IUnbakedModel> field_217849_F = Maps.newHashMap();
    private final Map<Triple<ResourceLocation, ModelRotation, Boolean>, IBakedModel> field_217850_G = Maps.newHashMap();
    private final Map<ResourceLocation, IUnbakedModel> field_217851_H = Maps.newHashMap();
    private final Map<ResourceLocation, IBakedModel> field_217852_I = Maps.newHashMap();
    private final AtlasTexture.SheetData field_217853_J;
    public Map<ResourceLocation, IUnbakedModel> mapUnbakedModels;

    public ModelBakery(IResourceManager p_i295_1_, AtlasTexture p_i295_2_, IProfiler p_i295_3_) {
        this.field_177598_f = p_i295_1_;
        this.field_177609_j = p_i295_2_;
        p_i295_3_.func_76320_a("missing_model");
        try {
            this.field_217849_F.put(field_177604_a, this.func_177594_c((ResourceLocation)field_177604_a));
            this.func_217843_a(field_177604_a);
        }
        catch (IOException ioexception) {
            field_177603_c.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        p_i295_3_.func_219895_b("static_definitions");
        field_209607_C.forEach((p_217842_1_, p_217842_2_) -> p_217842_2_.func_177619_a().forEach(p_217836_2_ -> this.func_217843_a(BlockModelShapes.func_209553_a((ResourceLocation)p_217842_1_, (BlockState)p_217836_2_))));
        p_i295_3_.func_219895_b("blocks");
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(p_217837_1_ -> this.func_217843_a(BlockModelShapes.func_209554_c((BlockState)p_217837_1_)));
        }
        p_i295_3_.func_219895_b("items");
        for (ResourceLocation resourcelocation : Registry.field_212630_s.func_148742_b()) {
            this.func_217843_a(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        p_i295_3_.func_219895_b("special");
        this.func_217843_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        p_i295_3_.func_219895_b("textures");
        this.mapUnbakedModels = this.field_217849_F;
        CustomItems.update();
        CustomItems.loadModels((ModelBakery)this);
        LinkedHashSet set = Sets.newLinkedHashSet();
        Set set1 = this.field_217851_H.values().stream().flatMap(p_217838_2_ -> p_217838_2_.func_209559_a(arg_0 -> this.func_209597_a(arg_0), set).stream()).collect(Collectors.toSet());
        set1.addAll(field_177602_b);
        set.forEach(p_217833_0_ -> field_177603_c.warn("Unable to resolve texture reference: {}", p_217833_0_));
        p_i295_3_.func_219895_b("stitching");
        this.field_217853_J = this.field_177609_j.func_215254_a(this.field_177598_f, set1, p_i295_3_);
        p_i295_3_.func_76319_b();
    }

    public void func_217844_a(IProfiler p_217844_1_) {
        p_217844_1_.func_76320_a("atlas");
        this.field_177609_j.func_215260_a(this.field_217853_J);
        p_217844_1_.func_219895_b("baking");
        this.field_217851_H.keySet().forEach(p_217835_1_ -> {
            IBakedModel ibakedmodel = null;
            try {
                ibakedmodel = this.func_217845_a(p_217835_1_, (ISprite)ModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to bake model: '{}': {}", p_217835_1_, (Object)exception);
            }
            if (ibakedmodel != null) {
                this.field_217852_I.put(p_217835_1_, ibakedmodel);
            }
        });
        p_217844_1_.func_76319_b();
    }

    private static Predicate<BlockState> func_209605_a(StateContainer<Block, BlockState> containerIn, String variantIn) {
        HashMap map = Maps.newHashMap();
        for (String s : field_209611_w.split((CharSequence)variantIn)) {
            Iterator iterator = field_209612_x.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            IProperty iproperty = containerIn.func_185920_a(s1);
            if (iproperty != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Comparable comparable = ModelBakery.func_209592_a((IProperty)iproperty, (String)s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + iproperty.func_177700_c());
                }
                map.put(iproperty, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)containerIn.func_177622_c();
        return p_217840_2_ -> {
            if (p_217840_2_ != null && block == p_217840_2_.func_177230_c()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(p_217840_2_.func_177229_b((IProperty)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T func_209592_a(IProperty<T> property, String value) {
        return (T)property.func_185929_b(value).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnbakedModel func_209597_a(ResourceLocation modelLocation) {
        if (this.field_217849_F.containsKey(modelLocation)) {
            return (IUnbakedModel)this.field_217849_F.get(modelLocation);
        }
        if (this.field_217848_D.contains(modelLocation)) {
            throw new IllegalStateException("Circular reference while loading " + modelLocation);
        }
        this.field_217848_D.add(modelLocation);
        IUnbakedModel iunbakedmodel = (IUnbakedModel)this.field_217849_F.get(field_177604_a);
        while (!this.field_217848_D.isEmpty()) {
            ResourceLocation resourcelocation = (ResourceLocation)this.field_217848_D.iterator().next();
            try {
                if (this.field_217849_F.containsKey(resourcelocation)) continue;
                this.func_209598_b(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                field_177603_c.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.field_217849_F.put(resourcelocation, iunbakedmodel);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourcelocation, (Object)modelLocation);
                field_177603_c.warn(exception.getClass().getName() + ": " + exception.getMessage());
                this.field_217849_F.put(resourcelocation, iunbakedmodel);
            }
            finally {
                this.field_217848_D.remove(resourcelocation);
            }
        }
        return this.field_217849_F.getOrDefault(modelLocation, iunbakedmodel);
    }

    private void func_209598_b(ResourceLocation p_209598_1_) throws Exception {
        if (!(p_209598_1_ instanceof ModelResourceLocation)) {
            this.func_209593_a(p_209598_1_, (IUnbakedModel)this.func_177594_c(p_209598_1_));
        } else {
            ModelResourceLocation modelresourcelocation = (ModelResourceLocation)p_209598_1_;
            if (Objects.equals(modelresourcelocation.func_177518_c(), "inventory")) {
                ResourceLocation resourcelocation2 = new ResourceLocation(p_209598_1_.func_110624_b(), "item/" + p_209598_1_.func_110623_a());
                String path = p_209598_1_.func_110623_a();
                if (path.startsWith("optifine/") || path.startsWith("item/")) {
                    resourcelocation2 = p_209598_1_;
                }
                BlockModel blockmodel = this.func_177594_c(resourcelocation2);
                this.func_209593_a((ResourceLocation)modelresourcelocation, (IUnbakedModel)blockmodel);
                this.field_217849_F.put(resourcelocation2, blockmodel);
            } else {
                ResourceLocation resourcelocation1;
                HashMap map1;
                HashMap map;
                block25: {
                    block24: {
                        ResourceLocation resourcelocation = new ResourceLocation(p_209598_1_.func_110624_b(), p_209598_1_.func_110623_a());
                        StateContainer statecontainer = Optional.ofNullable(field_209607_C.get(resourcelocation)).orElseGet(() -> ((Block)Registry.field_212618_g.func_82594_a(resourcelocation)).func_176194_O());
                        this.field_209610_F.func_209573_a(statecontainer);
                        ImmutableList immutablelist = statecontainer.func_177619_a();
                        map = Maps.newHashMap();
                        immutablelist.forEach(p_217830_2_ -> {
                            BlockState blockstate = map.put(BlockModelShapes.func_209553_a((ResourceLocation)resourcelocation, (BlockState)p_217830_2_), p_217830_2_);
                        });
                        map1 = Maps.newHashMap();
                        resourcelocation1 = new ResourceLocation(p_209598_1_.func_110624_b(), "blockstates/" + p_209598_1_.func_110623_a() + ".json");
                        boolean flag = false;
                        try {
                            List lvt_9_4_;
                            try {
                                flag = true;
                                lvt_9_4_ = this.field_177598_f.func_199004_b(resourcelocation1).stream().map(p_217839_1_ -> {
                                    try {
                                        Pair pair1;
                                        try (InputStream inputstream = p_217839_1_.func_199027_b();){
                                            if (Reflector.ForgeModelBlockDefinition_fromJson3.exists()) {
                                                BlockModelDefinition mbd = (BlockModelDefinition)Reflector.call(Reflector.ForgeModelBlockDefinition_fromJson3, this.field_209610_F, new InputStreamReader(inputstream, StandardCharsets.UTF_8), p_209598_1_);
                                                pair1 = Pair.of((Object)p_217839_1_.func_199026_d(), (Object)mbd);
                                            } else {
                                                pair1 = Pair.of((Object)p_217839_1_.func_199026_d(), (Object)BlockModelDefinition.func_209577_a((BlockModelDefinition.ContainerHolder)this.field_209610_F, (Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8)));
                                            }
                                        }
                                        return pair1;
                                    }
                                    catch (Exception exception1) {
                                        throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", p_217839_1_.func_199029_a(), p_217839_1_.func_199026_d(), exception1.getMessage()));
                                    }
                                }).collect(Collectors.toList());
                            }
                            catch (IOException ioexception) {
                                field_177603_c.warn("Exception loading blockstate definition: {}: {}", (Object)resourcelocation1, (Object)ioexception);
                                flag = false;
                                break block24;
                            }
                            for (Pair pair : lvt_9_4_) {
                                Multipart iunbakedmodel;
                                BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pair.getSecond();
                                IdentityHashMap map2 = Maps.newIdentityHashMap();
                                if (blockmodeldefinition.func_188002_b()) {
                                    iunbakedmodel = blockmodeldefinition.func_188001_c();
                                    immutablelist.forEach(arg_0 -> ModelBakery.lambda$loadBlockstate$12(map2, (IUnbakedModel)iunbakedmodel, arg_0));
                                } else {
                                    iunbakedmodel = null;
                                }
                                blockmodeldefinition.func_209578_a().forEach((arg_0, arg_1) -> this.lambda$loadBlockstate$15(immutablelist, statecontainer, map2, (IUnbakedModel)iunbakedmodel, blockmodeldefinition, resourcelocation1, pair, arg_0, arg_1));
                                map1.putAll(map2);
                            }
                            flag = false;
                            break block25;
                        }
                        catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                            throw modelbakery$blockstatedefinitionexception;
                        }
                        catch (Exception exception) {
                            throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                        }
                        finally {
                            if (flag) {
                                Iterator iterator = map.entrySet().iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        continue;
                                    }
                                    Map.Entry entry = iterator.next();
                                    IUnbakedModel iunbakedmodel1 = (IUnbakedModel)map1.get(entry.getValue());
                                    if (iunbakedmodel1 == null) {
                                        field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, entry.getKey());
                                        iunbakedmodel1 = (IUnbakedModel)this.field_217849_F.get(field_177604_a);
                                    }
                                    this.func_209593_a((ResourceLocation)entry.getKey(), iunbakedmodel1);
                                }
                            }
                        }
                    }
                    for (Map.Entry entry2 : map.entrySet()) {
                        IUnbakedModel iunbakedmodel3 = (IUnbakedModel)map1.get(entry2.getValue());
                        if (iunbakedmodel3 == null) {
                            field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, entry2.getKey());
                            iunbakedmodel3 = (IUnbakedModel)this.field_217849_F.get(field_177604_a);
                        }
                        this.func_209593_a((ResourceLocation)entry2.getKey(), iunbakedmodel3);
                    }
                    return;
                }
                for (Map.Entry entry1 : map.entrySet()) {
                    IUnbakedModel iunbakedmodel2 = (IUnbakedModel)map1.get(entry1.getValue());
                    if (iunbakedmodel2 == null) {
                        field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, entry1.getKey());
                        iunbakedmodel2 = (IUnbakedModel)this.field_217849_F.get(field_177604_a);
                    }
                    this.func_209593_a((ResourceLocation)entry1.getKey(), iunbakedmodel2);
                }
            }
        }
    }

    private void func_209593_a(ResourceLocation p_209593_1_, IUnbakedModel p_209593_2_) {
        this.field_217849_F.put(p_209593_1_, p_209593_2_);
        this.field_217848_D.addAll(p_209593_2_.func_187965_e());
    }

    public void func_217843_a(ModelResourceLocation p_217843_1_) {
        IUnbakedModel iunbakedmodel = this.func_209597_a((ResourceLocation)p_217843_1_);
        this.field_217849_F.put(p_217843_1_, iunbakedmodel);
        this.field_217851_H.put(p_217843_1_, iunbakedmodel);
    }

    @Nullable
    public IBakedModel func_217845_a(ResourceLocation p_217845_1_, ISprite p_217845_2_) {
        BlockModel blockmodel;
        Triple triple = Triple.of((Object)p_217845_1_, (Object)p_217845_2_.func_188048_b(), (Object)p_217845_2_.func_188049_c());
        if (this.field_217850_G.containsKey(triple)) {
            return (IBakedModel)this.field_217850_G.get(triple);
        }
        IUnbakedModel iunbakedmodel = this.func_209597_a(p_217845_1_);
        if (iunbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)iunbakedmodel).func_178310_f() == field_177606_o) {
            ItemModelGenerator itemmodelgenerator = field_217854_z;
            AtlasTexture atlastexture = this.field_177609_j;
            this.field_177609_j.getClass();
            BlockModel blockmodel1 = itemmodelgenerator.func_209579_a(arg_0 -> ((AtlasTexture)atlastexture).func_195424_a(arg_0), blockmodel);
            AtlasTexture atlastexture2 = this.field_177609_j;
            this.field_177609_j.getClass();
            return blockmodel1.func_217644_a(this, blockmodel, arg_0 -> ((AtlasTexture)atlastexture2).func_195424_a(arg_0), p_217845_2_);
        }
        AtlasTexture atlastexture1 = this.field_177609_j;
        this.field_177609_j.getClass();
        IBakedModel ibakedmodel = iunbakedmodel.func_217641_a(this, arg_0 -> ((AtlasTexture)atlastexture1).func_195424_a(arg_0), p_217845_2_);
        this.field_217850_G.put(triple, ibakedmodel);
        return ibakedmodel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockModel func_177594_c(ResourceLocation location) throws IOException {
        BlockModel lvt_5_2_;
        IResource iresource;
        Reader reader;
        block8: {
            ResourceLocation locationFile;
            String s;
            block9: {
                BlockModel lvt_5_2_2;
                reader = null;
                iresource = null;
                s = location.func_110623_a();
                locationFile = location;
                if ("builtin/generated".equals(s)) break block8;
                if (!"builtin/entity".equals(s)) break block9;
                BlockModel blockModel = lvt_5_2_2 = field_177616_r;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(iresource);
                return blockModel;
            }
            if (s.startsWith("builtin/")) {
                String s2 = s.substring("builtin/".length());
                String s1 = (String)field_177600_d.get(s2);
                if (s1 == null) {
                    throw new FileNotFoundException(location.toString());
                }
                reader = new StringReader(s1);
            } else {
                locationFile = this.getModelLocation(location);
                iresource = this.field_177598_f.func_199002_a(locationFile);
                reader = new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8);
            }
            BlockModel lvt_5_2_3 = BlockModel.func_178307_a((Reader)reader);
            lvt_5_2_3.field_178317_b = location.toString();
            BlockModel blockmodel1 = lvt_5_2_3;
            String basePath = TextureUtils.getBasePath(locationFile.func_110623_a());
            ModelBakery.fixModelLocations((BlockModel)blockmodel1, (String)basePath);
            BlockModel blockModel = blockmodel1;
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Closeable)iresource);
            return blockModel;
        }
        try {
            lvt_5_2_ = field_177606_o;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
        }
        return lvt_5_2_;
    }

    public Map<ResourceLocation, IBakedModel> func_217846_a() {
        return this.field_217852_I;
    }

    private ResourceLocation getModelLocation(ResourceLocation location) {
        String path = location.func_110623_a();
        if (path.startsWith("optifine/")) {
            if (!path.endsWith(".json")) {
                location = new ResourceLocation(location.func_110624_b(), path + ".json");
            }
            return location;
        }
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
    }

    public static void fixModelLocations(BlockModel modelBlock, String basePath) {
        ResourceLocation parentLocFixed = ModelBakery.fixModelLocation((ResourceLocation)modelBlock.field_178316_e, (String)basePath);
        if (parentLocFixed != modelBlock.field_178316_e) {
            modelBlock.field_178316_e = parentLocFixed;
        }
        if (modelBlock.field_178318_c != null) {
            for (Map.Entry entry : modelBlock.field_178318_c.entrySet()) {
                String path = (String)entry.getValue();
                String pathFixed = ModelBakery.fixResourcePath((String)path, (String)basePath);
                if (pathFixed == path) continue;
                entry.setValue(pathFixed);
            }
        }
    }

    public static ResourceLocation fixModelLocation(ResourceLocation loc, String basePath) {
        if (loc == null || basePath == null) {
            return loc;
        }
        if (!loc.func_110624_b().equals("minecraft")) {
            return loc;
        }
        String path = loc.func_110623_a();
        String pathFixed = ModelBakery.fixResourcePath((String)path, (String)basePath);
        if (pathFixed != path) {
            loc = new ResourceLocation(loc.func_110624_b(), pathFixed);
        }
        return loc;
    }

    private static String fixResourcePath(String path, String basePath) {
        path = TextureUtils.fixResourcePath(path, basePath);
        path = StrUtils.removeSuffix(path, ".json");
        path = StrUtils.removeSuffix(path, ".png");
        return path;
    }

    private /* synthetic */ void lambda$loadBlockstate$15(ImmutableList immutablelist, StateContainer statecontainer, Map map2, IUnbakedModel iunbakedmodel, BlockModelDefinition blockmodeldefinition, ResourceLocation resourcelocation1, Pair pair, String p_217834_8_, VariantList p_217834_9_) {
        try {
            immutablelist.stream().filter(ModelBakery.func_209605_a((StateContainer)statecontainer, (String)p_217834_8_)).forEach(p_217847_5_ -> {
                IUnbakedModel iunbakedmodel4 = (IUnbakedModel)map2.put(p_217847_5_, p_217834_9_);
                if (iunbakedmodel4 != null && iunbakedmodel4 != iunbakedmodel) {
                    map2.put(p_217847_5_, this.field_217849_F.get(field_177604_a));
                    throw new RuntimeException("Overlapping definition with: " + (String)blockmodeldefinition.func_209578_a().entrySet().stream().filter(p_217831_1_ -> p_217831_1_.getValue() == iunbakedmodel4).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception1) {
            field_177603_c.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", (Object)resourcelocation1, pair.getFirst(), (Object)p_217834_8_, (Object)exception1.getMessage());
        }
    }

    private static /* synthetic */ void lambda$loadBlockstate$12(Map map2, IUnbakedModel iunbakedmodel, BlockState p_217832_2_) {
        IUnbakedModel iunbakedmodel4 = map2.put(p_217832_2_, iunbakedmodel);
    }
}

