/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuadRetextured;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.IVertexProducer;
import net.optifine.Config;
import net.optifine.model.QuadBounds;
import net.optifine.reflect.Reflector;

/*
 * Exception performing whole class analysis ignored.
 */
public class BakedQuad
implements IVertexProducer {
    protected int[] field_178215_a;
    protected final int field_178213_b;
    protected Direction field_178214_c;
    protected TextureAtlasSprite field_187509_d;
    private int[] vertexDataSingle = null;
    protected boolean applyDiffuseLighting = Reflector.ForgeHooksClient_fillNormal.exists();
    protected VertexFormat format = DefaultVertexFormats.field_176599_b;
    private QuadBounds quadBounds;
    private boolean quadEmissiveChecked;
    private BakedQuad quadEmissive;

    public BakedQuad(int[] vertexDataIn, int tintIndexIn, Direction faceIn, TextureAtlasSprite spriteIn, boolean applyDiffuseLighting, VertexFormat format) {
        this.field_178215_a = vertexDataIn;
        this.field_178213_b = tintIndexIn;
        this.field_178214_c = faceIn;
        this.field_187509_d = spriteIn;
        this.applyDiffuseLighting = applyDiffuseLighting;
        this.format = format;
        this.fixVertexData();
    }

    public BakedQuad(int[] p_i547_1_, int p_i547_2_, Direction p_i547_3_, TextureAtlasSprite p_i547_4_) {
        this.field_178215_a = p_i547_1_;
        this.field_178213_b = p_i547_2_;
        this.field_178214_c = p_i547_3_;
        this.field_187509_d = p_i547_4_;
        this.fixVertexData();
    }

    public TextureAtlasSprite func_187508_a() {
        if (this.field_187509_d == null) {
            this.field_187509_d = BakedQuad.getSpriteByUv((int[])this.func_178209_a());
        }
        return this.field_187509_d;
    }

    public int[] func_178209_a() {
        this.fixVertexData();
        return this.field_178215_a;
    }

    public boolean func_178212_b() {
        return this.field_178213_b != -1;
    }

    public int func_178211_c() {
        return this.field_178213_b;
    }

    public Direction func_178210_d() {
        if (this.field_178214_c == null) {
            this.field_178214_c = FaceBakery.func_178410_a((int[])this.func_178209_a());
        }
        return this.field_178214_c;
    }

    public int[] getVertexDataSingle() {
        if (this.vertexDataSingle == null) {
            this.vertexDataSingle = BakedQuad.makeVertexDataSingle((int[])this.func_178209_a(), (TextureAtlasSprite)this.func_187508_a());
        }
        return this.vertexDataSingle;
    }

    private static int[] makeVertexDataSingle(int[] vd, TextureAtlasSprite sprite) {
        int[] vdSingle = (int[])vd.clone();
        int ku = sprite.sheetWidth / sprite.func_94211_a();
        int kv = sprite.sheetHeight / sprite.func_94216_b();
        int step = vdSingle.length / 4;
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float tu = Float.intBitsToFloat(vdSingle[pos + 4]);
            float tv = Float.intBitsToFloat(vdSingle[pos + 4 + 1]);
            float u = sprite.toSingleU(tu);
            float v = sprite.toSingleV(tv);
            vdSingle[pos + 4] = Float.floatToRawIntBits(u);
            vdSingle[pos + 4 + 1] = Float.floatToRawIntBits(v);
        }
        return vdSingle;
    }

    @Override
    public void pipe(IVertexConsumer consumer) {
        Reflector.callVoid(Reflector.LightUtil_putBakedQuad, consumer, this);
    }

    public VertexFormat getFormat() {
        return this.format;
    }

    public boolean shouldApplyDiffuseLighting() {
        return this.applyDiffuseLighting;
    }

    private static TextureAtlasSprite getSpriteByUv(int[] vertexData) {
        float uMin = 1.0f;
        float vMin = 1.0f;
        float uMax = 0.0f;
        float vMax = 0.0f;
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float tu = Float.intBitsToFloat(vertexData[pos + 4]);
            float tv = Float.intBitsToFloat(vertexData[pos + 4 + 1]);
            uMin = Math.min(uMin, tu);
            vMin = Math.min(vMin, tv);
            uMax = Math.max(uMax, tu);
            vMax = Math.max(vMax, tv);
        }
        float uMid = (uMin + uMax) / 2.0f;
        float vMid = (vMin + vMax) / 2.0f;
        TextureAtlasSprite spriteUv = Minecraft.func_71410_x().func_147117_R().getIconByUV((double)uMid, (double)vMid);
        return spriteUv;
    }

    protected void fixVertexData() {
        if (Config.isShaders()) {
            if (this.field_178215_a.length == 28) {
                this.field_178215_a = BakedQuad.expandVertexData((int[])this.field_178215_a);
            }
        } else if (this.field_178215_a.length == 56) {
            this.field_178215_a = BakedQuad.compactVertexData((int[])this.field_178215_a);
        }
    }

    private static int[] expandVertexData(int[] vd) {
        int step = vd.length / 4;
        int stepNew = step * 2;
        int[] vdNew = new int[stepNew * 4];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(vd, i * step, vdNew, i * stepNew, step);
        }
        return vdNew;
    }

    private static int[] compactVertexData(int[] vd) {
        int step = vd.length / 4;
        int stepNew = step / 2;
        int[] vdNew = new int[stepNew * 4];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(vd, i * step, vdNew, i * stepNew, stepNew);
        }
        return vdNew;
    }

    public QuadBounds getQuadBounds() {
        if (this.quadBounds == null) {
            this.quadBounds = new QuadBounds(this.func_178209_a());
        }
        return this.quadBounds;
    }

    public float getMidX() {
        QuadBounds qb = this.getQuadBounds();
        return (qb.getMaxX() + qb.getMinX()) / 2.0f;
    }

    public double getMidY() {
        QuadBounds qb = this.getQuadBounds();
        return (qb.getMaxY() + qb.getMinY()) / 2.0f;
    }

    public double getMidZ() {
        QuadBounds qb = this.getQuadBounds();
        return (qb.getMaxZ() + qb.getMinZ()) / 2.0f;
    }

    public boolean isFaceQuad() {
        QuadBounds qb = this.getQuadBounds();
        return qb.isFaceQuad(this.field_178214_c);
    }

    public boolean isFullQuad() {
        QuadBounds qb = this.getQuadBounds();
        return qb.isFullQuad(this.field_178214_c);
    }

    public boolean isFullFaceQuad() {
        return this.isFullQuad() && this.isFaceQuad();
    }

    public BakedQuad getQuadEmissive() {
        if (this.quadEmissiveChecked) {
            return this.quadEmissive;
        }
        if (this.quadEmissive == null && this.field_187509_d != null && this.field_187509_d.spriteEmissive != null) {
            this.quadEmissive = new BakedQuadRetextured(this, this.field_187509_d.spriteEmissive);
        }
        this.quadEmissiveChecked = true;
        return this.quadEmissive;
    }

    public String toString() {
        return "vertex: " + this.field_178215_a.length / 7 + ", tint: " + this.field_178213_b + ", facing: " + this.field_178214_c + ", sprite: " + this.field_187509_d;
    }
}

