/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.AbstractChunkRenderContainer;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.optifine.Config;
import net.optifine.render.VboRegion;
import net.optifine.shaders.ShadersRender;

public class VboRenderList
extends AbstractChunkRenderContainer {
    private double viewEntityX;
    private double viewEntityY;
    private double viewEntityZ;

    public void func_178001_a(BlockRenderLayer layer) {
        if (this.field_178007_b) {
            if (Config.isRenderRegions()) {
                int regionX = Integer.MIN_VALUE;
                int regionZ = Integer.MIN_VALUE;
                VboRegion lastVboRegion = null;
                for (ChunkRender renderchunk : this.field_178009_a) {
                    VertexBuffer vertexbuffer = renderchunk.func_178565_b(layer.ordinal());
                    VboRegion vboRegion = vertexbuffer.getVboRegion();
                    if (vboRegion != lastVboRegion || regionX != renderchunk.regionX || regionZ != renderchunk.regionZ) {
                        if (lastVboRegion != null) {
                            this.drawRegion(regionX, regionZ, lastVboRegion);
                        }
                        regionX = renderchunk.regionX;
                        regionZ = renderchunk.regionZ;
                        lastVboRegion = vboRegion;
                    }
                    vertexbuffer.func_177358_a(7);
                }
                if (lastVboRegion != null) {
                    this.drawRegion(regionX, regionZ, lastVboRegion);
                }
            } else {
                for (ChunkRender chunkrender : this.field_178009_a) {
                    VertexBuffer vertexbuffer = chunkrender.func_178565_b(layer.ordinal());
                    GlStateManager.pushMatrix();
                    this.func_178003_a(chunkrender);
                    vertexbuffer.func_177359_a();
                    this.func_178010_a();
                    vertexbuffer.func_177358_a(7);
                    GlStateManager.popMatrix();
                }
            }
            VertexBuffer.func_177361_b();
            GlStateManager.clearCurrentColor();
            this.field_178009_a.clear();
        }
    }

    public void func_178010_a() {
        if (Config.isShaders()) {
            ShadersRender.setupArrayPointersVbo();
            return;
        }
        GlStateManager.vertexPointer((int)3, (int)5126, (int)28, (int)0);
        GlStateManager.colorPointer((int)4, (int)5121, (int)28, (int)12);
        GlStateManager.texCoordPointer((int)2, (int)5126, (int)28, (int)16);
        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.texCoordPointer((int)2, (int)5122, (int)28, (int)24);
        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
    }

    public void func_178004_a(double viewEntityXIn, double viewEntityYIn, double viewEntityZIn) {
        this.viewEntityX = viewEntityXIn;
        this.viewEntityY = viewEntityYIn;
        this.viewEntityZ = viewEntityZIn;
        super.func_178004_a(viewEntityXIn, viewEntityYIn, viewEntityZIn);
    }

    private void drawRegion(int regionX, int regionZ, VboRegion vboRegion) {
        GlStateManager.pushMatrix();
        this.preRenderRegion(regionX, 0, regionZ);
        vboRegion.finishDraw(this);
        GlStateManager.popMatrix();
    }

    public void preRenderRegion(int x, int y, int z) {
        GlStateManager.translatef((float)((float)((double)x - this.viewEntityX)), (float)((float)((double)y - this.viewEntityY)), (float)((float)((double)z - this.viewEntityZ)));
    }
}

