/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.nio.FloatBuffer;
import java.util.Arrays;
import net.minecraft.client.renderer.Quaternion;

public final class Matrix4f {
    private final float[] field_195888_a = new float[16];

    public Matrix4f() {
    }

    public Matrix4f(Quaternion quaternionIn) {
        this();
        float f = quaternionIn.func_195889_a();
        float f1 = quaternionIn.func_195891_b();
        float f2 = quaternionIn.func_195893_c();
        float f3 = quaternionIn.func_195894_d();
        float f4 = 2.0f * f * f;
        float f5 = 2.0f * f1 * f1;
        float f6 = 2.0f * f2 * f2;
        this.field_195888_a[0] = 1.0f - f5 - f6;
        this.field_195888_a[5] = 1.0f - f6 - f4;
        this.field_195888_a[10] = 1.0f - f4 - f5;
        this.field_195888_a[15] = 1.0f;
        float f7 = f * f1;
        float f8 = f1 * f2;
        float f9 = f2 * f;
        float f10 = f * f3;
        float f11 = f1 * f3;
        float f12 = f2 * f3;
        this.field_195888_a[1] = 2.0f * (f7 + f12);
        this.field_195888_a[4] = 2.0f * (f7 - f12);
        this.field_195888_a[2] = 2.0f * (f9 - f11);
        this.field_195888_a[8] = 2.0f * (f9 + f11);
        this.field_195888_a[6] = 2.0f * (f8 + f10);
        this.field_195888_a[9] = 2.0f * (f8 - f10);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            Matrix4f matrix4f = (Matrix4f)p_equals_1_;
            return Arrays.equals(this.field_195888_a, matrix4f.field_195888_a);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.field_195888_a);
    }

    public void func_195874_a(FloatBuffer floatBufferIn) {
        this.func_195883_a(floatBufferIn, false);
    }

    public void func_195883_a(FloatBuffer floatBufferIn, boolean transposeIn) {
        if (transposeIn) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.field_195888_a[i * 4 + j] = floatBufferIn.get(j * 4 + i);
                }
            }
        } else {
            floatBufferIn.get(this.field_195888_a);
        }
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("Matrix4f:\n");
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                stringbuilder.append(this.field_195888_a[i + j * 4]);
                if (j == 3) continue;
                stringbuilder.append(" ");
            }
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    public void func_195879_b(FloatBuffer floatBufferIn) {
        this.func_195873_b(floatBufferIn, false);
    }

    public void func_195873_b(FloatBuffer floatBufferIn, boolean transposeIn) {
        if (transposeIn) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    floatBufferIn.put(j * 4 + i, this.field_195888_a[i * 4 + j]);
                }
            }
        } else {
            floatBufferIn.put(this.field_195888_a);
        }
    }

    public void func_195878_a(int col, int row, float val) {
        this.field_195888_a[col + 4 * row] = val;
    }

    public static Matrix4f func_195876_a(double fov, float aspectRatio, float nearPlane, float farPlane) {
        float f = (float)(1.0 / Math.tan(fov * 0.01745329238474369 / 2.0));
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_195878_a(0, 0, f / aspectRatio);
        matrix4f.func_195878_a(1, 1, f);
        matrix4f.func_195878_a(2, 2, (farPlane + nearPlane) / (nearPlane - farPlane));
        matrix4f.func_195878_a(3, 2, -1.0f);
        matrix4f.func_195878_a(2, 3, 2.0f * farPlane * nearPlane / (nearPlane - farPlane));
        return matrix4f;
    }

    public static Matrix4f func_195877_a(float width, float height, float nearPlane, float farPlane) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.func_195878_a(0, 0, 2.0f / width);
        matrix4f.func_195878_a(1, 1, 2.0f / height);
        float f = farPlane - nearPlane;
        matrix4f.func_195878_a(2, 2, -2.0f / f);
        matrix4f.func_195878_a(3, 3, 1.0f);
        matrix4f.func_195878_a(0, 3, -1.0f);
        matrix4f.func_195878_a(1, 3, -1.0f);
        matrix4f.func_195878_a(2, 3, -(farPlane + nearPlane) / f);
        return matrix4f;
    }
}

