/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;

public class FogRenderer {
    private final FloatBuffer field_205091_a = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer field_205092_b = GLAllocation.func_74529_h((int)16);
    public float field_205093_c;
    public float field_205094_d;
    public float field_205095_e;
    private float field_205098_h = -1.0f;
    private float field_205099_i = -1.0f;
    private float field_205100_j = -1.0f;
    private int field_205101_k = -1;
    private int field_205102_l = -1;
    private long field_205103_m = -1L;
    private final GameRenderer field_205104_n;
    private final Minecraft field_205105_o;

    public FogRenderer(GameRenderer p_i359_1_) {
        this.field_205104_n = p_i359_1_;
        this.field_205105_o = p_i359_1_.func_205000_l();
        this.field_205091_a.put(0.0f).put(0.0f).put(0.0f).put(1.0f).flip();
    }

    public void func_217619_a(ActiveRenderInfo activeRenderInfo, float partialTicks) {
        Vec3d colUnderlava;
        ClientWorld world = this.field_205105_o.field_71441_e;
        IFluidState ifluidstate = activeRenderInfo.func_216771_k();
        if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
            this.func_217621_a(activeRenderInfo, (IWorldReader)world);
        } else if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
            this.field_205093_c = 0.6f;
            this.field_205094_d = 0.1f;
            this.field_205095_e = 0.0f;
            this.field_205103_m = -1L;
        } else {
            this.func_217620_a(activeRenderInfo, (World)world, partialTicks);
            this.field_205103_m = -1L;
        }
        double d0 = activeRenderInfo.func_216785_c().field_72448_b * world.field_73011_w.func_76565_k();
        if (activeRenderInfo.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfo.func_216773_g()).func_70644_a(Effects.field_76440_q)) {
            int i = ((LivingEntity)activeRenderInfo.func_216773_g()).func_70660_b(Effects.field_76440_q).func_76459_b();
            d0 = i < 20 ? (d0 *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
        }
        if (d0 < 1.0) {
            if (d0 < 0.0) {
                d0 = 0.0;
            }
            d0 *= d0;
            this.field_205093_c = (float)((double)this.field_205093_c * d0);
            this.field_205094_d = (float)((double)this.field_205094_d * d0);
            this.field_205095_e = (float)((double)this.field_205095_e * d0);
        }
        if (this.field_205104_n.func_205002_d(partialTicks) > 0.0f) {
            float f = this.field_205104_n.func_205002_d(partialTicks);
            this.field_205093_c = this.field_205093_c * (1.0f - f) + this.field_205093_c * 0.7f * f;
            this.field_205094_d = this.field_205094_d * (1.0f - f) + this.field_205094_d * 0.6f * f;
            this.field_205095_e = this.field_205095_e * (1.0f - f) + this.field_205095_e * 0.6f * f;
        }
        if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
            float f3;
            float f1 = 0.0f;
            if (activeRenderInfo.func_216773_g() instanceof ClientPlayerEntity) {
                ClientPlayerEntity clientplayerentity = (ClientPlayerEntity)activeRenderInfo.func_216773_g();
                f1 = clientplayerentity.func_203719_J();
            }
            if ((f3 = 1.0f / this.field_205093_c) > 1.0f / this.field_205094_d) {
                f3 = 1.0f / this.field_205094_d;
            }
            if (f3 > 1.0f / this.field_205095_e) {
                f3 = 1.0f / this.field_205095_e;
            }
            if (Float.isInfinite(f3)) {
                f3 = Math.nextAfter(f3, 0.0);
            }
            this.field_205093_c = this.field_205093_c * (1.0f - f1) + this.field_205093_c * f3 * f1;
            this.field_205094_d = this.field_205094_d * (1.0f - f1) + this.field_205094_d * f3 * f1;
            this.field_205095_e = this.field_205095_e * (1.0f - f1) + this.field_205095_e * f3 * f1;
        } else if (activeRenderInfo.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfo.func_216773_g()).func_70644_a(Effects.field_76439_r)) {
            float f2 = this.field_205104_n.func_180438_a((LivingEntity)activeRenderInfo.func_216773_g(), partialTicks);
            float f4 = 1.0f / this.field_205093_c;
            if (f4 > 1.0f / this.field_205094_d) {
                f4 = 1.0f / this.field_205094_d;
            }
            if (f4 > 1.0f / this.field_205095_e) {
                f4 = 1.0f / this.field_205095_e;
            }
            if (Float.isInfinite(f4)) {
                f4 = Math.nextAfter(f4, 0.0);
            }
            this.field_205093_c = this.field_205093_c * (1.0f - f2) + this.field_205093_c * f4 * f2;
            this.field_205094_d = this.field_205094_d * (1.0f - f2) + this.field_205094_d * f4 * f2;
            this.field_205095_e = this.field_205095_e * (1.0f - f2) + this.field_205095_e * f4 * f2;
        }
        if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
            Vec3d colUnderwater = CustomColors.getUnderwaterColor((IWorldReader)this.field_205105_o.field_71441_e, (double)this.field_205105_o.func_175606_aa().field_70165_t, (double)(this.field_205105_o.func_175606_aa().field_70163_u + 1.0), (double)this.field_205105_o.func_175606_aa().field_70161_v);
            if (colUnderwater != null) {
                this.field_205093_c = (float)colUnderwater.field_72450_a;
                this.field_205094_d = (float)colUnderwater.field_72448_b;
                this.field_205095_e = (float)colUnderwater.field_72449_c;
            }
        } else if (ifluidstate.func_206884_a(FluidTags.field_206960_b) && (colUnderlava = CustomColors.getUnderlavaColor((IWorldReader)this.field_205105_o.field_71441_e, (double)this.field_205105_o.func_175606_aa().field_70165_t, (double)(this.field_205105_o.func_175606_aa().field_70163_u + 1.0), (double)this.field_205105_o.func_175606_aa().field_70161_v)) != null) {
            this.field_205093_c = (float)colUnderlava.field_72450_a;
            this.field_205094_d = (float)colUnderlava.field_72448_b;
            this.field_205095_e = (float)colUnderlava.field_72449_c;
        }
        if (Reflector.EntityViewRenderEvent_FogColors_Constructor.exists()) {
            Entity entity = activeRenderInfo.func_216773_g();
            BlockState iblockstate = activeRenderInfo.getBlockState();
            Object event = Reflector.newInstance(Reflector.EntityViewRenderEvent_FogColors_Constructor, this, this.field_205104_n, entity, iblockstate, ifluidstate, Float.valueOf(partialTicks), Float.valueOf(this.field_205093_c), Float.valueOf(this.field_205094_d), Float.valueOf(this.field_205095_e));
            Reflector.postForgeBusEvent(event);
            this.field_205093_c = Reflector.callFloat(event, Reflector.EntityViewRenderEvent_FogColors_getRed, new Object[0]);
            this.field_205094_d = Reflector.callFloat(event, Reflector.EntityViewRenderEvent_FogColors_getGreen, new Object[0]);
            this.field_205095_e = Reflector.callFloat(event, Reflector.EntityViewRenderEvent_FogColors_getBlue, new Object[0]);
        }
        Shaders.setClearColor(this.field_205093_c, this.field_205094_d, this.field_205095_e, 0.0f);
    }

    private void func_217620_a(ActiveRenderInfo activeRenderInfo, World worldIn, float partialTicks) {
        float f7;
        float f = 0.25f + 0.75f * (float)this.field_205105_o.field_71474_y.field_151451_c / 32.0f;
        f = 1.0f - (float)Math.pow(f, 0.25);
        Vec3d vec3d = worldIn.func_217382_a(activeRenderInfo.func_216780_d(), partialTicks);
        vec3d = CustomColors.getWorldSkyColor((Vec3d)vec3d, (World)worldIn, (Entity)this.field_205105_o.func_175606_aa(), (float)partialTicks);
        float f1 = (float)vec3d.field_72450_a;
        float f2 = (float)vec3d.field_72448_b;
        float f3 = (float)vec3d.field_72449_c;
        Vec3d vec3d1 = worldIn.func_72948_g(partialTicks);
        vec3d1 = CustomColors.getWorldFogColor((Vec3d)vec3d1, (World)worldIn, (Entity)this.field_205105_o.func_175606_aa(), (float)partialTicks);
        this.field_205093_c = (float)vec3d1.field_72450_a;
        this.field_205094_d = (float)vec3d1.field_72448_b;
        this.field_205095_e = (float)vec3d1.field_72449_c;
        if (this.field_205105_o.field_71474_y.field_151451_c >= 4) {
            float[] afloat;
            double d0 = MathHelper.func_76126_a((float)worldIn.func_72929_e(partialTicks)) > 0.0f ? -1.0 : 1.0;
            Vec3d vec3d2 = new Vec3d(d0, 0.0, 0.0);
            float f5 = (float)activeRenderInfo.func_216787_l().func_72430_b(vec3d2);
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 0.0f && (afloat = worldIn.field_73011_w.func_76560_a(worldIn.func_72826_c(partialTicks), partialTicks)) != null) {
                this.field_205093_c = this.field_205093_c * (1.0f - (f5 *= afloat[3])) + afloat[0] * f5;
                this.field_205094_d = this.field_205094_d * (1.0f - f5) + afloat[1] * f5;
                this.field_205095_e = this.field_205095_e * (1.0f - f5) + afloat[2] * f5;
            }
        }
        this.field_205093_c += (f1 - this.field_205093_c) * f;
        this.field_205094_d += (f2 - this.field_205094_d) * f;
        this.field_205095_e += (f3 - this.field_205095_e) * f;
        float f6 = worldIn.func_72867_j(partialTicks);
        if (f6 > 0.0f) {
            float f4 = 1.0f - f6 * 0.5f;
            float f8 = 1.0f - f6 * 0.4f;
            this.field_205093_c *= f4;
            this.field_205094_d *= f4;
            this.field_205095_e *= f8;
        }
        if ((f7 = worldIn.func_72819_i(partialTicks)) > 0.0f) {
            float f9 = 1.0f - f7 * 0.5f;
            this.field_205093_c *= f9;
            this.field_205094_d *= f9;
            this.field_205095_e *= f9;
        }
    }

    private void func_217621_a(ActiveRenderInfo activeRenderInfo, IWorldReader worldIn) {
        long i = Util.func_211177_b();
        int j = worldIn.func_180494_b(new BlockPos(activeRenderInfo.func_216785_c())).func_204274_p();
        if (this.field_205103_m < 0L) {
            this.field_205101_k = j;
            this.field_205102_l = j;
            this.field_205103_m = i;
        }
        int k = this.field_205101_k >> 16 & 0xFF;
        int l2 = this.field_205101_k >> 8 & 0xFF;
        int i1 = this.field_205101_k & 0xFF;
        int j1 = this.field_205102_l >> 16 & 0xFF;
        int k1 = this.field_205102_l >> 8 & 0xFF;
        int l1 = this.field_205102_l & 0xFF;
        float f = MathHelper.func_76131_a((float)((float)(i - this.field_205103_m) / 5000.0f), (float)0.0f, (float)1.0f);
        float f1 = MathHelper.func_219799_g((float)f, (float)j1, (float)k);
        float f2 = MathHelper.func_219799_g((float)f, (float)k1, (float)l2);
        float f3 = MathHelper.func_219799_g((float)f, (float)l1, (float)i1);
        this.field_205093_c = f1 / 255.0f;
        this.field_205094_d = f2 / 255.0f;
        this.field_205095_e = f3 / 255.0f;
        if (this.field_205101_k != j) {
            this.field_205101_k = j;
            this.field_205102_l = MathHelper.func_76141_d((float)f1) << 16 | MathHelper.func_76141_d((float)f2) << 8 | MathHelper.func_76141_d((float)f3);
            this.field_205103_m = i;
        }
    }

    public void func_217618_a(ActiveRenderInfo activeRenderInfo, int partialTicks) {
        this.field_205104_n.fogStandard = false;
        this.func_205090_a(false);
        GlStateManager.normal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IFluidState ifluidstate = activeRenderInfo.func_216771_k();
        Entity entity = activeRenderInfo.func_216773_g();
        BlockState iblockstate = activeRenderInfo.getBlockState();
        float forgeFogDensity = -1.0f;
        if (Reflector.ForgeHooksClient_getFogDensity.exists()) {
            forgeFogDensity = Reflector.callFloat(Reflector.ForgeHooksClient_getFogDensity, this, this.field_205104_n, entity, iblockstate, ifluidstate, 0, Float.valueOf(0.1f));
        }
        if (forgeFogDensity >= 0.0f) {
            GlStateManager.fogDensity((float)forgeFogDensity);
        } else if (activeRenderInfo.func_216773_g() instanceof LivingEntity && ((LivingEntity)activeRenderInfo.func_216773_g()).func_70644_a(Effects.field_76440_q)) {
            float f2 = 5.0f;
            int i = ((LivingEntity)activeRenderInfo.func_216773_g()).func_70660_b(Effects.field_76440_q).func_76459_b();
            if (i < 20) {
                f2 = MathHelper.func_219799_g((float)(1.0f - (float)i / 20.0f), (float)5.0f, (float)this.field_205104_n.func_205001_m());
            }
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            if (partialTicks == -1) {
                GlStateManager.fogStart((float)0.0f);
                GlStateManager.fogEnd((float)(f2 * 0.8f));
            } else {
                GlStateManager.fogStart((float)(f2 * 0.25f));
                GlStateManager.fogEnd((float)f2);
            }
            GLX.setupNvFogDistance();
        } else if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            if (activeRenderInfo.func_216773_g() instanceof LivingEntity) {
                if (activeRenderInfo.func_216773_g() instanceof ClientPlayerEntity) {
                    ClientPlayerEntity clientplayerentity = (ClientPlayerEntity)activeRenderInfo.func_216773_g();
                    float f = 0.05f - clientplayerentity.func_203719_J() * clientplayerentity.func_203719_J() * 0.03f;
                    Biome biome = clientplayerentity.field_70170_p.func_180494_b(new BlockPos((Entity)clientplayerentity));
                    if (biome == Biomes.field_76780_h || biome == Biomes.field_150599_m) {
                        f += 0.005f;
                    }
                    GlStateManager.fogDensity((float)f);
                } else {
                    GlStateManager.fogDensity((float)0.05f);
                }
            } else {
                GlStateManager.fogDensity((float)0.1f);
            }
        } else if (ifluidstate.func_206884_a(FluidTags.field_206960_b)) {
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.fogDensity((float)2.0f);
        } else {
            float f1 = this.field_205104_n.func_205001_m();
            this.field_205104_n.fogStandard = true;
            GlStateManager.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            if (partialTicks == -1) {
                GlStateManager.fogStart((float)0.0f);
                GlStateManager.fogEnd((float)f1);
            } else {
                GlStateManager.fogStart((float)(f1 * Config.getFogStart()));
                GlStateManager.fogEnd((float)f1);
            }
            GLX.setupNvFogDistance();
            if (this.field_205105_o.field_71441_e.field_73011_w.func_76568_b(MathHelper.func_76128_c((double)activeRenderInfo.func_216785_c().field_72450_a), MathHelper.func_76128_c((double)activeRenderInfo.func_216785_c().field_72449_c)) || this.field_205105_o.field_71456_v.func_184046_j().func_184056_f()) {
                GlStateManager.fogStart((float)(f1 * 0.05f));
                GlStateManager.fogEnd((float)f1);
            }
            if (Reflector.ForgeHooksClient_onFogRender.exists()) {
                Reflector.callVoid(Reflector.ForgeHooksClient_onFogRender, this, this.field_205104_n, activeRenderInfo.func_216773_g(), iblockstate, ifluidstate, 0, partialTicks, Float.valueOf(f1));
            }
        }
        GlStateManager.enableColorMaterial();
        GlStateManager.enableFog();
        GlStateManager.colorMaterial((int)1028, (int)4608);
    }

    public void func_205090_a(boolean blackIn) {
        if (blackIn) {
            GlStateManager.fog((int)2918, (FloatBuffer)this.field_205091_a);
        } else {
            GlStateManager.fog((int)2918, (FloatBuffer)this.func_205087_b());
        }
    }

    private FloatBuffer func_205087_b() {
        if (this.field_205098_h != this.field_205093_c || this.field_205099_i != this.field_205094_d || this.field_205100_j != this.field_205095_e) {
            this.field_205092_b.clear();
            this.field_205092_b.put(this.field_205093_c).put(this.field_205094_d).put(this.field_205095_e).put(1.0f);
            this.field_205092_b.flip();
            this.field_205098_h = this.field_205093_c;
            this.field_205099_i = this.field_205094_d;
            this.field_205100_j = this.field_205095_e;
            if (Config.isShaders()) {
                Shaders.setFogColor(this.field_205093_c, this.field_205094_d, this.field_205095_e);
            }
        }
        return this.field_205092_b;
    }
}

