/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.optifine.Config;
import net.optifine.DynamicLights;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;

public class FirstPersonRenderer {
    private static final ResourceLocation field_110931_c = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation field_110929_d = new ResourceLocation("textures/misc/underwater.png");
    private final Minecraft field_78455_a;
    private ItemStack field_187467_d = ItemStack.field_190927_a;
    private ItemStack field_187468_e = ItemStack.field_190927_a;
    private float field_187469_f;
    private float field_187470_g;
    private float field_187471_h;
    private float field_187472_i;
    private final EntityRendererManager field_178111_g;
    private final ItemRenderer field_178112_h;

    public FirstPersonRenderer(Minecraft mcIn) {
        this.field_78455_a = mcIn;
        this.field_178111_g = mcIn.func_175598_ae();
        this.field_178112_h = mcIn.func_175599_af();
    }

    public void func_178099_a(LivingEntity entityIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform) {
        this.func_187462_a(entityIn, heldStack, transform, false);
    }

    public void func_187462_a(LivingEntity entitylivingbaseIn, ItemStack heldStack, ItemCameraTransforms.TransformType transform, boolean leftHanded) {
        if (!heldStack.func_190926_b()) {
            boolean flag;
            Item item = heldStack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            GlStateManager.pushMatrix();
            boolean bl = flag = this.field_178112_h.func_175050_a(heldStack) && block.func_180664_k() == BlockRenderLayer.TRANSLUCENT;
            if (!(!flag || Config.isShaders() && Shaders.renderItemKeepDepthMask)) {
                GlStateManager.depthMask((boolean)false);
            }
            this.field_178112_h.func_184392_a(heldStack, entitylivingbaseIn, transform, leftHanded);
            if (flag) {
                GlStateManager.depthMask((boolean)true);
            }
            GlStateManager.popMatrix();
        }
    }

    private void func_178101_a(float angle, float angleY) {
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    private void func_187464_b() {
        ClientPlayerEntity abstractclientplayerentity = this.field_78455_a.field_71439_g;
        int i = this.field_78455_a.field_71441_e.func_217338_b(new BlockPos(abstractclientplayerentity.field_70165_t, abstractclientplayerentity.field_70163_u + (double)abstractclientplayerentity.func_70047_e(), abstractclientplayerentity.field_70161_v), 0);
        if (Config.isDynamicLights()) {
            i = DynamicLights.getCombinedLight((Entity)this.field_78455_a.func_175606_aa(), (int)i);
        }
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)f, (float)f1);
    }

    private void func_187458_c(float partialTicks) {
        ClientPlayerEntity clientplayerentity = this.field_78455_a.field_71439_g;
        float f = MathHelper.func_219799_g((float)partialTicks, (float)clientplayerentity.field_71164_i, (float)clientplayerentity.field_71155_g);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)clientplayerentity.field_71163_h, (float)clientplayerentity.field_71154_f);
        GlStateManager.rotatef((float)((clientplayerentity.func_195050_f(partialTicks) - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((clientplayerentity.func_195046_g(partialTicks) - f1) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private float func_178100_c(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f = -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
        return f;
    }

    private void func_187466_c() {
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            GlStateManager.disableCull();
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.func_187455_a(HandSide.RIGHT);
            this.func_187455_a(HandSide.LEFT);
            GlStateManager.popMatrix();
            GlStateManager.enableCull();
        }
    }

    private void func_187455_a(HandSide side) {
        this.field_78455_a.func_110434_K().func_110577_a(this.field_78455_a.field_71439_g.func_110306_p());
        EntityRenderer entityrenderer = this.field_178111_g.func_78713_a((Entity)this.field_78455_a.field_71439_g);
        PlayerRenderer playerrenderer = (PlayerRenderer)entityrenderer;
        GlStateManager.pushMatrix();
        float f = side == HandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.rotatef((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * -41.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)(f * 0.3f), (float)-1.1f, (float)0.45f);
        if (side == HandSide.RIGHT) {
            playerrenderer.func_177138_b((AbstractClientPlayerEntity)this.field_78455_a.field_71439_g);
        } else {
            playerrenderer.func_177139_c((AbstractClientPlayerEntity)this.field_78455_a.field_71439_g);
        }
        GlStateManager.popMatrix();
    }

    private void func_187465_a(float equippedProgress, HandSide hand, float swingProgress, ItemStack stack) {
        float f = hand == HandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.translatef((float)(f * 0.125f), (float)-0.125f, (float)0.0f);
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_187456_a(equippedProgress, swingProgress, hand);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(f * 0.51f), (float)(-0.08f + equippedProgress * -1.2f), (float)-0.75f);
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.translatef((float)(f * f3), (float)(f4 - 0.3f * f2), (float)f5);
        GlStateManager.rotatef((float)(f2 * -45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * f2 * -30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_187461_a(stack);
        GlStateManager.popMatrix();
    }

    private void func_187463_a(float pitch, float equippedProgress, float swingProgress) {
        float f = MathHelper.func_76129_c((float)swingProgress);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.translatef((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
        float f3 = this.func_178100_c(pitch);
        GlStateManager.translatef((float)0.0f, (float)(0.04f + equippedProgress * -1.2f + f3 * -0.5f), (float)-0.72f);
        GlStateManager.rotatef((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.func_187466_c();
        float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.rotatef((float)(f4 * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.func_187461_a(this.field_187467_d);
    }

    private void func_187461_a(ItemStack stack) {
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.scalef((float)0.38f, (float)0.38f, (float)0.38f);
        GlStateManager.disableLighting();
        this.field_78455_a.func_110434_K().func_110577_a(field_110931_c);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        GlStateManager.scalef((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        MapData mapdata = FilledMapItem.func_195950_a((ItemStack)stack, (World)this.field_78455_a.field_71441_e);
        if (mapdata != null) {
            this.field_78455_a.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
        }
        GlStateManager.enableLighting();
    }

    private void func_187456_a(float equippedProgress, float swingProgress, HandSide side) {
        boolean flag = side != HandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.translatef((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + equippedProgress * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.rotatef((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.rotatef((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        ClientPlayerEntity abstractclientplayerentity = this.field_78455_a.field_71439_g;
        this.field_78455_a.func_110434_K().func_110577_a(abstractclientplayerentity.func_110306_p());
        GlStateManager.translatef((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.rotatef((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        PlayerRenderer playerrenderer = (PlayerRenderer)this.field_178111_g.func_78713_a((Entity)abstractclientplayerentity);
        GlStateManager.disableCull();
        if (flag) {
            playerrenderer.func_177138_b((AbstractClientPlayerEntity)abstractclientplayerentity);
        } else {
            playerrenderer.func_177139_c((AbstractClientPlayerEntity)abstractclientplayerentity);
        }
        GlStateManager.enableCull();
    }

    private void func_187454_a(float partialTicks, HandSide hand, ItemStack stack) {
        float f = (float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f;
        float f1 = f / (float)stack.func_77988_m();
        if (f1 < 0.8f) {
            float f2 = MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            GlStateManager.translatef((float)0.0f, (float)f2, (float)0.0f);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = hand == HandSide.RIGHT ? 1 : -1;
        GlStateManager.translatef((float)(f3 * 0.6f * (float)i), (float)(f3 * -0.5f), (float)(f3 * 0.0f));
        GlStateManager.rotatef((float)((float)i * f3 * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f3 * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)i * f3 * 30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void func_187453_a(HandSide hand, float swingProgress) {
        int i = hand == HandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        GlStateManager.rotatef((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        GlStateManager.rotatef((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void func_187459_b(HandSide hand, float equippedProg) {
        int i = hand == HandSide.RIGHT ? 1 : -1;
        GlStateManager.translatef((float)((float)i * 0.56f), (float)(-0.52f + equippedProg * -0.6f), (float)-0.72f);
    }

    public void func_78440_a(float partialTicks) {
        ClientPlayerEntity abstractclientplayerentity = this.field_78455_a.field_71439_g;
        float f = abstractclientplayerentity.func_70678_g(partialTicks);
        Hand hand = (Hand)MoreObjects.firstNonNull((Object)abstractclientplayerentity.field_184622_au, (Object)Hand.MAIN_HAND);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)abstractclientplayerentity.field_70127_C, (float)abstractclientplayerentity.field_70125_A);
        float f2 = MathHelper.func_219799_g((float)partialTicks, (float)abstractclientplayerentity.field_70126_B, (float)abstractclientplayerentity.field_70177_z);
        boolean flag = true;
        boolean flag1 = true;
        if (abstractclientplayerentity.func_184587_cr()) {
            ItemStack itemstack1;
            Hand hand1;
            ItemStack itemstack = abstractclientplayerentity.func_184607_cu();
            if (itemstack.func_77973_b() == Items.field_151031_f || itemstack.func_77973_b() == Items.field_222114_py) {
                flag = abstractclientplayerentity.func_184600_cs() == Hand.MAIN_HAND;
                boolean bl = flag1 = !flag;
            }
            if ((hand1 = abstractclientplayerentity.func_184600_cs()) == Hand.MAIN_HAND && (itemstack1 = abstractclientplayerentity.func_184592_cb()).func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack1)) {
                flag1 = false;
            }
        } else {
            ItemStack itemstack2 = abstractclientplayerentity.func_184614_ca();
            ItemStack itemstack3 = abstractclientplayerentity.func_184592_cb();
            if (itemstack2.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack2)) {
                boolean bl = flag1 = !flag;
            }
            if (itemstack3.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack3)) {
                flag = !itemstack2.func_190926_b();
                flag1 = !flag;
            }
        }
        this.func_178101_a(f1, f2);
        this.func_187464_b();
        this.func_187458_c(partialTicks);
        GlStateManager.enableRescaleNormal();
        if (flag) {
            float f3 = hand == Hand.MAIN_HAND ? f : 0.0f;
            float f5 = 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)this.field_187470_g, (float)this.field_187469_f);
            if (!Reflector.ForgeHooksClient_renderSpecificFirstPersonHand.exists() || !Reflector.callBoolean(Reflector.ForgeHooksClient_renderSpecificFirstPersonHand, Hand.MAIN_HAND, Float.valueOf(partialTicks), Float.valueOf(f1), Float.valueOf(f3), Float.valueOf(f5), this.field_187467_d)) {
                this.func_187457_a((AbstractClientPlayerEntity)abstractclientplayerentity, partialTicks, f1, Hand.MAIN_HAND, f3, this.field_187467_d, f5);
            }
        }
        if (flag1) {
            float f4 = hand == Hand.OFF_HAND ? f : 0.0f;
            float f6 = 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)this.field_187472_i, (float)this.field_187471_h);
            if (!Reflector.ForgeHooksClient_renderSpecificFirstPersonHand.exists() || !Reflector.callBoolean(Reflector.ForgeHooksClient_renderSpecificFirstPersonHand, Hand.OFF_HAND, Float.valueOf(partialTicks), Float.valueOf(f1), Float.valueOf(f4), Float.valueOf(f6), this.field_187468_e)) {
                this.func_187457_a((AbstractClientPlayerEntity)abstractclientplayerentity, partialTicks, f1, Hand.OFF_HAND, f4, this.field_187468_e, f6);
            }
        }
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
    }

    public void func_187457_a(AbstractClientPlayerEntity player, float partialTicks, float pitch, Hand hand, float swingProgress, ItemStack stack, float equippedProgress) {
        if (Config.isShaders() && Shaders.isSkipRenderHand((Hand)hand)) {
            return;
        }
        boolean flag = hand == Hand.MAIN_HAND;
        HandSide handside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.pushMatrix();
        if (stack.func_190926_b()) {
            if (flag && !player.func_82150_aj()) {
                this.func_187456_a(equippedProgress, swingProgress, handside);
            }
        } else if (stack.func_77973_b() instanceof FilledMapItem) {
            if (flag && this.field_187468_e.func_190926_b()) {
                this.func_187463_a(pitch, equippedProgress, swingProgress);
            } else {
                this.func_187465_a(equippedProgress, handside, swingProgress, stack);
            }
        } else if (stack.func_77973_b() == Items.field_222114_py) {
            int i;
            boolean flag1 = CrossbowItem.func_220012_d((ItemStack)stack);
            boolean flag2 = handside == HandSide.RIGHT;
            int n = i = flag2 ? 1 : -1;
            if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == hand) {
                this.func_187459_b(handside, equippedProgress);
                GlStateManager.translatef((float)((float)i * -0.4785682f), (float)-0.094387f, (float)0.05731531f);
                GlStateManager.rotatef((float)-11.935f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.rotatef((float)((float)i * 65.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)((float)i * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                float f9 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                float f13 = f9 / (float)CrossbowItem.func_220026_e((ItemStack)stack);
                if (f13 > 1.0f) {
                    f13 = 1.0f;
                }
                if (f13 > 0.1f) {
                    float f16 = MathHelper.func_76126_a((float)((f9 - 0.1f) * 1.3f));
                    float f3 = f13 - 0.1f;
                    float f4 = f16 * f3;
                    GlStateManager.translatef((float)(f4 * 0.0f), (float)(f4 * 0.004f), (float)(f4 * 0.0f));
                }
                GlStateManager.translatef((float)(f13 * 0.0f), (float)(f13 * 0.0f), (float)(f13 * 0.04f));
                GlStateManager.scalef((float)1.0f, (float)1.0f, (float)(1.0f + f13 * 0.2f));
                GlStateManager.rotatef((float)((float)i * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
            } else {
                float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
                float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
                GlStateManager.translatef((float)((float)i * f), (float)f1, (float)f2);
                this.func_187459_b(handside, equippedProgress);
                this.func_187453_a(handside, swingProgress);
                if (flag1 && swingProgress < 0.001f) {
                    GlStateManager.translatef((float)((float)i * -0.641864f), (float)0.0f, (float)0.0f);
                    GlStateManager.rotatef((float)((float)i * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            this.func_187462_a((LivingEntity)player, stack, flag2 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag2);
        } else {
            boolean flag3;
            boolean bl = flag3 = handside == HandSide.RIGHT;
            if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == hand) {
                int k = flag3 ? 1 : -1;
                switch (1.$SwitchMap$net$minecraft$item$UseAction[stack.func_77975_n().ordinal()]) {
                    case 1: {
                        this.func_187459_b(handside, equippedProgress);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.func_187454_a(partialTicks, handside, stack);
                        this.func_187459_b(handside, equippedProgress);
                        break;
                    }
                    case 4: {
                        this.func_187459_b(handside, equippedProgress);
                        break;
                    }
                    case 5: {
                        this.func_187459_b(handside, equippedProgress);
                        GlStateManager.translatef((float)((float)k * -0.2785682f), (float)0.18344387f, (float)0.15731531f);
                        GlStateManager.rotatef((float)-13.935f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.rotatef((float)((float)k * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.rotatef((float)((float)k * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                        float f8 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f12 = f8 / 20.0f;
                        f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                        if (f12 > 1.0f) {
                            f12 = 1.0f;
                        }
                        if (f12 > 0.1f) {
                            float f15 = MathHelper.func_76126_a((float)((f8 - 0.1f) * 1.3f));
                            float f18 = f12 - 0.1f;
                            float f20 = f15 * f18;
                            GlStateManager.translatef((float)(f20 * 0.0f), (float)(f20 * 0.004f), (float)(f20 * 0.0f));
                        }
                        GlStateManager.translatef((float)(f12 * 0.0f), (float)(f12 * 0.0f), (float)(f12 * 0.04f));
                        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)(1.0f + f12 * 0.2f));
                        GlStateManager.rotatef((float)((float)k * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case 6: {
                        this.func_187459_b(handside, equippedProgress);
                        GlStateManager.translatef((float)((float)k * -0.5f), (float)0.7f, (float)0.1f);
                        GlStateManager.rotatef((float)-55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.rotatef((float)((float)k * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.rotatef((float)((float)k * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                        float f7 = (float)stack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - partialTicks + 1.0f);
                        float f11 = f7 / 10.0f;
                        if (f11 > 1.0f) {
                            f11 = 1.0f;
                        }
                        if (f11 > 0.1f) {
                            float f14 = MathHelper.func_76126_a((float)((f7 - 0.1f) * 1.3f));
                            float f17 = f11 - 0.1f;
                            float f19 = f14 * f17;
                            GlStateManager.translatef((float)(f19 * 0.0f), (float)(f19 * 0.004f), (float)(f19 * 0.0f));
                        }
                        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(f11 * 0.2f));
                        GlStateManager.scalef((float)1.0f, (float)1.0f, (float)(1.0f + f11 * 0.2f));
                        GlStateManager.rotatef((float)((float)k * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                    }
                }
            } else if (player.func_204805_cN()) {
                this.func_187459_b(handside, equippedProgress);
                int j = flag3 ? 1 : -1;
                GlStateManager.translatef((float)((float)j * -0.4f), (float)0.8f, (float)0.3f);
                GlStateManager.rotatef((float)((float)j * 65.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)((float)j * -85.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                float f5 = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                float f6 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
                float f10 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
                int l2 = flag3 ? 1 : -1;
                GlStateManager.translatef((float)((float)l2 * f5), (float)f6, (float)f10);
                this.func_187459_b(handside, equippedProgress);
                this.func_187453_a(handside, swingProgress);
            }
            this.func_187462_a((LivingEntity)player, stack, flag3 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag3);
        }
        GlStateManager.popMatrix();
    }

    public void func_78447_b(float partialTicks) {
        GlStateManager.disableAlphaTest();
        if (this.field_78455_a.field_71439_g.func_70094_T()) {
            BlockState blockstate = this.field_78455_a.field_71441_e.func_180495_p(new BlockPos((Entity)this.field_78455_a.field_71439_g));
            BlockPos overlayPos = new BlockPos((Entity)this.field_78455_a.field_71439_g);
            ClientPlayerEntity playerentity = this.field_78455_a.field_71439_g;
            for (int i = 0; i < 8; ++i) {
                double d0 = playerentity.field_70165_t + (double)(((float)((i >> 0) % 2) - 0.5f) * playerentity.func_213311_cf() * 0.8f);
                double d1 = playerentity.field_70163_u + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                double d2 = playerentity.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * playerentity.func_213311_cf() * 0.8f);
                BlockPos blockpos = new BlockPos(d0, d1 + (double)playerentity.func_70047_e(), d2);
                BlockState blockstate1 = this.field_78455_a.field_71441_e.func_180495_p(blockpos);
                if (!blockstate1.func_215696_m((IBlockReader)this.field_78455_a.field_71441_e, blockpos)) continue;
                blockstate = blockstate1;
                overlayPos = blockpos;
            }
            if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
                Object overlayType = Reflector.getFieldValue(Reflector.RenderBlockOverlayEvent_OverlayType_BLOCK);
                if (!Reflector.callBoolean(Reflector.ForgeEventFactory_renderBlockOverlay, this.field_78455_a.field_71439_g, Float.valueOf(partialTicks), overlayType, blockstate, overlayPos)) {
                    this.func_178108_a(this.field_78455_a.func_175602_ab().func_175023_a().func_178122_a(blockstate));
                }
            }
        }
        if (!this.field_78455_a.field_71439_g.func_175149_v()) {
            if (this.field_78455_a.field_71439_g.func_208600_a(FluidTags.field_206959_a) && !Reflector.callBoolean(Reflector.ForgeEventFactory_renderWaterOverlay, this.field_78455_a.field_71439_g, Float.valueOf(partialTicks))) {
                this.func_78448_c(partialTicks);
            }
            if (this.field_78455_a.field_71439_g.func_70027_ad() && !Reflector.callBoolean(Reflector.ForgeEventFactory_renderFireOverlay, this.field_78455_a.field_71439_g, Float.valueOf(partialTicks))) {
                this.func_78442_d();
            }
        }
        GlStateManager.enableAlphaTest();
    }

    private void func_178108_a(TextureAtlasSprite sprite) {
        this.field_78455_a.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f = 0.1f;
        GlStateManager.color4f((float)0.1f, (float)0.1f, (float)0.1f, (float)0.5f);
        GlStateManager.pushMatrix();
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = sprite.func_94209_e();
        float f7 = sprite.func_94212_f();
        float f8 = sprite.func_94206_g();
        float f9 = sprite.func_94210_h();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)f7, (double)f9).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)f6, (double)f9).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)f6, (double)f8).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)f7, (double)f8).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void func_78448_c(float partialTicks) {
        if (Config.isShaders() && !Shaders.isUnderwaterOverlay()) {
            return;
        }
        this.field_78455_a.func_110434_K().func_110577_a(field_110929_d);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float f = this.field_78455_a.field_71439_g.func_70013_c();
        GlStateManager.color4f((float)f, (float)f, (float)f, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -this.field_78455_a.field_71439_g.field_70177_z / 64.0f;
        float f8 = this.field_78455_a.field_71439_g.field_70125_A / 64.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
    }

    private void func_78442_d() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        GlStateManager.depthFunc((int)519);
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float f = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GlStateManager.pushMatrix();
            TextureAtlasSprite textureatlassprite = this.field_78455_a.func_147117_R().func_195424_a(ModelBakery.field_207764_b);
            this.field_78455_a.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            float f1 = textureatlassprite.func_94209_e();
            float f2 = textureatlassprite.func_94212_f();
            float f3 = textureatlassprite.func_94206_g();
            float f4 = textureatlassprite.func_94210_h();
            float f5 = -0.5f;
            float f6 = 0.5f;
            float f7 = -0.5f;
            float f8 = 0.5f;
            float f9 = -0.5f;
            GlStateManager.translatef((float)((float)(-(i * 2 - 1)) * 0.24f), (float)-0.3f, (float)0.0f);
            GlStateManager.rotatef((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.setSprite(textureatlassprite);
            bufferbuilder.func_181662_b(-0.5, -0.5, -0.5).func_187315_a((double)f2, (double)f4).func_181675_d();
            bufferbuilder.func_181662_b(0.5, -0.5, -0.5).func_187315_a((double)f1, (double)f4).func_181675_d();
            bufferbuilder.func_181662_b(0.5, 0.5, -0.5).func_187315_a((double)f1, (double)f3).func_181675_d();
            bufferbuilder.func_181662_b(-0.5, 0.5, -0.5).func_187315_a((double)f2, (double)f3).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.depthFunc((int)515);
    }

    public void func_78441_a() {
        this.field_187470_g = this.field_187469_f;
        this.field_187472_i = this.field_187471_h;
        ClientPlayerEntity clientplayerentity = this.field_78455_a.field_71439_g;
        ItemStack itemstack = clientplayerentity.func_184614_ca();
        ItemStack itemstack1 = clientplayerentity.func_184592_cb();
        if (clientplayerentity.func_184838_M()) {
            this.field_187469_f = MathHelper.func_76131_a((float)(this.field_187469_f - 0.4f), (float)0.0f, (float)1.0f);
            this.field_187471_h = MathHelper.func_76131_a((float)(this.field_187471_h - 0.4f), (float)0.0f, (float)1.0f);
        } else {
            float f = clientplayerentity.func_184825_o(1.0f);
            if (Reflector.ForgeHooksClient_shouldCauseReequipAnimation.exists()) {
                boolean requipM = Reflector.callBoolean(Reflector.ForgeHooksClient_shouldCauseReequipAnimation, this.field_187467_d, itemstack, clientplayerentity.field_71071_by.field_70461_c);
                boolean requipO = Reflector.callBoolean(Reflector.ForgeHooksClient_shouldCauseReequipAnimation, this.field_187468_e, itemstack1, -1);
                if (!requipM && !Objects.equals(this.field_187467_d, itemstack)) {
                    this.field_187467_d = itemstack;
                }
                if (!requipM && !Objects.equals(this.field_187468_e, itemstack1)) {
                    this.field_187468_e = itemstack1;
                }
                this.field_187469_f += MathHelper.func_76131_a((float)((!requipM ? f * f * f : 0.0f) - this.field_187469_f), (float)-0.4f, (float)0.4f);
                this.field_187471_h += MathHelper.func_76131_a((float)((float)(!requipO ? 1 : 0) - this.field_187471_h), (float)-0.4f, (float)0.4f);
            } else {
                this.field_187469_f += MathHelper.func_76131_a((float)((Objects.equals(this.field_187467_d, itemstack) ? f * f * f : 0.0f) - this.field_187469_f), (float)-0.4f, (float)0.4f);
                this.field_187471_h += MathHelper.func_76131_a((float)((float)(Objects.equals(this.field_187468_e, itemstack1) ? 1 : 0) - this.field_187471_h), (float)-0.4f, (float)0.4f);
            }
        }
        if (this.field_187469_f < 0.1f) {
            this.field_187467_d = itemstack;
            if (Config.isShaders()) {
                Shaders.setItemToRenderMain((ItemStack)this.field_187467_d);
            }
        }
        if (this.field_187471_h < 0.1f) {
            this.field_187468_e = itemstack1;
            if (Config.isShaders()) {
                Shaders.setItemToRenderOff((ItemStack)this.field_187468_e);
            }
        }
    }

    public void func_187460_a(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.field_187469_f = 0.0f;
        } else {
            this.field_187471_h = 0.0f;
        }
    }
}

