/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.primitives.Floats;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.render.RenderEnv;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class BufferBuilder {
    private static final Logger field_187316_a = LogManager.getLogger();
    private ByteBuffer field_179001_a;
    public IntBuffer field_178999_b;
    private ShortBuffer field_181676_c;
    public FloatBuffer field_179000_c;
    public int field_178997_d;
    private VertexFormatElement field_181677_f;
    private int field_181678_g;
    private boolean field_78939_q;
    public int field_179006_k;
    private double field_179004_l;
    private double field_179005_m;
    private double field_179002_n;
    private VertexFormat field_179011_q;
    private boolean field_179010_r;
    private BlockRenderLayer blockLayer = null;
    private boolean[] drawnIcons = new boolean[256];
    private TextureAtlasSprite[] quadSprites = null;
    private TextureAtlasSprite[] quadSpritesPrev = null;
    private TextureAtlasSprite quadSprite = null;
    public SVertexBuilder sVertexBuilder;
    public RenderEnv renderEnv = null;
    public BitSet animatedSprites = null;
    public BitSet animatedSpritesCached = new BitSet();

    public BufferBuilder(int bufferSizeIn) {
        this.field_179001_a = GLAllocation.func_74524_c((int)(bufferSizeIn * 4));
        this.field_178999_b = this.field_179001_a.asIntBuffer();
        this.field_181676_c = this.field_179001_a.asShortBuffer();
        this.field_179000_c = this.field_179001_a.asFloatBuffer();
        SVertexBuilder.initVertexBuilder((BufferBuilder)this);
    }

    private void func_181670_b(int increaseAmount) {
        if (this.field_178997_d * this.field_179011_q.func_177338_f() + increaseAmount > this.field_179001_a.capacity()) {
            int i = this.field_179001_a.capacity();
            int j = i + BufferBuilder.func_216566_c((int)increaseAmount);
            field_187316_a.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)i, (Object)j);
            int k = this.field_178999_b.position();
            ByteBuffer bytebuffer = GLAllocation.func_74524_c((int)j);
            this.field_179001_a.position(0);
            bytebuffer.put(this.field_179001_a);
            bytebuffer.rewind();
            this.field_179001_a = bytebuffer;
            this.field_179000_c = this.field_179001_a.asFloatBuffer();
            this.field_178999_b = this.field_179001_a.asIntBuffer();
            this.field_178999_b.position(k);
            this.field_181676_c = this.field_179001_a.asShortBuffer();
            this.field_181676_c.position(k << 1);
            if (this.quadSprites != null) {
                TextureAtlasSprite[] sprites = this.quadSprites;
                int quadSize = this.getBufferQuadSize();
                this.quadSprites = new TextureAtlasSprite[quadSize];
                System.arraycopy(sprites, 0, this.quadSprites, 0, Math.min(sprites.length, this.quadSprites.length));
                this.quadSpritesPrev = null;
            }
        }
    }

    private static int func_216566_c(int xIn) {
        int j;
        int i = 0x200000;
        if (xIn == 0) {
            return i;
        }
        if (xIn < 0) {
            i *= -1;
        }
        return (j = xIn % i) == 0 ? xIn : xIn + i - j;
    }

    public void func_181674_a(float cameraX, float cameraY, float cameraZ) {
        int i = this.field_178997_d / 4;
        float[] afloat = new float[i];
        for (int j = 0; j < i; ++j) {
            afloat[j] = BufferBuilder.func_181665_a((FloatBuffer)this.field_179000_c, (float)((float)((double)cameraX + this.field_179004_l)), (float)((float)((double)cameraY + this.field_179005_m)), (float)((float)((double)cameraZ + this.field_179002_n)), (int)this.field_179011_q.func_181719_f(), (int)(j * this.field_179011_q.func_177338_f()));
        }
        Integer[] ainteger = new Integer[i];
        for (int k = 0; k < ainteger.length; ++k) {
            ainteger[k] = k;
        }
        Arrays.sort(ainteger, (p_210255_1_, p_210255_2_) -> Floats.compare((float)afloat[p_210255_2_], (float)afloat[p_210255_1_]));
        BitSet bitset = new BitSet();
        int l2 = this.field_179011_q.func_177338_f();
        int[] aint = new int[l2];
        int i1 = bitset.nextClearBit(0);
        while (i1 < ainteger.length) {
            int j1 = ainteger[i1];
            if (j1 != i1) {
                this.field_178999_b.limit(j1 * l2 + l2);
                this.field_178999_b.position(j1 * l2);
                this.field_178999_b.get(aint);
                int k1 = j1;
                int l1 = ainteger[j1];
                while (k1 != i1) {
                    this.field_178999_b.limit(l1 * l2 + l2);
                    this.field_178999_b.position(l1 * l2);
                    IntBuffer intbuffer = this.field_178999_b.slice();
                    this.field_178999_b.limit(k1 * l2 + l2);
                    this.field_178999_b.position(k1 * l2);
                    this.field_178999_b.put(intbuffer);
                    bitset.set(k1);
                    k1 = l1;
                    l1 = ainteger[l1];
                }
                this.field_178999_b.limit(i1 * l2 + l2);
                this.field_178999_b.position(i1 * l2);
                this.field_178999_b.put(aint);
            }
            bitset.set(i1);
            i1 = bitset.nextClearBit(i1 + 1);
        }
        this.field_178999_b.limit(this.field_178999_b.capacity());
        this.field_178999_b.position(this.func_181664_j());
        if (this.quadSprites != null) {
            TextureAtlasSprite[] quadSpritesSorted = new TextureAtlasSprite[this.field_178997_d / 4];
            int quadStep = this.field_179011_q.func_177338_f() / 4 * 4;
            int ix = 0;
            while (ix < ainteger.length) {
                int indexQuad = ainteger[ix];
                int indexQuadSorted = ix++;
                quadSpritesSorted[indexQuadSorted] = this.quadSprites[indexQuad];
            }
            System.arraycopy(quadSpritesSorted, 0, this.quadSprites, 0, quadSpritesSorted.length);
        }
    }

    public State func_181672_a() {
        this.field_178999_b.rewind();
        int i = this.func_181664_j();
        this.field_178999_b.limit(i);
        int[] aint = new int[i];
        this.field_178999_b.get(aint);
        this.field_178999_b.limit(this.field_178999_b.capacity());
        this.field_178999_b.position(i);
        TextureAtlasSprite[] quadSpritesCopy = null;
        if (this.quadSprites != null) {
            int countQuads = this.field_178997_d / 4;
            quadSpritesCopy = new TextureAtlasSprite[countQuads];
            System.arraycopy(this.quadSprites, 0, quadSpritesCopy, 0, countQuads);
        }
        return new State(this, aint, new VertexFormat(this.field_179011_q), quadSpritesCopy);
    }

    public int func_181664_j() {
        return this.field_178997_d * this.field_179011_q.func_181719_f();
    }

    private static float func_181665_a(FloatBuffer floatBufferIn, float x, float y, float z, int integerSize, int offset) {
        float f = floatBufferIn.get(offset + integerSize * 0 + 0);
        float f1 = floatBufferIn.get(offset + integerSize * 0 + 1);
        float f2 = floatBufferIn.get(offset + integerSize * 0 + 2);
        float f3 = floatBufferIn.get(offset + integerSize * 1 + 0);
        float f4 = floatBufferIn.get(offset + integerSize * 1 + 1);
        float f5 = floatBufferIn.get(offset + integerSize * 1 + 2);
        float f6 = floatBufferIn.get(offset + integerSize * 2 + 0);
        float f7 = floatBufferIn.get(offset + integerSize * 2 + 1);
        float f8 = floatBufferIn.get(offset + integerSize * 2 + 2);
        float f9 = floatBufferIn.get(offset + integerSize * 3 + 0);
        float f10 = floatBufferIn.get(offset + integerSize * 3 + 1);
        float f11 = floatBufferIn.get(offset + integerSize * 3 + 2);
        float f12 = (f + f3 + f6 + f9) * 0.25f - x;
        float f13 = (f1 + f4 + f7 + f10) * 0.25f - y;
        float f14 = (f2 + f5 + f8 + f11) * 0.25f - z;
        return f12 * f12 + f13 * f13 + f14 * f14;
    }

    public void func_178993_a(State state) {
        this.field_178999_b.clear();
        this.func_181670_b(state.func_179013_a().length * 4);
        this.field_178999_b.put(state.func_179013_a());
        this.field_178997_d = state.func_179014_c();
        this.field_179011_q = new VertexFormat(state.func_179016_d());
        if (State.access$000((State)state) != null) {
            if (this.quadSprites == null) {
                this.quadSprites = this.quadSpritesPrev;
            }
            if (this.quadSprites == null || this.quadSprites.length < this.getBufferQuadSize()) {
                this.quadSprites = new TextureAtlasSprite[this.getBufferQuadSize()];
            }
            TextureAtlasSprite[] src = State.access$000((State)state);
            System.arraycopy(src, 0, this.quadSprites, 0, src.length);
        } else {
            if (this.quadSprites != null) {
                this.quadSpritesPrev = this.quadSprites;
            }
            this.quadSprites = null;
        }
    }

    public void func_178965_a() {
        this.field_178997_d = 0;
        this.field_181677_f = null;
        this.field_181678_g = 0;
        this.quadSprite = null;
        if (SmartAnimations.isActive()) {
            if (this.animatedSprites == null) {
                this.animatedSprites = this.animatedSpritesCached;
            }
            this.animatedSprites.clear();
        } else if (this.animatedSprites != null) {
            this.animatedSprites = null;
        }
    }

    public void func_181668_a(int glMode, VertexFormat format) {
        if (this.field_179010_r) {
            throw new IllegalStateException("Already building!");
        }
        this.field_179010_r = true;
        this.func_178965_a();
        this.field_179006_k = glMode;
        this.field_179011_q = format;
        this.field_181677_f = format.func_177348_c(this.field_181678_g);
        this.field_78939_q = false;
        this.field_179001_a.limit(this.field_179001_a.capacity());
        if (Config.isShaders()) {
            SVertexBuilder.endSetVertexFormat((BufferBuilder)this);
        }
        if (Config.isMultiTexture()) {
            if (this.blockLayer != null) {
                if (this.quadSprites == null) {
                    this.quadSprites = this.quadSpritesPrev;
                }
                if (this.quadSprites == null || this.quadSprites.length < this.getBufferQuadSize()) {
                    this.quadSprites = new TextureAtlasSprite[this.getBufferQuadSize()];
                }
            }
        } else {
            if (this.quadSprites != null) {
                this.quadSpritesPrev = this.quadSprites;
            }
            this.quadSprites = null;
        }
    }

    public BufferBuilder func_187315_a(double u, double v) {
        if (this.quadSprite != null && this.quadSprites != null) {
            u = this.quadSprite.toSingleU((float)u);
            v = this.quadSprite.toSingleV((float)v);
            this.quadSprites[this.field_178997_d / 4] = this.quadSprite;
        }
        int i = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (1.$SwitchMap$net$minecraft$client$renderer$vertex$VertexFormatElement$Type[this.field_181677_f.func_177367_b().ordinal()]) {
            case 1: {
                this.field_179001_a.putFloat(i, (float)u);
                this.field_179001_a.putFloat(i + 4, (float)v);
                break;
            }
            case 2: 
            case 3: {
                this.field_179001_a.putInt(i, (int)u);
                this.field_179001_a.putInt(i + 4, (int)v);
                break;
            }
            case 4: 
            case 5: {
                this.field_179001_a.putShort(i, (short)v);
                this.field_179001_a.putShort(i + 2, (short)u);
                break;
            }
            case 6: 
            case 7: {
                this.field_179001_a.put(i, (byte)v);
                this.field_179001_a.put(i + 1, (byte)u);
            }
        }
        this.func_181667_k();
        return this;
    }

    public BufferBuilder func_187314_a(int skyLight, int blockLight) {
        int i = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (1.$SwitchMap$net$minecraft$client$renderer$vertex$VertexFormatElement$Type[this.field_181677_f.func_177367_b().ordinal()]) {
            case 1: {
                this.field_179001_a.putFloat(i, skyLight);
                this.field_179001_a.putFloat(i + 4, blockLight);
                break;
            }
            case 2: 
            case 3: {
                this.field_179001_a.putInt(i, skyLight);
                this.field_179001_a.putInt(i + 4, blockLight);
                break;
            }
            case 4: 
            case 5: {
                this.field_179001_a.putShort(i, (short)blockLight);
                this.field_179001_a.putShort(i + 2, (short)skyLight);
                break;
            }
            case 6: 
            case 7: {
                this.field_179001_a.put(i, (byte)blockLight);
                this.field_179001_a.put(i + 1, (byte)skyLight);
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178962_a(int vertex0, int vertex1, int vertex2, int vertex3) {
        int i = (this.field_178997_d - 4) * this.field_179011_q.func_181719_f() + this.field_179011_q.func_177344_b(1) / 4;
        int j = this.field_179011_q.func_177338_f() >> 2;
        this.field_178999_b.put(i, vertex0);
        this.field_178999_b.put(i + j, vertex1);
        this.field_178999_b.put(i + j * 2, vertex2);
        this.field_178999_b.put(i + j * 3, vertex3);
    }

    public void func_178987_a(double x, double y, double z) {
        int i = this.field_179011_q.func_181719_f();
        int j = (this.field_178997_d - 4) * i;
        for (int k = 0; k < 4; ++k) {
            int l2 = j + k * i;
            int i1 = l2 + 1;
            int j1 = i1 + 1;
            this.field_178999_b.put(l2, Float.floatToRawIntBits((float)(x + this.field_179004_l) + Float.intBitsToFloat(this.field_178999_b.get(l2))));
            this.field_178999_b.put(i1, Float.floatToRawIntBits((float)(y + this.field_179005_m) + Float.intBitsToFloat(this.field_178999_b.get(i1))));
            this.field_178999_b.put(j1, Float.floatToRawIntBits((float)(z + this.field_179002_n) + Float.intBitsToFloat(this.field_178999_b.get(j1))));
        }
    }

    public int func_78909_a(int vertexIndex) {
        return ((this.field_178997_d - vertexIndex) * this.field_179011_q.func_177338_f() + this.field_179011_q.func_177340_e()) / 4;
    }

    public void func_178978_a(float red, float green, float blue, int vertexIndex) {
        int i = this.func_78909_a(vertexIndex);
        int j = -1;
        if (!this.field_78939_q) {
            j = this.field_178999_b.get(i);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                int k = (int)((float)(j & 0xFF) * red);
                int l2 = (int)((float)(j >> 8 & 0xFF) * green);
                int i1 = (int)((float)(j >> 16 & 0xFF) * blue);
                j &= 0xFF000000;
                j = j | i1 << 16 | l2 << 8 | k;
            } else {
                int j1 = (int)((float)(j >> 24 & 0xFF) * red);
                int k1 = (int)((float)(j >> 16 & 0xFF) * green);
                int l1 = (int)((float)(j >> 8 & 0xFF) * blue);
                j &= 0xFF;
                j = j | j1 << 24 | k1 << 16 | l1 << 8;
            }
        }
        this.field_178999_b.put(i, j);
    }

    private void func_192836_a(int argb, int vertexIndex) {
        int i = this.func_78909_a(vertexIndex);
        int j = argb >> 16 & 0xFF;
        int k = argb >> 8 & 0xFF;
        int l2 = argb & 0xFF;
        this.func_178972_a(i, j, k, l2);
    }

    public void func_178994_b(float red, float green, float blue, int vertexIndex) {
        int i = this.func_78909_a(vertexIndex);
        int j = BufferBuilder.func_216567_a((int)((int)(red * 255.0f)), (int)0, (int)255);
        int k = BufferBuilder.func_216567_a((int)((int)(green * 255.0f)), (int)0, (int)255);
        int l2 = BufferBuilder.func_216567_a((int)((int)(blue * 255.0f)), (int)0, (int)255);
        this.func_178972_a(i, j, k, l2);
    }

    private static int func_216567_a(int xIn, int xMin, int xMax) {
        if (xIn < xMin) {
            return xMin;
        }
        return xIn > xMax ? xMax : xIn;
    }

    public void func_178972_a(int index, int red, int green, int blue) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.field_178999_b.put(index, 0xFF000000 | blue << 16 | green << 8 | red);
        } else {
            this.field_178999_b.put(index, red << 24 | green << 16 | blue << 8 | 0xFF);
        }
    }

    public void func_78914_f() {
        this.field_78939_q = true;
    }

    public BufferBuilder func_181666_a(float red, float green, float blue, float alpha) {
        return this.func_181669_b((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public BufferBuilder func_181669_b(int red, int green, int blue, int alpha) {
        if (this.field_78939_q) {
            return this;
        }
        int i = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (1.$SwitchMap$net$minecraft$client$renderer$vertex$VertexFormatElement$Type[this.field_181677_f.func_177367_b().ordinal()]) {
            case 1: {
                this.field_179001_a.putFloat(i, (float)red / 255.0f);
                this.field_179001_a.putFloat(i + 4, (float)green / 255.0f);
                this.field_179001_a.putFloat(i + 8, (float)blue / 255.0f);
                this.field_179001_a.putFloat(i + 12, (float)alpha / 255.0f);
                break;
            }
            case 2: 
            case 3: {
                this.field_179001_a.putFloat(i, red);
                this.field_179001_a.putFloat(i + 4, green);
                this.field_179001_a.putFloat(i + 8, blue);
                this.field_179001_a.putFloat(i + 12, alpha);
                break;
            }
            case 4: 
            case 5: {
                this.field_179001_a.putShort(i, (short)red);
                this.field_179001_a.putShort(i + 2, (short)green);
                this.field_179001_a.putShort(i + 4, (short)blue);
                this.field_179001_a.putShort(i + 6, (short)alpha);
                break;
            }
            case 6: 
            case 7: {
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    this.field_179001_a.put(i, (byte)red);
                    this.field_179001_a.put(i + 1, (byte)green);
                    this.field_179001_a.put(i + 2, (byte)blue);
                    this.field_179001_a.put(i + 3, (byte)alpha);
                    break;
                }
                this.field_179001_a.put(i, (byte)alpha);
                this.field_179001_a.put(i + 1, (byte)blue);
                this.field_179001_a.put(i + 2, (byte)green);
                this.field_179001_a.put(i + 3, (byte)red);
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178981_a(int[] vertexData) {
        if (Config.isShaders()) {
            SVertexBuilder.beginAddVertexData((BufferBuilder)this, (int[])vertexData);
        }
        this.func_181670_b(vertexData.length * 4 + this.field_179011_q.func_177338_f());
        this.field_178999_b.position(this.func_181664_j());
        this.field_178999_b.put(vertexData);
        this.field_178997_d += vertexData.length / this.field_179011_q.func_181719_f();
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertexData((BufferBuilder)this);
        }
    }

    public void func_181675_d() {
        ++this.field_178997_d;
        this.func_181670_b(this.field_179011_q.func_177338_f());
        this.field_181678_g = 0;
        this.field_181677_f = this.field_179011_q.func_177348_c(this.field_181678_g);
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertex((BufferBuilder)this);
        }
    }

    public BufferBuilder func_181662_b(double x, double y, double z) {
        if (Config.isShaders()) {
            SVertexBuilder.beginAddVertex((BufferBuilder)this);
        }
        int i = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (1.$SwitchMap$net$minecraft$client$renderer$vertex$VertexFormatElement$Type[this.field_181677_f.func_177367_b().ordinal()]) {
            case 1: {
                this.field_179001_a.putFloat(i, (float)(x + this.field_179004_l));
                this.field_179001_a.putFloat(i + 4, (float)(y + this.field_179005_m));
                this.field_179001_a.putFloat(i + 8, (float)(z + this.field_179002_n));
                break;
            }
            case 2: 
            case 3: {
                this.field_179001_a.putInt(i, Float.floatToRawIntBits((float)(x + this.field_179004_l)));
                this.field_179001_a.putInt(i + 4, Float.floatToRawIntBits((float)(y + this.field_179005_m)));
                this.field_179001_a.putInt(i + 8, Float.floatToRawIntBits((float)(z + this.field_179002_n)));
                break;
            }
            case 4: 
            case 5: {
                this.field_179001_a.putShort(i, (short)(x + this.field_179004_l));
                this.field_179001_a.putShort(i + 2, (short)(y + this.field_179005_m));
                this.field_179001_a.putShort(i + 4, (short)(z + this.field_179002_n));
                break;
            }
            case 6: 
            case 7: {
                this.field_179001_a.put(i, (byte)(x + this.field_179004_l));
                this.field_179001_a.put(i + 1, (byte)(y + this.field_179005_m));
                this.field_179001_a.put(i + 2, (byte)(z + this.field_179002_n));
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178975_e(float x, float y, float z) {
        int i = (byte)(x * 127.0f) & 0xFF;
        int j = (byte)(y * 127.0f) & 0xFF;
        int k = (byte)(z * 127.0f) & 0xFF;
        int l2 = i | j << 8 | k << 16;
        int i1 = this.field_179011_q.func_177338_f() >> 2;
        int j1 = (this.field_178997_d - 4) * i1 + this.field_179011_q.func_177342_c() / 4;
        this.field_178999_b.put(j1, l2);
        this.field_178999_b.put(j1 + i1, l2);
        this.field_178999_b.put(j1 + i1 * 2, l2);
        this.field_178999_b.put(j1 + i1 * 3, l2);
    }

    private void func_181667_k() {
        ++this.field_181678_g;
        this.field_181678_g %= this.field_179011_q.func_177345_h();
        this.field_181677_f = this.field_179011_q.func_177348_c(this.field_181678_g);
        if (this.field_181677_f.func_177375_c() == VertexFormatElement.Usage.PADDING) {
            this.func_181667_k();
        }
    }

    public BufferBuilder func_181663_c(float x, float y, float z) {
        int i = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (1.$SwitchMap$net$minecraft$client$renderer$vertex$VertexFormatElement$Type[this.field_181677_f.func_177367_b().ordinal()]) {
            case 1: {
                this.field_179001_a.putFloat(i, x);
                this.field_179001_a.putFloat(i + 4, y);
                this.field_179001_a.putFloat(i + 8, z);
                break;
            }
            case 2: 
            case 3: {
                this.field_179001_a.putInt(i, (int)x);
                this.field_179001_a.putInt(i + 4, (int)y);
                this.field_179001_a.putInt(i + 8, (int)z);
                break;
            }
            case 4: 
            case 5: {
                this.field_179001_a.putShort(i, (short)((int)(x * 32767.0f) & 0xFFFF));
                this.field_179001_a.putShort(i + 2, (short)((int)(y * 32767.0f) & 0xFFFF));
                this.field_179001_a.putShort(i + 4, (short)((int)(z * 32767.0f) & 0xFFFF));
                break;
            }
            case 6: 
            case 7: {
                this.field_179001_a.put(i, (byte)((int)(x * 127.0f) & 0xFF));
                this.field_179001_a.put(i + 1, (byte)((int)(y * 127.0f) & 0xFF));
                this.field_179001_a.put(i + 2, (byte)((int)(z * 127.0f) & 0xFF));
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178969_c(double x, double y, double z) {
        this.field_179004_l = x;
        this.field_179005_m = y;
        this.field_179002_n = z;
    }

    public void func_178977_d() {
        if (!this.field_179010_r) {
            throw new IllegalStateException("Not building!");
        }
        this.field_179010_r = false;
        this.field_179001_a.position(0);
        this.field_179001_a.limit(this.func_181664_j() * 4);
    }

    public ByteBuffer func_178966_f() {
        return this.field_179001_a;
    }

    public VertexFormat func_178973_g() {
        return this.field_179011_q;
    }

    public int func_178989_h() {
        return this.field_178997_d;
    }

    public int func_178979_i() {
        return this.field_179006_k;
    }

    public void func_178968_d(int argb) {
        for (int i = 0; i < 4; ++i) {
            this.func_192836_a(argb, i + 1);
        }
    }

    public void func_178990_f(float red, float green, float blue) {
        for (int i = 0; i < 4; ++i) {
            this.func_178994_b(red, green, blue, i + 1);
        }
    }

    public void putSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            int countQuads = this.field_178997_d / 4;
            this.quadSprites[countQuads - 1] = sprite;
        }
    }

    public void setSprite(TextureAtlasSprite sprite) {
        if (this.animatedSprites != null && sprite != null && sprite.getAnimationIndex() >= 0) {
            this.animatedSprites.set(sprite.getAnimationIndex());
        }
        if (this.quadSprites != null) {
            this.quadSprite = sprite;
        }
    }

    public boolean isMultiTexture() {
        return this.quadSprites != null;
    }

    public void drawMultiTexture() {
        if (this.quadSprites == null) {
            return;
        }
        int maxTextureIndex = Config.getMinecraft().func_147117_R().getCountRegisteredSprites();
        if (this.drawnIcons.length <= maxTextureIndex) {
            this.drawnIcons = new boolean[maxTextureIndex + 1];
        }
        Arrays.fill(this.drawnIcons, false);
        int texSwitch = 0;
        int grassOverlayIndex = -1;
        int countQuads = this.field_178997_d / 4;
        for (int i = 0; i < countQuads; ++i) {
            int iconIndex;
            TextureAtlasSprite icon = this.quadSprites[i];
            if (icon == null || this.drawnIcons[iconIndex = icon.getIndexInMap()]) continue;
            if (icon == TextureUtils.iconGrassSideOverlay) {
                if (grassOverlayIndex >= 0) continue;
                grassOverlayIndex = i;
                continue;
            }
            i = this.drawForIcon(icon, i) - 1;
            ++texSwitch;
            if (this.blockLayer == BlockRenderLayer.TRANSLUCENT) continue;
            this.drawnIcons[iconIndex] = true;
        }
        if (grassOverlayIndex >= 0) {
            this.drawForIcon((TextureAtlasSprite)TextureUtils.iconGrassSideOverlay, grassOverlayIndex);
            ++texSwitch;
        }
        if (texSwitch > 0) {
            // empty if block
        }
    }

    private int drawForIcon(TextureAtlasSprite sprite, int startQuadPos) {
        GL11.glBindTexture((int)3553, (int)sprite.glSpriteTextureId);
        int firstRegionEnd = -1;
        int lastPos = -1;
        int countQuads = this.field_178997_d / 4;
        for (int i = startQuadPos; i < countQuads; ++i) {
            TextureAtlasSprite ts = this.quadSprites[i];
            if (ts == sprite) {
                if (lastPos >= 0) continue;
                lastPos = i;
                continue;
            }
            if (lastPos < 0) continue;
            this.draw(lastPos, i);
            if (this.blockLayer == BlockRenderLayer.TRANSLUCENT) {
                return i;
            }
            lastPos = -1;
            if (firstRegionEnd >= 0) continue;
            firstRegionEnd = i;
        }
        if (lastPos >= 0) {
            this.draw(lastPos, countQuads);
        }
        if (firstRegionEnd < 0) {
            firstRegionEnd = countQuads;
        }
        return firstRegionEnd;
    }

    private void draw(int startQuadVertex, int endQuadVertex) {
        int vxQuadCount = endQuadVertex - startQuadVertex;
        if (vxQuadCount <= 0) {
            return;
        }
        int startVertex = startQuadVertex * 4;
        int vxCount = vxQuadCount * 4;
        GL11.glDrawArrays((int)this.field_179006_k, (int)startVertex, (int)vxCount);
    }

    public void setBlockLayer(BlockRenderLayer blockLayer) {
        this.blockLayer = blockLayer;
        if (blockLayer == null) {
            if (this.quadSprites != null) {
                this.quadSpritesPrev = this.quadSprites;
            }
            this.quadSprites = null;
            this.quadSprite = null;
        }
    }

    private int getBufferQuadSize() {
        int quadSize = this.field_178999_b.capacity() * 4 / (this.field_179011_q.func_181719_f() * 4);
        return quadSize;
    }

    public RenderEnv getRenderEnv(BlockState blockStateIn, BlockPos blockPosIn) {
        if (this.renderEnv == null) {
            this.renderEnv = new RenderEnv(blockStateIn, blockPosIn);
            return this.renderEnv;
        }
        this.renderEnv.reset(blockStateIn, blockPosIn);
        return this.renderEnv;
    }

    public boolean isDrawing() {
        return this.field_179010_r;
    }

    public double getXOffset() {
        return this.field_179004_l;
    }

    public double getYOffset() {
        return this.field_179005_m;
    }

    public double getZOffset() {
        return this.field_179002_n;
    }

    public BlockRenderLayer getBlockLayer() {
        return this.blockLayer;
    }

    public void putColorMultiplierRgba(float red, float green, float blue, float alpha, int vertexIndex) {
        int index = this.func_78909_a(vertexIndex);
        int col = -1;
        if (!this.field_78939_q) {
            col = this.field_178999_b.get(index);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                int r = (int)((float)(col & 0xFF) * red);
                int g = (int)((float)(col >> 8 & 0xFF) * green);
                int b2 = (int)((float)(col >> 16 & 0xFF) * blue);
                int a2 = (int)((float)(col >> 24 & 0xFF) * alpha);
                col = a2 << 24 | b2 << 16 | g << 8 | r;
            } else {
                int r = (int)((float)(col >> 24 & 0xFF) * red);
                int g = (int)((float)(col >> 16 & 0xFF) * green);
                int b3 = (int)((float)(col >> 8 & 0xFF) * blue);
                int a3 = (int)((float)(col & 0xFF) * alpha);
                col = r << 24 | g << 16 | b3 << 8 | a3;
            }
        }
        this.field_178999_b.put(index, col);
    }

    public void putColorRGBA(int index, int red, int green, int blue, int alpha) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.field_178999_b.put(index, alpha << 24 | blue << 16 | green << 8 | red);
        } else {
            this.field_178999_b.put(index, red << 24 | green << 16 | blue << 8 | alpha);
        }
    }

    public boolean isColorDisabled() {
        return this.field_78939_q;
    }

    public void putBulkData(ByteBuffer buffer) {
        if (Config.isShaders()) {
            SVertexBuilder.beginAddVertexData((BufferBuilder)this, (ByteBuffer)buffer);
        }
        this.func_181670_b(buffer.limit() + this.field_179011_q.func_177338_f());
        this.field_179001_a.position(this.field_178997_d * this.field_179011_q.func_177338_f());
        this.field_179001_a.put(buffer);
        this.field_178997_d += buffer.limit() / this.field_179011_q.func_177338_f();
        if (Config.isShaders()) {
            SVertexBuilder.endAddVertexData((BufferBuilder)this);
        }
    }
}

