/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import java.util.List;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiAnimationSettingsOF;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiDetailSettingsOF;
import net.optifine.gui.GuiOtherSettingsOF;
import net.optifine.gui.GuiPerformanceSettingsOF;
import net.optifine.gui.GuiQualitySettingsOF;
import net.optifine.gui.GuiScreenButtonOF;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipManager;
import net.optifine.gui.TooltipProvider;
import net.optifine.gui.TooltipProviderOptions;
import net.optifine.shaders.gui.GuiShaders;
import net.optifine.util.GuiUtils;
import org.lwjgl.glfw.GLFW;

public class VideoSettingsScreen
extends GuiScreenOF {
    private Screen field_146498_f;
    private GameSettings field_146499_g;
    private static AbstractOption[] videoOptions = new AbstractOption[]{AbstractOption.field_216712_s, AbstractOption.field_216706_m, AbstractOption.field_216709_p, AbstractOption.field_216701_h, AbstractOption.AO_LEVEL, AbstractOption.field_216692_P, AbstractOption.field_216713_t, AbstractOption.USE_VBO, AbstractOption.field_216703_j, AbstractOption.field_216710_q, AbstractOption.DYNAMIC_LIGHTS, AbstractOption.DYNAMIC_FOV};
    private TooltipManager tooltipManager = new TooltipManager((Screen)this, (TooltipProvider)new TooltipProviderOptions());
    private List<Widget> buttonList = this.buttons;
    private Widget buttonGuiScale;

    public VideoSettingsScreen(Screen par1GuiScreen, GameSettings par2GameSettings) {
        super((ITextComponent)new TranslationTextComponent("options.videoTitle", new Object[0]));
        this.field_146498_f = par1GuiScreen;
        this.field_146499_g = par2GameSettings;
    }

    public void init() {
        this.buttonList.clear();
        for (int i = 0; i < videoOptions.length; ++i) {
            AbstractOption opt = videoOptions[i];
            if (opt == null) continue;
            int x = this.width / 2 - 155 + i % 2 * 160;
            int y = this.height / 6 + 21 * (i / 2) - 12;
            Widget guiElement = this.addButton(opt.func_216586_a(this.minecraft.field_71474_y, x, y, 150));
            if (opt != AbstractOption.field_216713_t) continue;
            this.buttonGuiScale = guiElement;
        }
        int y = this.height / 6 + 21 * (videoOptions.length / 2) - 12;
        int x = 0;
        x = this.width / 2 - 155 + 0;
        this.addButton((Widget)new GuiScreenButtonOF(231, x, y, Lang.get("of.options.shaders")));
        x = this.width / 2 - 155 + 160;
        this.addButton((Widget)new GuiScreenButtonOF(202, x, y, Lang.get("of.options.quality")));
        x = this.width / 2 - 155 + 0;
        this.addButton((Widget)new GuiScreenButtonOF(201, x, y += 21, Lang.get("of.options.details")));
        x = this.width / 2 - 155 + 160;
        this.addButton((Widget)new GuiScreenButtonOF(212, x, y, Lang.get("of.options.performance")));
        x = this.width / 2 - 155 + 0;
        this.addButton((Widget)new GuiScreenButtonOF(211, x, y += 21, Lang.get("of.options.animations")));
        x = this.width / 2 - 155 + 160;
        this.addButton((Widget)new GuiScreenButtonOF(222, x, y, Lang.get("of.options.other")));
        y += 21;
        this.addButton((Widget)new GuiButtonOF(200, this.width / 2 - 100, this.height / 6 + 168 + 11, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    protected void actionPerformed(Widget button) {
        if (button == this.buttonGuiScale) {
            this.updateGuiScale();
        }
        if (!(button instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF gbo = (GuiButtonOF)button;
        this.actionPerformed(gbo, 1);
    }

    protected void actionPerformedRightClick(Widget button) {
        if (button == this.buttonGuiScale) {
            AbstractOption.field_216713_t.func_216722_a(this.field_146499_g, -1);
            this.updateGuiScale();
        }
    }

    private void updateGuiScale() {
        this.minecraft.func_213226_a();
        MainWindow mw = this.minecraft.field_195558_d;
        int btnWidth = GuiUtils.getWidth((Widget)this.buttonGuiScale);
        int btnHeight = GuiUtils.getHeight((Widget)this.buttonGuiScale);
        int x = this.buttonGuiScale.x + (btnWidth - btnHeight);
        int y = this.buttonGuiScale.y + btnHeight / 2;
        GLFW.glfwSetCursorPos((long)mw.func_198092_i(), (double)((double)x * mw.func_198100_s()), (double)((double)y * mw.func_198100_s()));
    }

    private void actionPerformed(GuiButtonOF button, int val) {
        GuiScreenOF scr;
        if (!button.active) {
            return;
        }
        if (button.id == 200) {
            this.minecraft.field_71474_y.func_74303_b();
            this.minecraft.func_147108_a(this.field_146498_f);
        }
        if (button.id == 201) {
            this.minecraft.field_71474_y.func_74303_b();
            scr = new GuiDetailSettingsOF((Screen)this, this.field_146499_g);
            this.minecraft.func_147108_a((Screen)scr);
        }
        if (button.id == 202) {
            this.minecraft.field_71474_y.func_74303_b();
            scr = new GuiQualitySettingsOF((Screen)this, this.field_146499_g);
            this.minecraft.func_147108_a((Screen)scr);
        }
        if (button.id == 211) {
            this.minecraft.field_71474_y.func_74303_b();
            scr = new GuiAnimationSettingsOF((Screen)this, this.field_146499_g);
            this.minecraft.func_147108_a((Screen)scr);
        }
        if (button.id == 212) {
            this.minecraft.field_71474_y.func_74303_b();
            scr = new GuiPerformanceSettingsOF((Screen)this, this.field_146499_g);
            this.minecraft.func_147108_a((Screen)scr);
        }
        if (button.id == 222) {
            this.minecraft.field_71474_y.func_74303_b();
            scr = new GuiOtherSettingsOF((Screen)this, this.field_146499_g);
            this.minecraft.func_147108_a((Screen)scr);
        }
        if (button.id == 231) {
            if (Config.isAntialiasing() || Config.isAntialiasingConfigured()) {
                Config.showGuiMessage(Lang.get("of.message.shaders.aa1"), Lang.get("of.message.shaders.aa2"));
                return;
            }
            if (Config.isAnisotropicFiltering()) {
                Config.showGuiMessage(Lang.get("of.message.shaders.af1"), Lang.get("of.message.shaders.af2"));
                return;
            }
            if (Config.isFastRender()) {
                Config.showGuiMessage(Lang.get("of.message.shaders.fr1"), Lang.get("of.message.shaders.fr2"));
                return;
            }
            this.minecraft.field_71474_y.func_74303_b();
            scr = new GuiShaders((Screen)this, this.field_146499_g);
            this.minecraft.func_147108_a((Screen)scr);
        }
    }

    public void removed() {
        this.minecraft.field_71474_y.func_74303_b();
        super.removed();
    }

    public void render(int x, int y, float z) {
        this.renderBackground();
        this.drawCenteredString(this.minecraft.field_71466_p, this.title.func_150254_d(), this.width / 2, 15, 0xFFFFFF);
        String ver = Config.getVersion();
        String ed = "HD_U";
        if (ed.equals("HD")) {
            ver = "OptiFine HD F1";
        }
        if (ed.equals("HD_U")) {
            ver = "OptiFine HD F1 Ultra";
        }
        if (ed.equals("L")) {
            ver = "OptiFine F1 Light";
        }
        this.drawString(this.minecraft.field_71466_p, ver, 2, this.height - 10, 0x808080);
        String verMc = "Minecraft 1.14.2";
        int lenMc = this.minecraft.field_71466_p.func_78256_a(verMc);
        this.drawString(this.minecraft.field_71466_p, verMc, this.width - lenMc - 2, this.height - 10, 0x808080);
        super.render(x, y, z);
        this.tooltipManager.drawTooltips(x, y, this.buttonList);
    }

    public static String getGuiChatText(ChatScreen guiChat) {
        return guiChat.field_146415_a.func_146179_b();
    }
}

