/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.overlay.DebugOverlayGui;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.LightType;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.TextureAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.util.NativeMemory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebugOverlayGui
extends AbstractGui {
    private static final Map<Heightmap.Type, String> field_212923_a = (Map)Util.func_200696_a(new EnumMap(Heightmap.Type.class), p_212918_0_ -> {
        p_212918_0_.put(Heightmap.Type.WORLD_SURFACE_WG, "SW");
        p_212918_0_.put(Heightmap.Type.WORLD_SURFACE, "S");
        p_212918_0_.put(Heightmap.Type.OCEAN_FLOOR_WG, "OW");
        p_212918_0_.put(Heightmap.Type.OCEAN_FLOOR, "O");
        p_212918_0_.put(Heightmap.Type.MOTION_BLOCKING, "M");
        p_212918_0_.put(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft field_175242_a;
    private final FontRenderer field_175241_f;
    private RayTraceResult field_211537_g;
    private RayTraceResult field_211538_h;
    @Nullable
    private ChunkPos field_212924_f;
    @Nullable
    private Chunk field_212925_g;
    @Nullable
    private CompletableFuture<Chunk> field_212926_h;
    private String debugOF = null;
    private String lastServerLight = "";
    private String lastSH = "";

    public DebugOverlayGui(Minecraft p_i192_1_) {
        this.field_175242_a = p_i192_1_;
        this.field_175241_f = p_i192_1_.field_71466_p;
    }

    public void func_212921_a() {
        this.field_212926_h = null;
        this.field_212925_g = null;
    }

    public void func_194818_a() {
        this.field_175242_a.func_213239_aq().func_76320_a("debug");
        GlStateManager.pushMatrix();
        Entity entity = this.field_175242_a.func_175606_aa();
        this.field_211537_g = entity.func_213324_a(20.0, 0.0f, false);
        this.field_211538_h = entity.func_213324_a(20.0, 0.0f, true);
        this.func_180798_a();
        this.func_194819_c();
        GlStateManager.popMatrix();
        if (this.field_175242_a.field_71474_y.field_181657_aC) {
            int i = this.field_175242_a.field_195558_d.func_198107_o();
            this.func_212920_a(this.field_175242_a.func_181539_aj(), 0, i / 2, true);
            IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
            if (integratedserver != null) {
                this.func_212920_a(integratedserver.func_213210_aR(), i - Math.min(i / 2, 240), i / 2, false);
            }
        }
        this.field_175242_a.func_213239_aq().func_76319_b();
    }

    protected void func_180798_a() {
        List list = this.func_209011_c();
        list.add("");
        boolean flag = this.field_175242_a.func_71401_C() != null;
        list.add("Debug: Pie [shift]: " + (this.field_175242_a.field_71474_y.field_74329_Q ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.field_175242_a.field_71474_y.field_181657_aC ? "visible" : "hidden"));
        list.add("For help: press F3 + Q");
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            this.field_175241_f.getClass();
            int j = 9;
            int k = this.field_175241_f.func_78256_a(s);
            int l2 = 2;
            int i1 = 2 + j * i;
            DebugOverlayGui.fill((int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
            this.field_175241_f.func_211126_b(s, 2.0f, (float)i1, 0xE0E0E0);
        }
    }

    protected void func_194819_c() {
        List list = this.func_175238_c();
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            this.field_175241_f.getClass();
            int j = 9;
            int k = this.field_175241_f.func_78256_a(s);
            int l2 = this.field_175242_a.field_195558_d.func_198107_o() - 2 - k;
            int i1 = 2 + j * i;
            DebugOverlayGui.fill((int)(l2 - 1), (int)(i1 - 1), (int)(l2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
            this.field_175241_f.func_211126_b(s, (float)l2, (float)i1, 0xE0E0E0);
        }
    }

    protected List<String> func_209011_c() {
        AbstractStringBuilder sb;
        List list = this.getInfoLeft();
        if (this.field_175242_a.field_71426_K != this.debugOF) {
            sb = new StringBuffer(this.field_175242_a.field_71426_K);
            int fpsMin = Config.getFpsMin();
            int posFps = this.field_175242_a.field_71426_K.indexOf(" fps ");
            if (posFps >= 0) {
                ((StringBuffer)sb).insert(posFps, "/" + fpsMin);
            }
            if (Config.isSmoothFps()) {
                ((StringBuffer)sb).append(" sf");
            }
            if (Config.isFastRender()) {
                ((StringBuffer)sb).append(" fr");
            }
            if (Config.isAnisotropicFiltering()) {
                ((StringBuffer)sb).append(" af");
            }
            if (Config.isAntialiasing()) {
                ((StringBuffer)sb).append(" aa");
            }
            if (Config.isRenderRegions()) {
                ((StringBuffer)sb).append(" reg");
            }
            if (Config.isShaders()) {
                ((StringBuffer)sb).append(" sh");
            }
            this.debugOF = this.field_175242_a.field_71426_K = ((StringBuffer)sb).toString();
        }
        sb = new StringBuilder();
        AtlasTexture tm = Config.getTextureMap();
        ((StringBuilder)sb).append(", A: ");
        if (SmartAnimations.isActive()) {
            ((StringBuilder)sb).append(tm.getCountAnimationsActive() + TextureAnimations.getCountAnimationsActive());
            ((StringBuilder)sb).append("/");
        }
        ((StringBuilder)sb).append(tm.getCountAnimations() + TextureAnimations.getCountAnimations());
        String ofInfo = ((StringBuilder)sb).toString();
        for (int i = 0; i < list.size(); ++i) {
            String line = (String)list.get(i);
            if (line == null || !line.startsWith("P: ")) continue;
            line = line + ofInfo;
            list.set(i, line);
            break;
        }
        return list;
    }

    protected List<String> getInfoLeft() {
        World world;
        String s1;
        IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
        NetworkManager networkmanager = this.field_175242_a.func_147114_u().func_147298_b();
        float f = networkmanager.func_211390_n();
        float f1 = networkmanager.func_211393_m();
        String s = integratedserver != null ? String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedserver.func_211149_aT()), Float.valueOf(f), Float.valueOf(f1)) : String.format("\"%s\" server, %.0f tx, %.0f rx", this.field_175242_a.field_71439_g.func_142021_k(), Float.valueOf(f), Float.valueOf(f1));
        BlockPos blockpos = new BlockPos(this.field_175242_a.func_175606_aa().field_70165_t, this.field_175242_a.func_175606_aa().func_174813_aQ().field_72338_b, this.field_175242_a.func_175606_aa().field_70161_v);
        if (this.field_175242_a.func_189648_am()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ")", this.field_175242_a.field_71426_K, s, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u(), "", String.format("Chunk-relative: %d %d %d", blockpos.func_177958_n() & 0xF, blockpos.func_177956_o() & 0xF, blockpos.func_177952_p() & 0xF)});
        }
        Entity entity = this.field_175242_a.func_175606_aa();
        Direction direction = entity.func_174811_aO();
        switch (1.$SwitchMap$net$minecraft$util$Direction[direction.ordinal()]) {
            case 1: {
                s1 = "Towards negative Z";
                break;
            }
            case 2: {
                s1 = "Towards positive Z";
                break;
            }
            case 3: {
                s1 = "Towards negative X";
                break;
            }
            case 4: {
                s1 = "Towards positive X";
                break;
            }
            default: {
                s1 = "Invalid";
            }
        }
        ChunkPos chunkpos = new ChunkPos(blockpos);
        if (!Objects.equals(this.field_212924_f, chunkpos)) {
            this.field_212924_f = chunkpos;
            this.func_212921_a();
        }
        LongSets.EmptySet longset = (world = this.func_212922_g()) instanceof ServerWorld ? ((ServerWorld)world).func_217469_z() : LongSets.EMPTY_SET;
        ArrayList list = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.field_175242_a.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.field_175242_a.func_184123_d()) ? "" : "/" + this.field_175242_a.func_184123_d()) + ")", this.field_175242_a.field_71426_K, s, this.field_175242_a.field_71438_f.func_72735_c(), this.field_175242_a.field_71438_f.func_72723_d(), "P: " + this.field_175242_a.field_71452_i.func_78869_b() + ". T: " + this.field_175242_a.field_71441_e.func_217425_f(), this.field_175242_a.field_71441_e.func_72827_u()});
        String s2 = this.func_223101_g();
        if (s2 != null) {
            list.add(s2);
        }
        list.add(DimensionType.func_212678_a((DimensionType)this.field_175242_a.field_71441_e.field_73011_w.func_186058_p()).toString() + " FC: " + Integer.toString(longset.size()));
        list.add("");
        list.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.field_175242_a.func_175606_aa().field_70165_t, this.field_175242_a.func_175606_aa().func_174813_aQ().field_72338_b, this.field_175242_a.func_175606_aa().field_70161_v));
        list.add(String.format("Block: %d %d %d", blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()));
        list.add(String.format("Chunk: %d %d %d in %d %d %d", blockpos.func_177958_n() & 0xF, blockpos.func_177956_o() & 0xF, blockpos.func_177952_p() & 0xF, blockpos.func_177958_n() >> 4, blockpos.func_177956_o() >> 4, blockpos.func_177952_p() >> 4));
        list.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", direction, s1, Float.valueOf(MathHelper.func_76142_g((float)entity.field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)entity.field_70125_A))));
        if (this.field_175242_a.field_71441_e != null) {
            if (this.field_175242_a.field_71441_e.func_175667_e(blockpos)) {
                Chunk chunk = this.func_212916_i();
                if (chunk.func_76621_g()) {
                    list.add("Waiting for chunk...");
                } else {
                    list.add("Client Light: " + chunk.func_177443_a(blockpos, 0) + " (" + this.field_175242_a.field_71441_e.func_175642_b(LightType.SKY, blockpos) + " sky, " + this.field_175242_a.field_71441_e.func_175642_b(LightType.BLOCK, blockpos) + " block)");
                    Chunk chunk1 = this.func_212919_h();
                    if (chunk1 != null) {
                        WorldLightManager worldlightmanager = world.func_72863_F().func_212863_j_();
                        list.add("Server Light: (" + worldlightmanager.func_215569_a(LightType.SKY).func_215611_b(blockpos) + " sky, " + worldlightmanager.func_215569_a(LightType.BLOCK).func_215611_b(blockpos) + " block)");
                        this.lastServerLight = (String)list.get(list.size() - 1);
                    } else if (integratedserver != null) {
                        list.add(this.lastServerLight);
                    }
                    StringBuilder stringbuilder = new StringBuilder("CH");
                    for (Heightmap.Type heightmap$type : Heightmap.Type.values()) {
                        if (!heightmap$type.func_222681_b()) continue;
                        stringbuilder.append(" ").append((String)field_212923_a.get(heightmap$type)).append(": ").append(chunk.func_201576_a(heightmap$type, blockpos.func_177958_n(), blockpos.func_177952_p()));
                    }
                    list.add(stringbuilder.toString());
                    if (chunk1 != null) {
                        stringbuilder.setLength(0);
                        stringbuilder.append("SH");
                        for (Heightmap.Type heightmap$type1 : Heightmap.Type.values()) {
                            if (!heightmap$type1.func_222683_c()) continue;
                            stringbuilder.append(" ").append((String)field_212923_a.get(heightmap$type1)).append(": ").append(chunk1.func_201576_a(heightmap$type1, blockpos.func_177958_n(), blockpos.func_177952_p()));
                        }
                        list.add(stringbuilder.toString());
                        this.lastSH = (String)list.get(list.size() - 1);
                    } else if (integratedserver != null) {
                        list.add(this.lastSH);
                    }
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256) {
                        list.add("Biome: " + Registry.field_212624_m.func_177774_c((Object)chunk.func_217309_c(blockpos)));
                        long i = 0L;
                        float f2 = 0.0f;
                        if (chunk1 != null) {
                            f2 = world.func_130001_d();
                            i = chunk1.func_177416_w();
                        }
                        DifficultyInstance difficultyinstance = new DifficultyInstance(world.func_175659_aa(), world.func_72820_D(), i, f2);
                        list.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyinstance.func_180168_b()), Float.valueOf(difficultyinstance.func_180170_c()), this.field_175242_a.field_71441_e.func_72820_D() / 24000L));
                    }
                }
            } else {
                list.add("Outside of world...");
            }
        } else {
            list.add("Outside of world...");
        }
        if (this.field_175242_a.field_71460_t != null && this.field_175242_a.field_71460_t.func_147702_a()) {
            list.add("Shader: " + this.field_175242_a.field_71460_t.func_147706_e().func_148022_b());
        }
        if (this.field_211537_g.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos1 = ((BlockRayTraceResult)this.field_211537_g).func_216350_a();
            list.add(String.format("Looking at block: %d %d %d", blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p()));
        }
        if (this.field_211538_h.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos2 = ((BlockRayTraceResult)this.field_211538_h).func_216350_a();
            list.add(String.format("Looking at liquid: %d %d %d", blockpos2.func_177958_n(), blockpos2.func_177956_o(), blockpos2.func_177952_p()));
        }
        list.add(this.field_175242_a.func_147118_V().func_215293_f());
        return list;
    }

    @Nullable
    private String func_223101_g() {
        ServerWorld serverworld;
        IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
        if (integratedserver != null && (serverworld = integratedserver.func_71218_a(this.field_175242_a.field_71441_e.func_201675_m().func_186058_p())) != null) {
            return serverworld.func_72827_u();
        }
        return null;
    }

    private World func_212922_g() {
        return (World)DataFixUtils.orElse(Optional.ofNullable(this.field_175242_a.func_71401_C()).map(p_212917_1_ -> p_212917_1_.func_71218_a(this.field_175242_a.field_71441_e.field_73011_w.func_186058_p())), (Object)this.field_175242_a.field_71441_e);
    }

    @Nullable
    private Chunk func_212919_h() {
        if (this.field_212926_h == null) {
            ServerWorld serverworld;
            IntegratedServer integratedserver = this.field_175242_a.func_71401_C();
            if (integratedserver != null && (serverworld = integratedserver.func_71218_a(this.field_175242_a.field_71441_e.field_73011_w.func_186058_p())) != null) {
                this.field_212926_h = serverworld.func_72863_F().func_217232_b(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b, ChunkStatus.field_222617_m, false).thenApply(p_222802_0_ -> (Chunk)p_222802_0_.map(p_222803_0_ -> (Chunk)p_222803_0_, p_222801_0_ -> null));
            }
            if (this.field_212926_h == null) {
                this.field_212926_h = CompletableFuture.completedFuture(this.func_212916_i());
            }
        }
        return this.field_212926_h.getNow(null);
    }

    private Chunk func_212916_i() {
        if (this.field_212925_g == null) {
            this.field_212925_g = this.field_175242_a.field_71441_e.func_212866_a_(this.field_212924_f.field_77276_a, this.field_212924_f.field_77275_b);
        }
        return this.field_212925_g;
    }

    protected List<String> func_175238_c() {
        Entity entity;
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l2 = j - k;
        ArrayList list = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.field_175242_a.func_147111_S() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", l2 * 100L / i, DebugOverlayGui.func_175240_a((long)l2), DebugOverlayGui.func_175240_a((long)i)), String.format("Allocated: % 2d%% %03dMB", j * 100L / i, DebugOverlayGui.func_175240_a((long)j)), "", String.format("CPU: %s", GLX.getCpuInfo()), "", String.format("Display: %dx%d (%s)", Minecraft.func_71410_x().field_195558_d.func_198109_k(), Minecraft.func_71410_x().field_195558_d.func_198091_l(), GLX.getVendor()), GLX.getRenderer(), GLX.getOpenGLVersion()});
        long bufferAllocated = NativeMemory.getBufferAllocated();
        long bufferMaximum = NativeMemory.getBufferMaximum();
        long imageAllocated = NativeMemory.getImageAllocated();
        String strNative = "Native: " + DebugOverlayGui.func_175240_a((long)bufferAllocated) + "/" + DebugOverlayGui.func_175240_a((long)bufferMaximum) + "+" + DebugOverlayGui.func_175240_a((long)imageAllocated) + "MB";
        list.add(3, strNative);
        if (Reflector.BrandingControl_getBrandings.exists()) {
            list.add("");
            list.addAll((Collection)Reflector.call(Reflector.BrandingControl_getBrandings, false, false));
        }
        if (this.field_175242_a.func_189648_am()) {
            return list;
        }
        if (this.field_211537_g.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockRayTraceResult)this.field_211537_g).func_216350_a();
            BlockState blockstate = this.field_175242_a.field_71441_e.func_180495_p(blockpos);
            list.add("");
            list.add(TextFormatting.UNDERLINE + "Targeted Block");
            list.add(String.valueOf(Registry.field_212618_g.func_177774_c((Object)blockstate.func_177230_c())));
            for (Map.Entry entry : blockstate.func_206871_b().entrySet()) {
                list.add(this.func_211534_a(entry));
            }
            for (ResourceLocation resourcelocation : this.field_175242_a.func_147114_u().func_199724_l().func_199717_a().func_199913_a((Object)blockstate.func_177230_c())) {
                list.add("#" + resourcelocation);
            }
        }
        if (this.field_211538_h.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos1 = ((BlockRayTraceResult)this.field_211538_h).func_216350_a();
            IFluidState ifluidstate = this.field_175242_a.field_71441_e.func_204610_c(blockpos1);
            list.add("");
            list.add(TextFormatting.UNDERLINE + "Targeted Fluid");
            list.add(String.valueOf(Registry.field_212619_h.func_177774_c((Object)ifluidstate.func_206886_c())));
            for (Map.Entry entry1 : ifluidstate.func_206871_b().entrySet()) {
                list.add(this.func_211534_a(entry1));
            }
            for (ResourceLocation resourcelocation1 : this.field_175242_a.func_147114_u().func_199724_l().func_205704_c().func_199913_a((Object)ifluidstate.func_206886_c())) {
                list.add("#" + resourcelocation1);
            }
        }
        if ((entity = this.field_175242_a.field_147125_j) != null) {
            list.add("");
            list.add(TextFormatting.UNDERLINE + "Targeted Entity");
            list.add(String.valueOf(Registry.field_212629_r.func_177774_c((Object)entity.func_200600_R())));
        }
        return list;
    }

    private String func_211534_a(Map.Entry<IProperty<?>, Comparable<?>> entryIn) {
        IProperty<?> iproperty = entryIn.getKey();
        Comparable<?> comparable = entryIn.getValue();
        String s = Util.func_200269_a(iproperty, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = TextFormatting.GREEN + s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = TextFormatting.RED + s;
        }
        return iproperty.func_177701_a() + ": " + s;
    }

    private void func_212920_a(FrameTimer frameTimer, int xIn, int widthIn, boolean fpsIn) {
        if (fpsIn) {
            return;
        }
        int widthScaledOF = (int)(512.0 / this.field_175242_a.field_195558_d.func_198100_s());
        xIn = Math.max(xIn, widthScaledOF);
        widthIn = this.field_175242_a.field_195558_d.func_198107_o() - xIn;
        GlStateManager.disableDepthTest();
        int i = frameTimer.func_181749_a();
        int j = frameTimer.func_181750_b();
        long[] along = frameTimer.func_181746_c();
        int l2 = xIn;
        int i1 = Math.max(0, along.length - widthIn);
        int j1 = along.length - i1;
        int lvt_8_1_ = frameTimer.func_181751_b(i + i1);
        long k1 = 0L;
        int l1 = Integer.MAX_VALUE;
        int i2 = Integer.MIN_VALUE;
        for (int j2 = 0; j2 < j1; ++j2) {
            int k2 = (int)(along[frameTimer.func_181751_b(lvt_8_1_ + j2)] / 1000000L);
            l1 = Math.min(l1, k2);
            i2 = Math.max(i2, k2);
            k1 += (long)k2;
        }
        int j3 = this.field_175242_a.field_195558_d.func_198087_p();
        DebugOverlayGui.fill((int)xIn, (int)(j3 - 60), (int)(xIn + j1), (int)j3, (int)-1873784752);
        while (lvt_8_1_ != j) {
            int k3 = frameTimer.func_219792_a(along[lvt_8_1_], fpsIn ? 30 : 60, fpsIn ? 60 : 20);
            int l22 = fpsIn ? 100 : 60;
            int i3 = this.func_181552_c(MathHelper.func_76125_a((int)k3, (int)0, (int)l22), 0, l22 / 2, l22);
            this.vLine(l2, j3, j3 - k3, i3);
            ++l2;
            lvt_8_1_ = frameTimer.func_181751_b(lvt_8_1_ + 1);
        }
        if (fpsIn) {
            DebugOverlayGui.fill((int)(xIn + 1), (int)(j3 - 30 + 1), (int)(xIn + 14), (int)(j3 - 30 + 10), (int)-1873784752);
            this.field_175241_f.func_211126_b("60 FPS", (float)(xIn + 2), (float)(j3 - 30 + 2), 0xE0E0E0);
            this.hLine(xIn, xIn + j1 - 1, j3 - 30, -1);
            DebugOverlayGui.fill((int)(xIn + 1), (int)(j3 - 60 + 1), (int)(xIn + 14), (int)(j3 - 60 + 10), (int)-1873784752);
            this.field_175241_f.func_211126_b("30 FPS", (float)(xIn + 2), (float)(j3 - 60 + 2), 0xE0E0E0);
            this.hLine(xIn, xIn + j1 - 1, j3 - 60, -1);
        } else {
            DebugOverlayGui.fill((int)(xIn + 1), (int)(j3 - 60 + 1), (int)(xIn + 14), (int)(j3 - 60 + 10), (int)-1873784752);
            this.field_175241_f.func_211126_b("20 TPS", (float)(xIn + 2), (float)(j3 - 60 + 2), 0xE0E0E0);
            this.hLine(xIn, xIn + j1 - 1, j3 - 60, -1);
        }
        this.hLine(xIn, xIn + j1 - 1, j3 - 1, -1);
        this.vLine(xIn, j3 - 60, j3, -1);
        this.vLine(xIn + j1 - 1, j3 - 60, j3, -1);
        if (fpsIn && this.field_175242_a.field_71474_y.field_74350_i > 0 && this.field_175242_a.field_71474_y.field_74350_i <= 250) {
            this.hLine(xIn, xIn + j1 - 1, j3 - 1 - (int)(1800.0 / (double)this.field_175242_a.field_71474_y.field_74350_i), -16711681);
        }
        String s = l1 + " ms min";
        String s1 = k1 / (long)j1 + " ms avg";
        String s2 = i2 + " ms max";
        FontRenderer fontrenderer = this.field_175241_f;
        float f = xIn + 2;
        int l3 = j3 - 60;
        this.field_175241_f.getClass();
        fontrenderer.func_175063_a(s, f, (float)(l3 - 9), 0xE0E0E0);
        fontrenderer = this.field_175241_f;
        f = xIn + j1 / 2 - this.field_175241_f.func_78256_a(s1) / 2;
        l3 = j3 - 60;
        this.field_175241_f.getClass();
        fontrenderer.func_175063_a(s1, f, (float)(l3 - 9), 0xE0E0E0);
        fontrenderer = this.field_175241_f;
        f = xIn + j1 - this.field_175241_f.func_78256_a(s2);
        l3 = j3 - 60;
        this.field_175241_f.getClass();
        fontrenderer.func_175063_a(s2, f, (float)(l3 - 9), 0xE0E0E0);
        GlStateManager.enableDepthTest();
    }

    private int func_181552_c(int height, int heightMin, int heightMid, int heightMax) {
        return height < heightMid ? this.func_181553_a(-16711936, -256, (float)height / (float)heightMid) : this.func_181553_a(-256, -65536, (float)(height - heightMid) / (float)(heightMax - heightMid));
    }

    private int func_181553_a(int col1, int col2, float factor) {
        int i = col1 >> 24 & 0xFF;
        int j = col1 >> 16 & 0xFF;
        int k = col1 >> 8 & 0xFF;
        int l2 = col1 & 0xFF;
        int i1 = col2 >> 24 & 0xFF;
        int j1 = col2 >> 16 & 0xFF;
        int k1 = col2 >> 8 & 0xFF;
        int l1 = col2 & 0xFF;
        int i2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)factor, (float)i, (float)i1)), (int)0, (int)255);
        int j2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)factor, (float)j, (float)j1)), (int)0, (int)255);
        int k2 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)factor, (float)k, (float)k1)), (int)0, (int)255);
        int l22 = MathHelper.func_76125_a((int)((int)MathHelper.func_219799_g((float)factor, (float)l2, (float)l1)), (int)0, (int)255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l22;
    }

    private static long func_175240_a(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

