/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.gui.fonts.providers.TextureGlyphProvider;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.render.GlBlendState;
import net.optifine.util.GlyphAdvanceFixed;

public class FontRenderer
implements AutoCloseable {
    public final int field_78288_b = 9;
    public final Random field_78289_c = new Random();
    private final TextureManager field_78298_i;
    private final Font field_211127_e;
    private boolean field_78294_m;
    private boolean blend = false;
    private GlBlendState oldBlendState = new GlBlendState();
    private IGlyph glyphAdvanceSpace = new GlyphAdvanceFixed(4.0f);

    public FontRenderer(TextureManager textureManagerIn, Font fontIn) {
        this.field_78298_i = textureManagerIn;
        this.field_211127_e = fontIn;
    }

    public void func_211568_a(List<IGlyphProvider> gliphProviders) {
        this.field_211127_e.func_211570_a(gliphProviders);
        this.blend = false;
        this.glyphAdvanceSpace = new GlyphAdvanceFixed(4.0f);
        for (IGlyphProvider igp : gliphProviders) {
            if (!(igp instanceof TextureGlyphProvider)) continue;
            TextureGlyphProvider tgp = (TextureGlyphProvider)igp;
            if (tgp.isBlend()) {
                this.blend = true;
            }
            if (!(tgp.getWidthSpace() >= 0.0f)) continue;
            this.glyphAdvanceSpace = new GlyphAdvanceFixed(tgp.getWidthSpace());
        }
    }

    @Override
    public void close() {
        this.field_211127_e.close();
    }

    public int func_175063_a(String text, float x, float y, int color) {
        GlStateManager.enableAlphaTest();
        return this.func_180455_b(text, x, y, color, true);
    }

    public int func_211126_b(String text, float x, float y, int color) {
        GlStateManager.enableAlphaTest();
        return this.func_180455_b(text, x, y, color, false);
    }

    public String func_147647_b(String text) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException var3) {
            return text;
        }
    }

    private int func_180455_b(String text, float x, float y, int color, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        if (this.field_78294_m) {
            text = this.func_147647_b(text);
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (this.blend) {
            GlStateManager.getBlendState((GlBlendState)this.oldBlendState);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        if (dropShadow) {
            this.func_211843_b(text, x, y, color, true);
        }
        x = this.func_211843_b(text, x, y, color, false);
        if (this.blend) {
            GlStateManager.setBlendState((GlBlendState)this.oldBlendState);
        }
        return (int)x + (dropShadow ? 1 : 0);
    }

    private float func_211843_b(String text, float x, float y, int color, boolean isShadow) {
        float f = isShadow ? 0.25f : 1.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f * f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f * f;
        float f3 = (float)(color & 0xFF) / 255.0f * f;
        float f4 = f1;
        float f5 = f2;
        float f6 = f3;
        float f7 = (float)(color >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ResourceLocation resourcelocation = null;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < text.length(); ++i) {
            float f11;
            char c0 = text.charAt(i);
            if (c0 == '\u00a0') {
                c0 = ' ';
            }
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                TextFormatting textformatting = TextFormatting.func_211165_a((char)text.charAt(i + 1));
                if (textformatting != null) {
                    if (textformatting.func_211166_f()) {
                        flag = false;
                        flag1 = false;
                        flag4 = false;
                        flag3 = false;
                        flag2 = false;
                        f4 = f1;
                        f5 = f2;
                        f6 = f3;
                    }
                    if (textformatting.func_211163_e() != null) {
                        int j = textformatting.func_211163_e();
                        if (Config.isCustomColors()) {
                            j = CustomColors.getTextColor(textformatting.func_175746_b(), j);
                        }
                        f4 = (float)(j >> 16 & 0xFF) / 255.0f * f;
                        f5 = (float)(j >> 8 & 0xFF) / 255.0f * f;
                        f6 = (float)(j & 0xFF) / 255.0f * f;
                    } else if (textformatting == TextFormatting.OBFUSCATED) {
                        flag = true;
                    } else if (textformatting == TextFormatting.BOLD) {
                        flag1 = true;
                    } else if (textformatting == TextFormatting.STRIKETHROUGH) {
                        flag4 = true;
                    } else if (textformatting == TextFormatting.UNDERLINE) {
                        flag3 = true;
                    } else if (textformatting == TextFormatting.ITALIC) {
                        flag2 = true;
                    }
                }
                ++i;
                continue;
            }
            IGlyph iglyph = this.findGlyph(c0);
            TexturedGlyph texturedglyph = flag && c0 != ' ' ? this.field_211127_e.func_211188_a(iglyph) : this.field_211127_e.func_211187_a(c0);
            ResourceLocation resourcelocation1 = texturedglyph.func_211233_b();
            if (resourcelocation1 != null) {
                if (resourcelocation != resourcelocation1) {
                    tessellator.func_78381_a();
                    this.field_78298_i.func_110577_a(resourcelocation1);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    resourcelocation = resourcelocation1;
                }
                float f8 = flag1 ? iglyph.getBoldOffset() : 0.0f;
                float f9 = isShadow ? iglyph.getShadowOffset() : 0.0f;
                this.func_212452_a(texturedglyph, flag1, flag2, f8, x + f9, y + f9, bufferbuilder, f4, f5, f6, f7);
            }
            float f10 = iglyph.getAdvance(flag1);
            float f8 = f11 = isShadow ? 1.0f : 0.0f;
            if (flag4) {
                list.add(new Entry(x + f11 - 1.0f, y + f11 + 4.5f, x + f11 + f10, y + f11 + 4.5f - 1.0f, f4, f5, f6, f7, null));
            }
            if (flag3) {
                list.add(new Entry(x + f11 - 1.0f, y + f11 + 9.0f, x + f11 + f10, y + f11 + 9.0f - 1.0f, f4, f5, f6, f7, null));
            }
            x += f10;
        }
        tessellator.func_78381_a();
        if (!list.isEmpty()) {
            GlStateManager.disableTexture();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (Entry fontrenderer$entry : list) {
                fontrenderer$entry.func_211168_a(bufferbuilder);
            }
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
        }
        return x;
    }

    private void func_212452_a(TexturedGlyph glyphIn, boolean boldIn, boolean italicIn, float boldOffsetIn, float xIn, float yIn, BufferBuilder bufferIn, float redIn, float greenIn, float blueIn, float alphaIn) {
        glyphIn.func_211234_a(this.field_78298_i, italicIn, xIn, yIn, bufferIn, redIn, greenIn, blueIn, alphaIn);
        if (boldIn) {
            glyphIn.func_211234_a(this.field_78298_i, italicIn, xIn + boldOffsetIn, yIn, bufferIn, redIn, greenIn, blueIn, alphaIn);
        }
    }

    public int func_78256_a(String text) {
        if (text == null) {
            return 0;
        }
        float f = 0.0f;
        boolean flag = false;
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i < text.length() - 1) {
                TextFormatting textformatting;
                if ((textformatting = TextFormatting.func_211165_a((char)text.charAt(++i))) == TextFormatting.BOLD) {
                    flag = true;
                    continue;
                }
                if (textformatting == null || !textformatting.func_211166_f()) continue;
                flag = false;
                continue;
            }
            f += this.findGlyph(c0).getAdvance(flag);
        }
        return MathHelper.func_76123_f((float)f);
    }

    public float func_211125_a(char character) {
        return character == '\u00a7' ? 0.0f : this.findGlyph(character).getAdvance(false);
    }

    public String func_78269_a(String text, int width) {
        return this.func_78262_a(text, width, false);
    }

    public String func_78262_a(String text, int width, boolean reverse) {
        StringBuilder stringbuilder = new StringBuilder();
        float f = 0.0f;
        int i = reverse ? text.length() - 1 : 0;
        int j = reverse ? -1 : 1;
        boolean flag = false;
        boolean flag1 = false;
        for (int k = i; k >= 0 && k < text.length() && f < (float)width; k += j) {
            char c0 = text.charAt(k);
            if (flag) {
                flag = false;
                TextFormatting textformatting = TextFormatting.func_211165_a((char)c0);
                if (textformatting == TextFormatting.BOLD) {
                    flag1 = true;
                } else if (textformatting != null && textformatting.func_211166_f()) {
                    flag1 = false;
                }
            } else if (c0 == '\u00a7') {
                flag = true;
            } else {
                f += this.func_211125_a(c0);
                if (flag1) {
                    f += 1.0f;
                }
            }
            if (f > (float)width) break;
            if (reverse) {
                stringbuilder.insert(0, c0);
                continue;
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.toString();
    }

    private String func_78273_d(String text) {
        while (text != null && text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public void func_78279_b(String str, int x, int y, int wrapWidth, int textColor) {
        str = this.func_78273_d(str);
        this.func_211124_b(str, x, y, wrapWidth, textColor);
    }

    private void func_211124_b(String str, int x, int y, int wrapWidth, int textColor) {
        for (String s : this.func_78271_c(str, wrapWidth)) {
            float f = x;
            if (this.field_78294_m) {
                int i = this.func_78256_a(this.func_147647_b(s));
                f += (float)(wrapWidth - i);
            }
            this.func_180455_b(s, f, (float)y, textColor, false);
            y += 9;
        }
    }

    public int func_78267_b(String str, int maxLength) {
        return 9 * this.func_78271_c(str, maxLength).size();
    }

    public void func_78275_b(boolean bidiFlagIn) {
        this.field_78294_m = bidiFlagIn;
    }

    public List<String> func_78271_c(String str, int wrapWidth) {
        return Arrays.asList(this.func_78280_d(str, wrapWidth).split("\n"));
    }

    public String func_78280_d(String str, int wrapWidth) {
        String s = "";
        while (!str.isEmpty()) {
            int i = this.func_78259_e(str, wrapWidth);
            if (str.length() <= i) {
                return s + str;
            }
            String s1 = str.substring(0, i);
            char c0 = str.charAt(i);
            boolean flag = c0 == ' ' || c0 == '\n';
            str = TextFormatting.func_211164_a((String)s1) + str.substring(i + (flag ? 1 : 0));
            s = s + s1 + "\n";
        }
        return s;
    }

    public int func_78259_e(String str, int wrapWidth) {
        int k;
        int i = Math.max(1, wrapWidth);
        int j = str.length();
        float f = 0.0f;
        int l2 = -1;
        boolean flag = false;
        boolean flag1 = true;
        for (k = 0; k < j; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case '\u00a7': {
                    TextFormatting textformatting;
                    if (k >= j - 1) break;
                    if ((textformatting = TextFormatting.func_211165_a((char)str.charAt(++k))) == TextFormatting.BOLD) {
                        flag = true;
                        break;
                    }
                    if (textformatting == null || !textformatting.func_211166_f()) break;
                    flag = false;
                    break;
                }
                case ' ': {
                    l2 = k;
                }
                default: {
                    if (f != 0.0f) {
                        flag1 = false;
                    }
                    f += this.func_211125_a(c0);
                    if (!flag) break;
                    f += 1.0f;
                }
            }
            if (c0 == '\n') {
                l2 = ++k;
                break;
            }
            if (!(f > (float)i)) continue;
            if (!flag1) break;
            ++k;
            break;
        }
        return k != j && l2 != -1 && l2 < k ? l2 : k;
    }

    public int func_216863_a(String p_216863_1_, int p_216863_2_, int p_216863_3_, boolean p_216863_4_) {
        int i = p_216863_3_;
        boolean flag = p_216863_2_ < 0;
        int j = Math.abs(p_216863_2_);
        for (int k = 0; k < j; ++k) {
            if (flag) {
                while (p_216863_4_ && i > 0 && (p_216863_1_.charAt(i - 1) == ' ' || p_216863_1_.charAt(i - 1) == '\n')) {
                    --i;
                }
                while (i > 0 && p_216863_1_.charAt(i - 1) != ' ' && p_216863_1_.charAt(i - 1) != '\n') {
                    --i;
                }
                continue;
            }
            int l2 = p_216863_1_.length();
            int i1 = p_216863_1_.indexOf(32, i);
            int j1 = p_216863_1_.indexOf(10, i);
            i = i1 == -1 && j1 == -1 ? -1 : (i1 != -1 && j1 != -1 ? Math.min(i1, j1) : (i1 != -1 ? i1 : j1));
            if (i == -1) {
                i = l2;
                continue;
            }
            while (p_216863_4_ && i < l2 && (p_216863_1_.charAt(i) == ' ' || p_216863_1_.charAt(i) == '\n')) {
                ++i;
            }
        }
        return i;
    }

    public boolean func_78260_a() {
        return this.field_78294_m;
    }

    private IGlyph findGlyph(char ch) {
        if (ch == ' ') {
            return this.glyphAdvanceSpace;
        }
        return this.field_211127_e.func_211184_b(ch);
    }
}

