/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.List;
import net.optifine.Config;
import net.optifine.reflect.Reflector;

public class SpriteDependencies {
    private static int countDependenciesTotal;

    public static ddm resolveDependencies(List<ddm> listRegisteredSprites, int ix2, ddl textureMap) {
        ddm sprite = listRegisteredSprites.get(ix2);
        while (SpriteDependencies.resolveOne(listRegisteredSprites, ix2, sprite, textureMap)) {
            sprite = listRegisteredSprites.get(ix2);
        }
        sprite.isDependencyParent = false;
        return sprite;
    }

    private static boolean resolveOne(List<ddm> listRegisteredSprites, int ix2, ddm sprite, ddl textureMap) {
        int countDep = 0;
        for (pc locDep : sprite.getDependencies()) {
            Config.detail("Sprite dependency: " + sprite.m() + " <- " + locDep);
            ++countDependenciesTotal;
            ddm spriteDep = textureMap.getRegisteredSprite(locDep);
            if (spriteDep == null) {
                spriteDep = textureMap.registerSprite(locDep);
            } else {
                int ixDep = listRegisteredSprites.indexOf(spriteDep);
                if (ixDep <= ix2 + countDep) continue;
                if (spriteDep.isDependencyParent) {
                    String error = "circular dependency: " + sprite.m() + " -> " + spriteDep.m();
                    pc locSpritePng = textureMap.b(sprite.m());
                    Reflector.call(Reflector.ClientHooks_trackBrokenTexture, locSpritePng, error);
                    break;
                }
                listRegisteredSprites.remove(ixDep);
            }
            sprite.isDependencyParent = true;
            listRegisteredSprites.add(ix2 + countDep, spriteDep);
            ++countDep;
        }
        return countDep > 0;
    }

    public static void reset() {
        countDependenciesTotal = 0;
    }

    public static int getCountDependencies() {
        return countDependenciesTotal;
    }
}

