/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.ItemOverrideProperty;
import net.optifine.reflect.Reflector;
import net.optifine.util.CompoundKey;

public class ItemOverrideCache {
    private ItemOverrideProperty[] itemOverrideProperties;
    private Map<CompoundKey, kq> mapValueModels = new HashMap<CompoundKey, kq>();
    public static final kq LOCATION_NULL = new kq("");

    public ItemOverrideCache(ItemOverrideProperty[] itemOverrideProperties) {
        this.itemOverrideProperties = itemOverrideProperties;
    }

    public kq getModelLocation(afj stack, ajs world, sw entity) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return null;
        }
        return this.mapValueModels.get(valueKey);
    }

    public void putModelLocation(afj stack, ajs world, sw entity, kq location) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return;
        }
        this.mapValueModels.put(valueKey, location);
    }

    private CompoundKey getValueKey(afj stack, ajs world, sw entity) {
        Object[] indexes = new Integer[this.itemOverrideProperties.length];
        for (int i = 0; i < indexes.length; ++i) {
            Integer index = this.itemOverrideProperties[i].getValueIndex(stack, world, entity);
            if (index == null) {
                return null;
            }
            indexes[i] = index;
        }
        return new CompoundKey(indexes);
    }

    public static ItemOverrideCache make(List<brn> overrides) {
        if (overrides.isEmpty()) {
            return null;
        }
        if (!Reflector.ItemOverride_mapResourceValues.exists()) {
            return null;
        }
        LinkedHashMap<kq, HashSet<Float>> propertyValues = new LinkedHashMap<kq, HashSet<Float>>();
        for (brn itemOverride : overrides) {
            Map mapResourceValues = (Map)Reflector.getFieldValue(itemOverride, Reflector.ItemOverride_mapResourceValues);
            Set setLocs = mapResourceValues.keySet();
            for (kq loc : setLocs) {
                Float val = (Float)mapResourceValues.get(loc);
                if (val == null) continue;
                HashSet<Float> setValues = (HashSet<Float>)propertyValues.get(loc);
                if (setValues == null) {
                    setValues = new HashSet<Float>();
                    propertyValues.put(loc, setValues);
                }
                setValues.add(val);
            }
        }
        ArrayList<ItemOverrideProperty> listProps = new ArrayList<ItemOverrideProperty>();
        Set setPropertyLocations = propertyValues.keySet();
        for (kq loc : setPropertyLocations) {
            Set setValues = (Set)propertyValues.get(loc);
            float[] values = Floats.toArray((Collection)setValues);
            ItemOverrideProperty prop = new ItemOverrideProperty(loc, values);
            listProps.add(prop);
        }
        ItemOverrideProperty[] props = listProps.toArray(new ItemOverrideProperty[listProps.size()]);
        ItemOverrideCache cache = new ItemOverrideCache(props);
        ItemOverrideCache.logCache(props, overrides);
        return cache;
    }

    private static void logCache(ItemOverrideProperty[] props, List<brn> overrides) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < props.length; ++i) {
            ItemOverrideProperty prop = props[i];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("" + prop.getLocation() + "=" + prop.getValues().length);
        }
        if (overrides.size() > 0) {
            sb.append(" -> " + overrides.get(0).a() + " ...");
        }
        Config.dbg("ItemOverrideCache: " + sb.toString());
    }

    public String toString() {
        return "properties: " + this.itemOverrideProperties.length + ", models: " + this.mapValueModels.size();
    }
}

