/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.DynamicLights;

public class DynamicLight {
    private sn entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;
    private Set<co> setLitChunkPos = new HashSet<co>();
    private co.a blockPosMutable = new co.a();

    public DynamicLight(sn entity) {
        this.entity = entity;
        this.offsetY = entity.bq();
    }

    public void update(bqm renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.p - 0.5;
        double posY = this.entity.q - 0.5 + this.offsetY;
        double posZ = this.entity.r - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx2 = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz2 = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx2) <= delta && Math.abs(dy) <= delta && Math.abs(dz2) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        this.underwater = false;
        bnq world = renderGlobal.getWorld();
        if (world != null) {
            this.blockPosMutable.c(ot.c((double)posX), ot.c((double)posY), ot.c((double)posZ));
            atl state = world.o((co)this.blockPosMutable);
            alu block = state.v();
            this.underwater = block == alv.j;
        }
        HashSet<co> setNewPos = new HashSet<co>();
        if (lightLevel > 0) {
            cv dirX = (ot.c((double)posX) & 0xF) >= 8 ? cv.f : cv.e;
            cv dirY = (ot.c((double)posY) & 0xF) >= 8 ? cv.b : cv.a;
            cv dirZ = (ot.c((double)posZ) & 0xF) >= 8 ? cv.d : cv.c;
            co chunkPos = new co(posX, posY, posZ);
            bte chunk = renderGlobal.getRenderChunk(chunkPos);
            co chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            bte chunkX = renderGlobal.getRenderChunk(chunkPosX);
            co chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            bte chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            co chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            bte chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            co chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            bte chunkY = renderGlobal.getRenderChunk(chunkPosY);
            co chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            bte chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            co chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            bte chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            co chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            bte chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private co getChunkPos(bte renderChunk, co pos, cv facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(bte renderChunk, Set<co> setPrevPos, Set<co> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        btb compiledChunk = renderChunk.h();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        co pos = renderChunk.k().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(bqm renderGlobal) {
        for (co posOld : this.setLitChunkPos) {
            bte chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public sn getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

